"""DO NOT EDIT THIS FILE!

This file is auto generated by github rest api discription.
See https://github.com/github/rest-api-description for more information.
"""


from datetime import datetime
from typing import TYPE_CHECKING, List, Union, Literal

from githubkit.utils import UNSET, Unset, exclude_unset

from .types import (
    AppPermissionsType,
    AppHookConfigPatchBodyType,
    ApplicationsClientIdTokenPostBodyType,
    ApplicationsClientIdTokenPatchBodyType,
    ApplicationsClientIdGrantDeleteBodyType,
    ApplicationsClientIdTokenDeleteBodyType,
    ApplicationsClientIdTokenScopedPostBodyType,
    AppInstallationsInstallationIdAccessTokensPostBodyType,
)
from .models import (
    BasicError,
    Integration,
    HookDelivery,
    Installation,
    Authorization,
    WebhookConfig,
    ValidationError,
    HookDeliveryItem,
    InstallationToken,
    MarketplacePurchase,
    ValidationErrorSimple,
    AppHookConfigPatchBody,
    MarketplaceListingPlan,
    UserMarketplacePurchase,
    UserInstallationsGetResponse200,
    ApplicationsClientIdTokenPostBody,
    ApplicationsClientIdTokenPatchBody,
    ApplicationsClientIdGrantDeleteBody,
    ApplicationsClientIdTokenDeleteBody,
    InstallationRepositoriesGetResponse200,
    ApplicationsClientIdTokenScopedPostBody,
    AppManifestsCodeConversionsPostResponse201,
    AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
    AppInstallationsInstallationIdAccessTokensPostBody,
    UserInstallationsInstallationIdRepositoriesGetResponse200,
)

if TYPE_CHECKING:
    from githubkit.core import GitHubCore
    from githubkit.response import Response


class AppsClient:
    def __init__(self, github: "GitHubCore"):
        self._github = github

    def get_authenticated(
        self,
    ) -> "Response[Integration]":
        url = "/app"

        return self._github.request(
            "GET",
            url,
            response_model=Integration,
        )

    async def async_get_authenticated(
        self,
    ) -> "Response[Integration]":
        url = "/app"

        return await self._github.arequest(
            "GET",
            url,
            response_model=Integration,
        )

    def create_from_manifest(
        self,
        code: str,
    ) -> "Response[AppManifestsCodeConversionsPostResponse201]":
        url = f"/app-manifests/{code}/conversions"

        return self._github.request(
            "POST",
            url,
            response_model=AppManifestsCodeConversionsPostResponse201,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_create_from_manifest(
        self,
        code: str,
    ) -> "Response[AppManifestsCodeConversionsPostResponse201]":
        url = f"/app-manifests/{code}/conversions"

        return await self._github.arequest(
            "POST",
            url,
            response_model=AppManifestsCodeConversionsPostResponse201,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def get_webhook_config_for_app(
        self,
    ) -> "Response[WebhookConfig]":
        url = "/app/hook/config"

        return self._github.request(
            "GET",
            url,
            response_model=WebhookConfig,
        )

    async def async_get_webhook_config_for_app(
        self,
    ) -> "Response[WebhookConfig]":
        url = "/app/hook/config"

        return await self._github.arequest(
            "GET",
            url,
            response_model=WebhookConfig,
        )

    def update_webhook_config_for_app(
        self,
        *,
        url: Union[Unset, str] = UNSET,
        content_type: Union[Unset, str] = UNSET,
        secret: Union[Unset, str] = UNSET,
        insecure_ssl: Union[Unset, Union[str, float]] = UNSET,
    ) -> "Response[WebhookConfig]":
        url = "/app/hook/config"

        json = AppHookConfigPatchBody(
            **{
                "url": url,
                "content_type": content_type,
                "secret": secret,
                "insecure_ssl": insecure_ssl,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=WebhookConfig,
        )

    async def async_update_webhook_config_for_app(
        self,
        *,
        url: Union[Unset, str] = UNSET,
        content_type: Union[Unset, str] = UNSET,
        secret: Union[Unset, str] = UNSET,
        insecure_ssl: Union[Unset, Union[str, float]] = UNSET,
    ) -> "Response[WebhookConfig]":
        url = "/app/hook/config"

        json = AppHookConfigPatchBody(
            **{
                "url": url,
                "content_type": content_type,
                "secret": secret,
                "insecure_ssl": insecure_ssl,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=WebhookConfig,
        )

    def list_webhook_deliveries(
        self,
        per_page: Union[Unset, int] = 30,
        cursor: Union[Unset, str] = UNSET,
    ) -> "Response[List[HookDeliveryItem]]":
        url = "/app/hook/deliveries"

        params = {
            "per_page": per_page,
            "cursor": cursor,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[HookDeliveryItem],
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    async def async_list_webhook_deliveries(
        self,
        per_page: Union[Unset, int] = 30,
        cursor: Union[Unset, str] = UNSET,
    ) -> "Response[List[HookDeliveryItem]]":
        url = "/app/hook/deliveries"

        params = {
            "per_page": per_page,
            "cursor": cursor,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[HookDeliveryItem],
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    def get_webhook_delivery(
        self,
        delivery_id: int,
    ) -> "Response[HookDelivery]":
        url = f"/app/hook/deliveries/{delivery_id}"

        return self._github.request(
            "GET",
            url,
            response_model=HookDelivery,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    async def async_get_webhook_delivery(
        self,
        delivery_id: int,
    ) -> "Response[HookDelivery]":
        url = f"/app/hook/deliveries/{delivery_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=HookDelivery,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    def redeliver_webhook_delivery(
        self,
        delivery_id: int,
    ) -> "Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]":
        url = f"/app/hook/deliveries/{delivery_id}/attempts"

        return self._github.request(
            "POST",
            url,
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    async def async_redeliver_webhook_delivery(
        self,
        delivery_id: int,
    ) -> "Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]":
        url = f"/app/hook/deliveries/{delivery_id}/attempts"

        return await self._github.arequest(
            "POST",
            url,
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    def list_installations(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
        since: Union[Unset, datetime] = UNSET,
        outdated: Union[Unset, str] = UNSET,
    ) -> "Response[List[Installation]]":
        url = "/app/installations"

        params = {
            "per_page": per_page,
            "page": page,
            "since": since,
            "outdated": outdated,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Installation],
        )

    async def async_list_installations(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
        since: Union[Unset, datetime] = UNSET,
        outdated: Union[Unset, str] = UNSET,
    ) -> "Response[List[Installation]]":
        url = "/app/installations"

        params = {
            "per_page": per_page,
            "page": page,
            "since": since,
            "outdated": outdated,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Installation],
        )

    def get_installation(
        self,
        installation_id: int,
    ) -> "Response[Installation]":
        url = f"/app/installations/{installation_id}"

        return self._github.request(
            "GET",
            url,
            response_model=Installation,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_installation(
        self,
        installation_id: int,
    ) -> "Response[Installation]":
        url = f"/app/installations/{installation_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=Installation,
            error_models={
                "404": BasicError,
            },
        )

    def delete_installation(
        self,
        installation_id: int,
    ) -> "Response":
        url = f"/app/installations/{installation_id}"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_installation(
        self,
        installation_id: int,
    ) -> "Response":
        url = f"/app/installations/{installation_id}"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
            },
        )

    def create_installation_access_token(
        self,
        installation_id: int,
        *,
        repositories: Union[Unset, List[str]] = UNSET,
        repository_ids: Union[Unset, List[int]] = UNSET,
        permissions: Union[Unset, AppPermissionsType] = UNSET,
    ) -> "Response[InstallationToken]":
        url = f"/app/installations/{installation_id}/access_tokens"

        json = AppInstallationsInstallationIdAccessTokensPostBody(
            **{
                "repositories": repositories,
                "repository_ids": repository_ids,
                "permissions": permissions,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=InstallationToken,
            error_models={
                "403": BasicError,
                "401": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    async def async_create_installation_access_token(
        self,
        installation_id: int,
        *,
        repositories: Union[Unset, List[str]] = UNSET,
        repository_ids: Union[Unset, List[int]] = UNSET,
        permissions: Union[Unset, AppPermissionsType] = UNSET,
    ) -> "Response[InstallationToken]":
        url = f"/app/installations/{installation_id}/access_tokens"

        json = AppInstallationsInstallationIdAccessTokensPostBody(
            **{
                "repositories": repositories,
                "repository_ids": repository_ids,
                "permissions": permissions,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=InstallationToken,
            error_models={
                "403": BasicError,
                "401": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def suspend_installation(
        self,
        installation_id: int,
    ) -> "Response":
        url = f"/app/installations/{installation_id}/suspended"

        return self._github.request(
            "PUT",
            url,
            error_models={
                "404": BasicError,
            },
        )

    async def async_suspend_installation(
        self,
        installation_id: int,
    ) -> "Response":
        url = f"/app/installations/{installation_id}/suspended"

        return await self._github.arequest(
            "PUT",
            url,
            error_models={
                "404": BasicError,
            },
        )

    def unsuspend_installation(
        self,
        installation_id: int,
    ) -> "Response":
        url = f"/app/installations/{installation_id}/suspended"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
            },
        )

    async def async_unsuspend_installation(
        self,
        installation_id: int,
    ) -> "Response":
        url = f"/app/installations/{installation_id}/suspended"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
            },
        )

    def delete_authorization(
        self,
        client_id: str,
        *,
        access_token: str,
    ) -> "Response":
        url = f"/applications/{client_id}/grant"

        json = ApplicationsClientIdGrantDeleteBody(
            **{
                "access_token": access_token,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            error_models={
                "422": ValidationError,
            },
        )

    async def async_delete_authorization(
        self,
        client_id: str,
        *,
        access_token: str,
    ) -> "Response":
        url = f"/applications/{client_id}/grant"

        json = ApplicationsClientIdGrantDeleteBody(
            **{
                "access_token": access_token,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            error_models={
                "422": ValidationError,
            },
        )

    def check_token(
        self,
        client_id: str,
        *,
        access_token: str,
    ) -> "Response[Authorization]":
        url = f"/applications/{client_id}/token"

        json = ApplicationsClientIdTokenPostBody(
            **{
                "access_token": access_token,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Authorization,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    async def async_check_token(
        self,
        client_id: str,
        *,
        access_token: str,
    ) -> "Response[Authorization]":
        url = f"/applications/{client_id}/token"

        json = ApplicationsClientIdTokenPostBody(
            **{
                "access_token": access_token,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Authorization,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def delete_token(
        self,
        client_id: str,
        *,
        access_token: str,
    ) -> "Response":
        url = f"/applications/{client_id}/token"

        json = ApplicationsClientIdTokenDeleteBody(
            **{
                "access_token": access_token,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            error_models={
                "422": ValidationError,
            },
        )

    async def async_delete_token(
        self,
        client_id: str,
        *,
        access_token: str,
    ) -> "Response":
        url = f"/applications/{client_id}/token"

        json = ApplicationsClientIdTokenDeleteBody(
            **{
                "access_token": access_token,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            error_models={
                "422": ValidationError,
            },
        )

    def reset_token(
        self,
        client_id: str,
        *,
        access_token: str,
    ) -> "Response[Authorization]":
        url = f"/applications/{client_id}/token"

        json = ApplicationsClientIdTokenPatchBody(
            **{
                "access_token": access_token,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=Authorization,
            error_models={
                "422": ValidationError,
            },
        )

    async def async_reset_token(
        self,
        client_id: str,
        *,
        access_token: str,
    ) -> "Response[Authorization]":
        url = f"/applications/{client_id}/token"

        json = ApplicationsClientIdTokenPatchBody(
            **{
                "access_token": access_token,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=Authorization,
            error_models={
                "422": ValidationError,
            },
        )

    def scope_token(
        self,
        client_id: str,
        *,
        access_token: str,
        target: Union[Unset, str] = UNSET,
        target_id: Union[Unset, int] = UNSET,
        repositories: Union[Unset, List[str]] = UNSET,
        repository_ids: Union[Unset, List[int]] = UNSET,
        permissions: Union[Unset, AppPermissionsType] = UNSET,
    ) -> "Response[Authorization]":
        url = f"/applications/{client_id}/token/scoped"

        json = ApplicationsClientIdTokenScopedPostBody(
            **{
                "access_token": access_token,
                "target": target,
                "target_id": target_id,
                "repositories": repositories,
                "repository_ids": repository_ids,
                "permissions": permissions,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Authorization,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    async def async_scope_token(
        self,
        client_id: str,
        *,
        access_token: str,
        target: Union[Unset, str] = UNSET,
        target_id: Union[Unset, int] = UNSET,
        repositories: Union[Unset, List[str]] = UNSET,
        repository_ids: Union[Unset, List[int]] = UNSET,
        permissions: Union[Unset, AppPermissionsType] = UNSET,
    ) -> "Response[Authorization]":
        url = f"/applications/{client_id}/token/scoped"

        json = ApplicationsClientIdTokenScopedPostBody(
            **{
                "access_token": access_token,
                "target": target,
                "target_id": target_id,
                "repositories": repositories,
                "repository_ids": repository_ids,
                "permissions": permissions,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Authorization,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get_by_slug(
        self,
        app_slug: str,
    ) -> "Response[Integration]":
        url = f"/apps/{app_slug}"

        return self._github.request(
            "GET",
            url,
            response_model=Integration,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_get_by_slug(
        self,
        app_slug: str,
    ) -> "Response[Integration]":
        url = f"/apps/{app_slug}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=Integration,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def list_repos_accessible_to_installation(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[InstallationRepositoriesGetResponse200]":
        url = "/installation/repositories"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=InstallationRepositoriesGetResponse200,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_repos_accessible_to_installation(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[InstallationRepositoriesGetResponse200]":
        url = "/installation/repositories"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=InstallationRepositoriesGetResponse200,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def revoke_installation_access_token(
        self,
    ) -> "Response":
        url = "/installation/token"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_revoke_installation_access_token(
        self,
    ) -> "Response":
        url = "/installation/token"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def get_subscription_plan_for_account(
        self,
        account_id: int,
    ) -> "Response[MarketplacePurchase]":
        url = f"/marketplace_listing/accounts/{account_id}"

        return self._github.request(
            "GET",
            url,
            response_model=MarketplacePurchase,
            error_models={
                "404": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_subscription_plan_for_account(
        self,
        account_id: int,
    ) -> "Response[MarketplacePurchase]":
        url = f"/marketplace_listing/accounts/{account_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=MarketplacePurchase,
            error_models={
                "404": BasicError,
                "401": BasicError,
            },
        )

    def list_plans(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[MarketplaceListingPlan]]":
        url = "/marketplace_listing/plans"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[MarketplaceListingPlan],
            error_models={
                "404": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_plans(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[MarketplaceListingPlan]]":
        url = "/marketplace_listing/plans"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[MarketplaceListingPlan],
            error_models={
                "404": BasicError,
                "401": BasicError,
            },
        )

    def list_accounts_for_plan(
        self,
        plan_id: int,
        sort: Union[Unset, Literal["created", "updated"]] = "created",
        direction: Union[Unset, Literal["asc", "desc"]] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[MarketplacePurchase]]":
        url = f"/marketplace_listing/plans/{plan_id}/accounts"

        params = {
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[MarketplacePurchase],
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "401": BasicError,
            },
        )

    async def async_list_accounts_for_plan(
        self,
        plan_id: int,
        sort: Union[Unset, Literal["created", "updated"]] = "created",
        direction: Union[Unset, Literal["asc", "desc"]] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[MarketplacePurchase]]":
        url = f"/marketplace_listing/plans/{plan_id}/accounts"

        params = {
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[MarketplacePurchase],
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "401": BasicError,
            },
        )

    def get_subscription_plan_for_account_stubbed(
        self,
        account_id: int,
    ) -> "Response[MarketplacePurchase]":
        url = f"/marketplace_listing/stubbed/accounts/{account_id}"

        return self._github.request(
            "GET",
            url,
            response_model=MarketplacePurchase,
            error_models={
                "401": BasicError,
            },
        )

    async def async_get_subscription_plan_for_account_stubbed(
        self,
        account_id: int,
    ) -> "Response[MarketplacePurchase]":
        url = f"/marketplace_listing/stubbed/accounts/{account_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=MarketplacePurchase,
            error_models={
                "401": BasicError,
            },
        )

    def list_plans_stubbed(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[MarketplaceListingPlan]]":
        url = "/marketplace_listing/stubbed/plans"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[MarketplaceListingPlan],
            error_models={
                "401": BasicError,
            },
        )

    async def async_list_plans_stubbed(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[MarketplaceListingPlan]]":
        url = "/marketplace_listing/stubbed/plans"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[MarketplaceListingPlan],
            error_models={
                "401": BasicError,
            },
        )

    def list_accounts_for_plan_stubbed(
        self,
        plan_id: int,
        sort: Union[Unset, Literal["created", "updated"]] = "created",
        direction: Union[Unset, Literal["asc", "desc"]] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[MarketplacePurchase]]":
        url = f"/marketplace_listing/stubbed/plans/{plan_id}/accounts"

        params = {
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[MarketplacePurchase],
            error_models={
                "401": BasicError,
            },
        )

    async def async_list_accounts_for_plan_stubbed(
        self,
        plan_id: int,
        sort: Union[Unset, Literal["created", "updated"]] = "created",
        direction: Union[Unset, Literal["asc", "desc"]] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[MarketplacePurchase]]":
        url = f"/marketplace_listing/stubbed/plans/{plan_id}/accounts"

        params = {
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[MarketplacePurchase],
            error_models={
                "401": BasicError,
            },
        )

    def get_org_installation(
        self,
        org: str,
    ) -> "Response[Installation]":
        url = f"/orgs/{org}/installation"

        return self._github.request(
            "GET",
            url,
            response_model=Installation,
        )

    async def async_get_org_installation(
        self,
        org: str,
    ) -> "Response[Installation]":
        url = f"/orgs/{org}/installation"

        return await self._github.arequest(
            "GET",
            url,
            response_model=Installation,
        )

    def get_repo_installation(
        self,
        owner: str,
        repo: str,
    ) -> "Response[Installation]":
        url = f"/repos/{owner}/{repo}/installation"

        return self._github.request(
            "GET",
            url,
            response_model=Installation,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_repo_installation(
        self,
        owner: str,
        repo: str,
    ) -> "Response[Installation]":
        url = f"/repos/{owner}/{repo}/installation"

        return await self._github.arequest(
            "GET",
            url,
            response_model=Installation,
            error_models={
                "404": BasicError,
            },
        )

    def list_installations_for_authenticated_user(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[UserInstallationsGetResponse200]":
        url = "/user/installations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=UserInstallationsGetResponse200,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_installations_for_authenticated_user(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[UserInstallationsGetResponse200]":
        url = "/user/installations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=UserInstallationsGetResponse200,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_installation_repos_for_authenticated_user(
        self,
        installation_id: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[UserInstallationsInstallationIdRepositoriesGetResponse200]":
        url = f"/user/installations/{installation_id}/repositories"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=UserInstallationsInstallationIdRepositoriesGetResponse200,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_list_installation_repos_for_authenticated_user(
        self,
        installation_id: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[UserInstallationsInstallationIdRepositoriesGetResponse200]":
        url = f"/user/installations/{installation_id}/repositories"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=UserInstallationsInstallationIdRepositoriesGetResponse200,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    def add_repo_to_installation_for_authenticated_user(
        self,
        installation_id: int,
        repository_id: int,
    ) -> "Response":
        url = f"/user/installations/{installation_id}/repositories/{repository_id}"

        return self._github.request(
            "PUT",
            url,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_add_repo_to_installation_for_authenticated_user(
        self,
        installation_id: int,
        repository_id: int,
    ) -> "Response":
        url = f"/user/installations/{installation_id}/repositories/{repository_id}"

        return await self._github.arequest(
            "PUT",
            url,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def remove_repo_from_installation_for_authenticated_user(
        self,
        installation_id: int,
        repository_id: int,
    ) -> "Response":
        url = f"/user/installations/{installation_id}/repositories/{repository_id}"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_remove_repo_from_installation_for_authenticated_user(
        self,
        installation_id: int,
        repository_id: int,
    ) -> "Response":
        url = f"/user/installations/{installation_id}/repositories/{repository_id}"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def list_subscriptions_for_authenticated_user(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[UserMarketplacePurchase]]":
        url = "/user/marketplace_purchases"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[UserMarketplacePurchase],
            error_models={
                "401": BasicError,
                "404": BasicError,
            },
        )

    async def async_list_subscriptions_for_authenticated_user(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[UserMarketplacePurchase]]":
        url = "/user/marketplace_purchases"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[UserMarketplacePurchase],
            error_models={
                "401": BasicError,
                "404": BasicError,
            },
        )

    def list_subscriptions_for_authenticated_user_stubbed(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[UserMarketplacePurchase]]":
        url = "/user/marketplace_purchases/stubbed"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[UserMarketplacePurchase],
            error_models={
                "401": BasicError,
            },
        )

    async def async_list_subscriptions_for_authenticated_user_stubbed(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[UserMarketplacePurchase]]":
        url = "/user/marketplace_purchases/stubbed"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[UserMarketplacePurchase],
            error_models={
                "401": BasicError,
            },
        )

    def get_user_installation(
        self,
        username: str,
    ) -> "Response[Installation]":
        url = f"/users/{username}/installation"

        return self._github.request(
            "GET",
            url,
            response_model=Installation,
        )

    async def async_get_user_installation(
        self,
        username: str,
    ) -> "Response[Installation]":
        url = f"/users/{username}/installation"

        return await self._github.arequest(
            "GET",
            url,
            response_model=Installation,
        )
