"""DO NOT EDIT THIS FILE!

This file is auto generated by github rest api discription.
See https://github.com/github/rest-api-description for more information.
"""


from datetime import datetime
from typing import TYPE_CHECKING, List, Union, Literal

from githubkit.utils import UNSET, Unset, exclude_unset

from .types import (
    NotificationsPutBodyType,
    ReposOwnerRepoSubscriptionPutBodyType,
    ReposOwnerRepoNotificationsPutBodyType,
    NotificationsThreadsThreadIdSubscriptionPutBodyType,
)
from .models import (
    Feed,
    Event,
    Thread,
    Stargazer,
    BasicError,
    Repository,
    SimpleUser,
    ValidationError,
    MinimalRepository,
    StarredRepository,
    ThreadSubscription,
    NotificationsPutBody,
    RepositorySubscription,
    NotificationsPutResponse202,
    ReposOwnerRepoSubscriptionPutBody,
    ReposOwnerRepoNotificationsPutBody,
    ReposOwnerRepoNotificationsPutResponse202,
    NotificationsThreadsThreadIdSubscriptionPutBody,
    EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
)

if TYPE_CHECKING:
    from githubkit.core import GitHubCore
    from githubkit.response import Response


class ActivityClient:
    def __init__(self, github: "GitHubCore"):
        self._github = github

    def list_public_events(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Event]]":
        url = "/events"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Event],
            error_models={
                "403": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    async def async_list_public_events(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Event]]":
        url = "/events"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Event],
            error_models={
                "403": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    def get_feeds(
        self,
    ) -> "Response[Feed]":
        url = "/feeds"

        return self._github.request(
            "GET",
            url,
            response_model=Feed,
        )

    async def async_get_feeds(
        self,
    ) -> "Response[Feed]":
        url = "/feeds"

        return await self._github.arequest(
            "GET",
            url,
            response_model=Feed,
        )

    def list_public_events_for_repo_network(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Event]]":
        url = f"/networks/{owner}/{repo}/events"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Event],
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_list_public_events_for_repo_network(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Event]]":
        url = f"/networks/{owner}/{repo}/events"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Event],
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    def list_notifications_for_authenticated_user(
        self,
        all_: Union[Unset, bool] = False,
        participating: Union[Unset, bool] = False,
        since: Union[Unset, datetime] = UNSET,
        before: Union[Unset, datetime] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Thread]]":
        url = "/notifications"

        params = {
            "all": all_,
            "participating": participating,
            "since": since,
            "before": before,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Thread],
            error_models={
                "403": BasicError,
                "401": BasicError,
                "422": ValidationError,
            },
        )

    async def async_list_notifications_for_authenticated_user(
        self,
        all_: Union[Unset, bool] = False,
        participating: Union[Unset, bool] = False,
        since: Union[Unset, datetime] = UNSET,
        before: Union[Unset, datetime] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Thread]]":
        url = "/notifications"

        params = {
            "all": all_,
            "participating": participating,
            "since": since,
            "before": before,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Thread],
            error_models={
                "403": BasicError,
                "401": BasicError,
                "422": ValidationError,
            },
        )

    def mark_notifications_as_read(
        self,
        *,
        last_read_at: Union[Unset, datetime] = UNSET,
        read: Union[Unset, bool] = UNSET,
    ) -> "Response[NotificationsPutResponse202]":
        url = "/notifications"

        json = NotificationsPutBody(
            **{
                "last_read_at": last_read_at,
                "read": read,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=NotificationsPutResponse202,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_mark_notifications_as_read(
        self,
        *,
        last_read_at: Union[Unset, datetime] = UNSET,
        read: Union[Unset, bool] = UNSET,
    ) -> "Response[NotificationsPutResponse202]":
        url = "/notifications"

        json = NotificationsPutBody(
            **{
                "last_read_at": last_read_at,
                "read": read,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=NotificationsPutResponse202,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def get_thread(
        self,
        thread_id: int,
    ) -> "Response[Thread]":
        url = f"/notifications/threads/{thread_id}"

        return self._github.request(
            "GET",
            url,
            response_model=Thread,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_thread(
        self,
        thread_id: int,
    ) -> "Response[Thread]":
        url = f"/notifications/threads/{thread_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=Thread,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def mark_thread_as_read(
        self,
        thread_id: int,
    ) -> "Response":
        url = f"/notifications/threads/{thread_id}"

        return self._github.request(
            "PATCH",
            url,
            error_models={
                "403": BasicError,
            },
        )

    async def async_mark_thread_as_read(
        self,
        thread_id: int,
    ) -> "Response":
        url = f"/notifications/threads/{thread_id}"

        return await self._github.arequest(
            "PATCH",
            url,
            error_models={
                "403": BasicError,
            },
        )

    def get_thread_subscription_for_authenticated_user(
        self,
        thread_id: int,
    ) -> "Response[ThreadSubscription]":
        url = f"/notifications/threads/{thread_id}/subscription"

        return self._github.request(
            "GET",
            url,
            response_model=ThreadSubscription,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_thread_subscription_for_authenticated_user(
        self,
        thread_id: int,
    ) -> "Response[ThreadSubscription]":
        url = f"/notifications/threads/{thread_id}/subscription"

        return await self._github.arequest(
            "GET",
            url,
            response_model=ThreadSubscription,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def set_thread_subscription(
        self,
        thread_id: int,
        *,
        ignored: Union[Unset, bool] = False,
    ) -> "Response[ThreadSubscription]":
        url = f"/notifications/threads/{thread_id}/subscription"

        json = NotificationsThreadsThreadIdSubscriptionPutBody(
            **{
                "ignored": ignored,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=ThreadSubscription,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_set_thread_subscription(
        self,
        thread_id: int,
        *,
        ignored: Union[Unset, bool] = False,
    ) -> "Response[ThreadSubscription]":
        url = f"/notifications/threads/{thread_id}/subscription"

        json = NotificationsThreadsThreadIdSubscriptionPutBody(
            **{
                "ignored": ignored,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=ThreadSubscription,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def delete_thread_subscription(
        self,
        thread_id: int,
    ) -> "Response":
        url = f"/notifications/threads/{thread_id}/subscription"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_delete_thread_subscription(
        self,
        thread_id: int,
    ) -> "Response":
        url = f"/notifications/threads/{thread_id}/subscription"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_public_org_events(
        self,
        org: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Event]]":
        url = f"/orgs/{org}/events"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Event],
        )

    async def async_list_public_org_events(
        self,
        org: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Event]]":
        url = f"/orgs/{org}/events"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Event],
        )

    def list_repo_events(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Event]]":
        url = f"/repos/{owner}/{repo}/events"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Event],
        )

    async def async_list_repo_events(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Event]]":
        url = f"/repos/{owner}/{repo}/events"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Event],
        )

    def list_repo_notifications_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        all_: Union[Unset, bool] = False,
        participating: Union[Unset, bool] = False,
        since: Union[Unset, datetime] = UNSET,
        before: Union[Unset, datetime] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Thread]]":
        url = f"/repos/{owner}/{repo}/notifications"

        params = {
            "all": all_,
            "participating": participating,
            "since": since,
            "before": before,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Thread],
        )

    async def async_list_repo_notifications_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        all_: Union[Unset, bool] = False,
        participating: Union[Unset, bool] = False,
        since: Union[Unset, datetime] = UNSET,
        before: Union[Unset, datetime] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Thread]]":
        url = f"/repos/{owner}/{repo}/notifications"

        params = {
            "all": all_,
            "participating": participating,
            "since": since,
            "before": before,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Thread],
        )

    def mark_repo_notifications_as_read(
        self,
        owner: str,
        repo: str,
        *,
        last_read_at: Union[Unset, datetime] = UNSET,
    ) -> "Response[ReposOwnerRepoNotificationsPutResponse202]":
        url = f"/repos/{owner}/{repo}/notifications"

        json = ReposOwnerRepoNotificationsPutBody(
            **{
                "last_read_at": last_read_at,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=ReposOwnerRepoNotificationsPutResponse202,
        )

    async def async_mark_repo_notifications_as_read(
        self,
        owner: str,
        repo: str,
        *,
        last_read_at: Union[Unset, datetime] = UNSET,
    ) -> "Response[ReposOwnerRepoNotificationsPutResponse202]":
        url = f"/repos/{owner}/{repo}/notifications"

        json = ReposOwnerRepoNotificationsPutBody(
            **{
                "last_read_at": last_read_at,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=ReposOwnerRepoNotificationsPutResponse202,
        )

    def list_stargazers_for_repo(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[Union[List[SimpleUser], List[Stargazer]]]":
        url = f"/repos/{owner}/{repo}/stargazers"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=Union[List[SimpleUser], List[Stargazer]],
            error_models={
                "422": ValidationError,
            },
        )

    async def async_list_stargazers_for_repo(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[Union[List[SimpleUser], List[Stargazer]]]":
        url = f"/repos/{owner}/{repo}/stargazers"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=Union[List[SimpleUser], List[Stargazer]],
            error_models={
                "422": ValidationError,
            },
        )

    def list_watchers_for_repo(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[SimpleUser]]":
        url = f"/repos/{owner}/{repo}/subscribers"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[SimpleUser],
        )

    async def async_list_watchers_for_repo(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[SimpleUser]]":
        url = f"/repos/{owner}/{repo}/subscribers"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[SimpleUser],
        )

    def get_repo_subscription(
        self,
        owner: str,
        repo: str,
    ) -> "Response[RepositorySubscription]":
        url = f"/repos/{owner}/{repo}/subscription"

        return self._github.request(
            "GET",
            url,
            response_model=RepositorySubscription,
            error_models={
                "403": BasicError,
            },
        )

    async def async_get_repo_subscription(
        self,
        owner: str,
        repo: str,
    ) -> "Response[RepositorySubscription]":
        url = f"/repos/{owner}/{repo}/subscription"

        return await self._github.arequest(
            "GET",
            url,
            response_model=RepositorySubscription,
            error_models={
                "403": BasicError,
            },
        )

    def set_repo_subscription(
        self,
        owner: str,
        repo: str,
        *,
        subscribed: Union[Unset, bool] = UNSET,
        ignored: Union[Unset, bool] = UNSET,
    ) -> "Response[RepositorySubscription]":
        url = f"/repos/{owner}/{repo}/subscription"

        json = ReposOwnerRepoSubscriptionPutBody(
            **{
                "subscribed": subscribed,
                "ignored": ignored,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=RepositorySubscription,
        )

    async def async_set_repo_subscription(
        self,
        owner: str,
        repo: str,
        *,
        subscribed: Union[Unset, bool] = UNSET,
        ignored: Union[Unset, bool] = UNSET,
    ) -> "Response[RepositorySubscription]":
        url = f"/repos/{owner}/{repo}/subscription"

        json = ReposOwnerRepoSubscriptionPutBody(
            **{
                "subscribed": subscribed,
                "ignored": ignored,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=RepositorySubscription,
        )

    def delete_repo_subscription(
        self,
        owner: str,
        repo: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/subscription"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_repo_subscription(
        self,
        owner: str,
        repo: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/subscription"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def list_repos_starred_by_authenticated_user(
        self,
        sort: Union[Unset, Literal["created", "updated"]] = "created",
        direction: Union[Unset, Literal["asc", "desc"]] = "desc",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Repository]]":
        url = "/user/starred"

        params = {
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Repository],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_repos_starred_by_authenticated_user(
        self,
        sort: Union[Unset, Literal["created", "updated"]] = "created",
        direction: Union[Unset, Literal["asc", "desc"]] = "desc",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Repository]]":
        url = "/user/starred"

        params = {
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Repository],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def check_repo_is_starred_by_authenticated_user(
        self,
        owner: str,
        repo: str,
    ) -> "Response":
        url = f"/user/starred/{owner}/{repo}"

        return self._github.request(
            "GET",
            url,
            error_models={
                "404": BasicError,
                "401": BasicError,
                "403": BasicError,
            },
        )

    async def async_check_repo_is_starred_by_authenticated_user(
        self,
        owner: str,
        repo: str,
    ) -> "Response":
        url = f"/user/starred/{owner}/{repo}"

        return await self._github.arequest(
            "GET",
            url,
            error_models={
                "404": BasicError,
                "401": BasicError,
                "403": BasicError,
            },
        )

    def star_repo_for_authenticated_user(
        self,
        owner: str,
        repo: str,
    ) -> "Response":
        url = f"/user/starred/{owner}/{repo}"

        return self._github.request(
            "PUT",
            url,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "401": BasicError,
            },
        )

    async def async_star_repo_for_authenticated_user(
        self,
        owner: str,
        repo: str,
    ) -> "Response":
        url = f"/user/starred/{owner}/{repo}"

        return await self._github.arequest(
            "PUT",
            url,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "401": BasicError,
            },
        )

    def unstar_repo_for_authenticated_user(
        self,
        owner: str,
        repo: str,
    ) -> "Response":
        url = f"/user/starred/{owner}/{repo}"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
                "401": BasicError,
                "403": BasicError,
            },
        )

    async def async_unstar_repo_for_authenticated_user(
        self,
        owner: str,
        repo: str,
    ) -> "Response":
        url = f"/user/starred/{owner}/{repo}"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
                "401": BasicError,
                "403": BasicError,
            },
        )

    def list_watched_repos_for_authenticated_user(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[MinimalRepository]]":
        url = "/user/subscriptions"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[MinimalRepository],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_watched_repos_for_authenticated_user(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[MinimalRepository]]":
        url = "/user/subscriptions"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[MinimalRepository],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_events_for_authenticated_user(
        self,
        username: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Event]]":
        url = f"/users/{username}/events"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Event],
        )

    async def async_list_events_for_authenticated_user(
        self,
        username: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Event]]":
        url = f"/users/{username}/events"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Event],
        )

    def list_org_events_for_authenticated_user(
        self,
        username: str,
        org: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Event]]":
        url = f"/users/{username}/events/orgs/{org}"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Event],
        )

    async def async_list_org_events_for_authenticated_user(
        self,
        username: str,
        org: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Event]]":
        url = f"/users/{username}/events/orgs/{org}"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Event],
        )

    def list_public_events_for_user(
        self,
        username: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Event]]":
        url = f"/users/{username}/events/public"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Event],
        )

    async def async_list_public_events_for_user(
        self,
        username: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Event]]":
        url = f"/users/{username}/events/public"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Event],
        )

    def list_received_events_for_user(
        self,
        username: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Event]]":
        url = f"/users/{username}/received_events"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Event],
        )

    async def async_list_received_events_for_user(
        self,
        username: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Event]]":
        url = f"/users/{username}/received_events"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Event],
        )

    def list_received_public_events_for_user(
        self,
        username: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Event]]":
        url = f"/users/{username}/received_events/public"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Event],
        )

    async def async_list_received_public_events_for_user(
        self,
        username: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Event]]":
        url = f"/users/{username}/received_events/public"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Event],
        )

    def list_repos_starred_by_user(
        self,
        username: str,
        sort: Union[Unset, Literal["created", "updated"]] = "created",
        direction: Union[Unset, Literal["asc", "desc"]] = "desc",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[Union[List[StarredRepository], List[Repository]]]":
        url = f"/users/{username}/starred"

        params = {
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=Union[List[StarredRepository], List[Repository]],
        )

    async def async_list_repos_starred_by_user(
        self,
        username: str,
        sort: Union[Unset, Literal["created", "updated"]] = "created",
        direction: Union[Unset, Literal["asc", "desc"]] = "desc",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[Union[List[StarredRepository], List[Repository]]]":
        url = f"/users/{username}/starred"

        params = {
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=Union[List[StarredRepository], List[Repository]],
        )

    def list_repos_watched_by_user(
        self,
        username: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[MinimalRepository]]":
        url = f"/users/{username}/subscriptions"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[MinimalRepository],
        )

    async def async_list_repos_watched_by_user(
        self,
        username: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[MinimalRepository]]":
        url = f"/users/{username}/subscriptions"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[MinimalRepository],
        )
