"""DO NOT EDIT THIS FILE!

This file is auto generated by github rest api discription.
See https://github.com/github/rest-api-description for more information.
"""


from datetime import datetime
from typing import TYPE_CHECKING, List, Union, Literal

from githubkit.utils import UNSET, Unset, exclude_unset

from .types import (
    SelectedActionsType,
    OptOutOidcCustomSubType,
    OrgsOrgActionsPermissionsPutBodyType,
    ActionsWorkflowAccessToRepositoryType,
    OrgsOrgActionsRunnerGroupsPostBodyType,
    ActionsSetDefaultWorkflowPermissionsType,
    OrgsOrgActionsSecretsSecretNamePutBodyType,
    ReposOwnerRepoActionsPermissionsPutBodyType,
    ActionsOidcCustomIssuerPolicyForEnterpriseType,
    OrgsOrgActionsRunnersRunnerIdLabelsPutBodyType,
    OrgsOrgActionsRunnersRunnerIdLabelsPostBodyType,
    ReposOwnerRepoActionsJobsJobIdRerunPostBodyType,
    ReposOwnerRepoActionsRunsRunIdRerunPostBodyType,
    OrgsOrgActionsPermissionsRepositoriesPutBodyType,
    ReposOwnerRepoActionsSecretsSecretNamePutBodyType,
    OrgsOrgActionsRunnerGroupsRunnerGroupIdPatchBodyType,
    ReposOwnerRepoActionsRunnersRunnerIdLabelsPutBodyType,
    OrgsOrgActionsSecretsSecretNameRepositoriesPutBodyType,
    ReposOwnerRepoActionsRunnersRunnerIdLabelsPostBodyType,
    OrgsOrgActionsRunnerGroupsRunnerGroupIdRunnersPutBodyType,
    ReposOwnerRepoActionsRunsRunIdRerunFailedJobsPostBodyType,
    ReposOwnerRepoActionsRunsRunIdPendingDeploymentsPostBodyType,
    OrgsOrgActionsRunnerGroupsRunnerGroupIdRepositoriesPutBodyType,
    ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBodyType,
    ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBodyPropInputsType,
    RepositoriesRepositoryIdEnvironmentsEnvironmentNameSecretsSecretNamePutBodyType,
)
from .models import (
    Job,
    Runner,
    Artifact,
    Workflow,
    BasicError,
    Deployment,
    EmptyObject,
    WorkflowRun,
    ActionsSecret,
    WorkflowUsage,
    RunnerGroupsOrg,
    SelectedActions,
    ActionsCacheList,
    ActionsPublicKey,
    WorkflowRunUsage,
    PendingDeployment,
    RunnerApplication,
    AuthenticationToken,
    OptOutOidcCustomSub,
    EnvironmentApprovals,
    ValidationErrorSimple,
    OrganizationActionsSecret,
    ActionsRepositoryPermissions,
    ActionsCacheUsageByRepository,
    ActionsCacheUsageOrgEnterprise,
    ActionsOrganizationPermissions,
    OrgsOrgActionsPermissionsPutBody,
    ActionsWorkflowAccessToRepository,
    OrgsOrgActionsRunnerGroupsPostBody,
    OrgsOrgActionsRunnersGetResponse200,
    OrgsOrgActionsSecretsGetResponse200,
    ActionsGetDefaultWorkflowPermissions,
    ActionsSetDefaultWorkflowPermissions,
    OrgsOrgActionsSecretsSecretNamePutBody,
    ReposOwnerRepoActionsPermissionsPutBody,
    ReposOwnerRepoActionsRunsGetResponse200,
    OrgsOrgActionsRunnerGroupsGetResponse200,
    ActionsOidcCustomIssuerPolicyForEnterprise,
    OrgsOrgActionsRunnersRunnerIdLabelsPutBody,
    ReposOwnerRepoActionsRunnersGetResponse200,
    ReposOwnerRepoActionsSecretsGetResponse200,
    OrgsOrgActionsRunnersRunnerIdLabelsPostBody,
    ReposOwnerRepoActionsJobsJobIdRerunPostBody,
    ReposOwnerRepoActionsRunsRunIdRerunPostBody,
    OrgsOrgActionsPermissionsRepositoriesPutBody,
    ReposOwnerRepoActionsArtifactsGetResponse200,
    ReposOwnerRepoActionsWorkflowsGetResponse200,
    ReposOwnerRepoActionsSecretsSecretNamePutBody,
    OrgsOrgActionsRunnerGroupsRunnerGroupIdPatchBody,
    ReposOwnerRepoActionsRunsRunIdJobsGetResponse200,
    ReposOwnerRepoActionsRunnersRunnerIdLabelsPutBody,
    OrgsOrgActionsCacheUsageByRepositoryGetResponse200,
    OrgsOrgActionsSecretsSecretNameRepositoriesPutBody,
    ReposOwnerRepoActionsRunnersRunnerIdLabelsPostBody,
    ReposOwnerRepoActionsRunsRunIdRerunPostResponse201,
    OrgsOrgActionsPermissionsRepositoriesGetResponse200,
    ReposOwnerRepoActionsRunsRunIdCancelPostResponse202,
    ReposOwnerRepoActionsSecretsSecretNamePutResponse201,
    OrgsOrgActionsRunnerGroupsRunnerGroupIdRunnersPutBody,
    ReposOwnerRepoActionsRunsRunIdArtifactsGetResponse200,
    ReposOwnerRepoActionsRunsRunIdRerunFailedJobsPostBody,
    ReposOwnerRepoActionsRunsRunIdPendingDeploymentsPostBody,
    OrgsOrgActionsSecretsSecretNameRepositoriesGetResponse200,
    OrgsOrgActionsRunnerGroupsRunnerGroupIdRepositoriesPutBody,
    ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBody,
    ReposOwnerRepoActionsWorkflowsWorkflowIdRunsGetResponse200,
    OrgsOrgActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200,
    EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
    OrgsOrgActionsRunnerGroupsRunnerGroupIdRepositoriesGetResponse200,
    EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200,
    ReposOwnerRepoActionsRunsRunIdAttemptsAttemptNumberJobsGetResponse200,
    RepositoriesRepositoryIdEnvironmentsEnvironmentNameSecretsGetResponse200,
    RepositoriesRepositoryIdEnvironmentsEnvironmentNameSecretsSecretNamePutBody,
)

if TYPE_CHECKING:
    from githubkit.core import GitHubCore
    from githubkit.response import Response


class ActionsClient:
    def __init__(self, github: "GitHubCore"):
        self._github = github

    def get_actions_cache_usage_for_enterprise(
        self,
        enterprise: str,
    ) -> "Response[ActionsCacheUsageOrgEnterprise]":
        url = f"/enterprises/{enterprise}/actions/cache/usage"

        return self._github.request(
            "GET",
            url,
            response_model=ActionsCacheUsageOrgEnterprise,
        )

    async def async_get_actions_cache_usage_for_enterprise(
        self,
        enterprise: str,
    ) -> "Response[ActionsCacheUsageOrgEnterprise]":
        url = f"/enterprises/{enterprise}/actions/cache/usage"

        return await self._github.arequest(
            "GET",
            url,
            response_model=ActionsCacheUsageOrgEnterprise,
        )

    def set_actions_oidc_custom_issuer_policy_for_enterprise(
        self,
        enterprise: str,
        *,
        include_enterprise_slug: Union[Unset, bool] = UNSET,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/oidc/customization/issuer"

        json = ActionsOidcCustomIssuerPolicyForEnterprise(
            **{
                "include_enterprise_slug": include_enterprise_slug,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    async def async_set_actions_oidc_custom_issuer_policy_for_enterprise(
        self,
        enterprise: str,
        *,
        include_enterprise_slug: Union[Unset, bool] = UNSET,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/oidc/customization/issuer"

        json = ActionsOidcCustomIssuerPolicyForEnterprise(
            **{
                "include_enterprise_slug": include_enterprise_slug,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    def get_github_actions_default_workflow_permissions_enterprise(
        self,
        enterprise: str,
    ) -> "Response[ActionsGetDefaultWorkflowPermissions]":
        url = f"/enterprises/{enterprise}/actions/permissions/workflow"

        return self._github.request(
            "GET",
            url,
            response_model=ActionsGetDefaultWorkflowPermissions,
        )

    async def async_get_github_actions_default_workflow_permissions_enterprise(
        self,
        enterprise: str,
    ) -> "Response[ActionsGetDefaultWorkflowPermissions]":
        url = f"/enterprises/{enterprise}/actions/permissions/workflow"

        return await self._github.arequest(
            "GET",
            url,
            response_model=ActionsGetDefaultWorkflowPermissions,
        )

    def set_github_actions_default_workflow_permissions_enterprise(
        self,
        enterprise: str,
        *,
        default_workflow_permissions: Union[Unset, Literal["read", "write"]] = UNSET,
        can_approve_pull_request_reviews: Union[Unset, bool] = UNSET,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/permissions/workflow"

        json = ActionsSetDefaultWorkflowPermissions(
            **{
                "default_workflow_permissions": default_workflow_permissions,
                "can_approve_pull_request_reviews": can_approve_pull_request_reviews,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    async def async_set_github_actions_default_workflow_permissions_enterprise(
        self,
        enterprise: str,
        *,
        default_workflow_permissions: Union[Unset, Literal["read", "write"]] = UNSET,
        can_approve_pull_request_reviews: Union[Unset, bool] = UNSET,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/permissions/workflow"

        json = ActionsSetDefaultWorkflowPermissions(
            **{
                "default_workflow_permissions": default_workflow_permissions,
                "can_approve_pull_request_reviews": can_approve_pull_request_reviews,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    def get_actions_cache_usage_for_org(
        self,
        org: str,
    ) -> "Response[ActionsCacheUsageOrgEnterprise]":
        url = f"/orgs/{org}/actions/cache/usage"

        return self._github.request(
            "GET",
            url,
            response_model=ActionsCacheUsageOrgEnterprise,
        )

    async def async_get_actions_cache_usage_for_org(
        self,
        org: str,
    ) -> "Response[ActionsCacheUsageOrgEnterprise]":
        url = f"/orgs/{org}/actions/cache/usage"

        return await self._github.arequest(
            "GET",
            url,
            response_model=ActionsCacheUsageOrgEnterprise,
        )

    def get_actions_cache_usage_by_repo_for_org(
        self,
        org: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[OrgsOrgActionsCacheUsageByRepositoryGetResponse200]":
        url = f"/orgs/{org}/actions/cache/usage-by-repository"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=OrgsOrgActionsCacheUsageByRepositoryGetResponse200,
        )

    async def async_get_actions_cache_usage_by_repo_for_org(
        self,
        org: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[OrgsOrgActionsCacheUsageByRepositoryGetResponse200]":
        url = f"/orgs/{org}/actions/cache/usage-by-repository"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=OrgsOrgActionsCacheUsageByRepositoryGetResponse200,
        )

    def get_github_actions_permissions_organization(
        self,
        org: str,
    ) -> "Response[ActionsOrganizationPermissions]":
        url = f"/orgs/{org}/actions/permissions"

        return self._github.request(
            "GET",
            url,
            response_model=ActionsOrganizationPermissions,
        )

    async def async_get_github_actions_permissions_organization(
        self,
        org: str,
    ) -> "Response[ActionsOrganizationPermissions]":
        url = f"/orgs/{org}/actions/permissions"

        return await self._github.arequest(
            "GET",
            url,
            response_model=ActionsOrganizationPermissions,
        )

    def set_github_actions_permissions_organization(
        self,
        org: str,
        *,
        enabled_repositories: Literal["all", "none", "selected"],
        allowed_actions: Union[Unset, Literal["all", "local_only", "selected"]] = UNSET,
    ) -> "Response":
        url = f"/orgs/{org}/actions/permissions"

        json = OrgsOrgActionsPermissionsPutBody(
            **{
                "enabled_repositories": enabled_repositories,
                "allowed_actions": allowed_actions,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    async def async_set_github_actions_permissions_organization(
        self,
        org: str,
        *,
        enabled_repositories: Literal["all", "none", "selected"],
        allowed_actions: Union[Unset, Literal["all", "local_only", "selected"]] = UNSET,
    ) -> "Response":
        url = f"/orgs/{org}/actions/permissions"

        json = OrgsOrgActionsPermissionsPutBody(
            **{
                "enabled_repositories": enabled_repositories,
                "allowed_actions": allowed_actions,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    def list_selected_repositories_enabled_github_actions_organization(
        self,
        org: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[OrgsOrgActionsPermissionsRepositoriesGetResponse200]":
        url = f"/orgs/{org}/actions/permissions/repositories"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=OrgsOrgActionsPermissionsRepositoriesGetResponse200,
        )

    async def async_list_selected_repositories_enabled_github_actions_organization(
        self,
        org: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[OrgsOrgActionsPermissionsRepositoriesGetResponse200]":
        url = f"/orgs/{org}/actions/permissions/repositories"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=OrgsOrgActionsPermissionsRepositoriesGetResponse200,
        )

    def set_selected_repositories_enabled_github_actions_organization(
        self,
        org: str,
        *,
        selected_repository_ids: List[int],
    ) -> "Response":
        url = f"/orgs/{org}/actions/permissions/repositories"

        json = OrgsOrgActionsPermissionsRepositoriesPutBody(
            **{
                "selected_repository_ids": selected_repository_ids,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    async def async_set_selected_repositories_enabled_github_actions_organization(
        self,
        org: str,
        *,
        selected_repository_ids: List[int],
    ) -> "Response":
        url = f"/orgs/{org}/actions/permissions/repositories"

        json = OrgsOrgActionsPermissionsRepositoriesPutBody(
            **{
                "selected_repository_ids": selected_repository_ids,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    def enable_selected_repository_github_actions_organization(
        self,
        org: str,
        repository_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/actions/permissions/repositories/{repository_id}"

        return self._github.request(
            "PUT",
            url,
        )

    async def async_enable_selected_repository_github_actions_organization(
        self,
        org: str,
        repository_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/actions/permissions/repositories/{repository_id}"

        return await self._github.arequest(
            "PUT",
            url,
        )

    def disable_selected_repository_github_actions_organization(
        self,
        org: str,
        repository_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/actions/permissions/repositories/{repository_id}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_disable_selected_repository_github_actions_organization(
        self,
        org: str,
        repository_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/actions/permissions/repositories/{repository_id}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def get_allowed_actions_organization(
        self,
        org: str,
    ) -> "Response[SelectedActions]":
        url = f"/orgs/{org}/actions/permissions/selected-actions"

        return self._github.request(
            "GET",
            url,
            response_model=SelectedActions,
        )

    async def async_get_allowed_actions_organization(
        self,
        org: str,
    ) -> "Response[SelectedActions]":
        url = f"/orgs/{org}/actions/permissions/selected-actions"

        return await self._github.arequest(
            "GET",
            url,
            response_model=SelectedActions,
        )

    def set_allowed_actions_organization(
        self,
        org: str,
        *,
        github_owned_allowed: Union[Unset, bool] = UNSET,
        verified_allowed: Union[Unset, bool] = UNSET,
        patterns_allowed: Union[Unset, List[str]] = UNSET,
    ) -> "Response":
        url = f"/orgs/{org}/actions/permissions/selected-actions"

        json = SelectedActions(
            **{
                "github_owned_allowed": github_owned_allowed,
                "verified_allowed": verified_allowed,
                "patterns_allowed": patterns_allowed,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    async def async_set_allowed_actions_organization(
        self,
        org: str,
        *,
        github_owned_allowed: Union[Unset, bool] = UNSET,
        verified_allowed: Union[Unset, bool] = UNSET,
        patterns_allowed: Union[Unset, List[str]] = UNSET,
    ) -> "Response":
        url = f"/orgs/{org}/actions/permissions/selected-actions"

        json = SelectedActions(
            **{
                "github_owned_allowed": github_owned_allowed,
                "verified_allowed": verified_allowed,
                "patterns_allowed": patterns_allowed,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    def get_github_actions_default_workflow_permissions_organization(
        self,
        org: str,
    ) -> "Response[ActionsGetDefaultWorkflowPermissions]":
        url = f"/orgs/{org}/actions/permissions/workflow"

        return self._github.request(
            "GET",
            url,
            response_model=ActionsGetDefaultWorkflowPermissions,
        )

    async def async_get_github_actions_default_workflow_permissions_organization(
        self,
        org: str,
    ) -> "Response[ActionsGetDefaultWorkflowPermissions]":
        url = f"/orgs/{org}/actions/permissions/workflow"

        return await self._github.arequest(
            "GET",
            url,
            response_model=ActionsGetDefaultWorkflowPermissions,
        )

    def set_github_actions_default_workflow_permissions_organization(
        self,
        org: str,
        *,
        default_workflow_permissions: Union[Unset, Literal["read", "write"]] = UNSET,
        can_approve_pull_request_reviews: Union[Unset, bool] = UNSET,
    ) -> "Response":
        url = f"/orgs/{org}/actions/permissions/workflow"

        json = ActionsSetDefaultWorkflowPermissions(
            **{
                "default_workflow_permissions": default_workflow_permissions,
                "can_approve_pull_request_reviews": can_approve_pull_request_reviews,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            error_models={},
        )

    async def async_set_github_actions_default_workflow_permissions_organization(
        self,
        org: str,
        *,
        default_workflow_permissions: Union[Unset, Literal["read", "write"]] = UNSET,
        can_approve_pull_request_reviews: Union[Unset, bool] = UNSET,
    ) -> "Response":
        url = f"/orgs/{org}/actions/permissions/workflow"

        json = ActionsSetDefaultWorkflowPermissions(
            **{
                "default_workflow_permissions": default_workflow_permissions,
                "can_approve_pull_request_reviews": can_approve_pull_request_reviews,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            error_models={},
        )

    def list_self_hosted_runner_groups_for_org(
        self,
        org: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
        visible_to_repository: Union[Unset, str] = UNSET,
    ) -> "Response[OrgsOrgActionsRunnerGroupsGetResponse200]":
        url = f"/orgs/{org}/actions/runner-groups"

        params = {
            "per_page": per_page,
            "page": page,
            "visible_to_repository": visible_to_repository,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=OrgsOrgActionsRunnerGroupsGetResponse200,
        )

    async def async_list_self_hosted_runner_groups_for_org(
        self,
        org: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
        visible_to_repository: Union[Unset, str] = UNSET,
    ) -> "Response[OrgsOrgActionsRunnerGroupsGetResponse200]":
        url = f"/orgs/{org}/actions/runner-groups"

        params = {
            "per_page": per_page,
            "page": page,
            "visible_to_repository": visible_to_repository,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=OrgsOrgActionsRunnerGroupsGetResponse200,
        )

    def create_self_hosted_runner_group_for_org(
        self,
        org: str,
        *,
        name: str,
        visibility: Union[Unset, Literal["selected", "all", "private"]] = "all",
        selected_repository_ids: Union[Unset, List[int]] = UNSET,
        runners: Union[Unset, List[int]] = UNSET,
        allows_public_repositories: Union[Unset, bool] = False,
        restricted_to_workflows: Union[Unset, bool] = False,
        selected_workflows: Union[Unset, List[str]] = UNSET,
    ) -> "Response[RunnerGroupsOrg]":
        url = f"/orgs/{org}/actions/runner-groups"

        json = OrgsOrgActionsRunnerGroupsPostBody(
            **{
                "name": name,
                "visibility": visibility,
                "selected_repository_ids": selected_repository_ids,
                "runners": runners,
                "allows_public_repositories": allows_public_repositories,
                "restricted_to_workflows": restricted_to_workflows,
                "selected_workflows": selected_workflows,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=RunnerGroupsOrg,
        )

    async def async_create_self_hosted_runner_group_for_org(
        self,
        org: str,
        *,
        name: str,
        visibility: Union[Unset, Literal["selected", "all", "private"]] = "all",
        selected_repository_ids: Union[Unset, List[int]] = UNSET,
        runners: Union[Unset, List[int]] = UNSET,
        allows_public_repositories: Union[Unset, bool] = False,
        restricted_to_workflows: Union[Unset, bool] = False,
        selected_workflows: Union[Unset, List[str]] = UNSET,
    ) -> "Response[RunnerGroupsOrg]":
        url = f"/orgs/{org}/actions/runner-groups"

        json = OrgsOrgActionsRunnerGroupsPostBody(
            **{
                "name": name,
                "visibility": visibility,
                "selected_repository_ids": selected_repository_ids,
                "runners": runners,
                "allows_public_repositories": allows_public_repositories,
                "restricted_to_workflows": restricted_to_workflows,
                "selected_workflows": selected_workflows,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=RunnerGroupsOrg,
        )

    def get_self_hosted_runner_group_for_org(
        self,
        org: str,
        runner_group_id: int,
    ) -> "Response[RunnerGroupsOrg]":
        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}"

        return self._github.request(
            "GET",
            url,
            response_model=RunnerGroupsOrg,
        )

    async def async_get_self_hosted_runner_group_for_org(
        self,
        org: str,
        runner_group_id: int,
    ) -> "Response[RunnerGroupsOrg]":
        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=RunnerGroupsOrg,
        )

    def delete_self_hosted_runner_group_from_org(
        self,
        org: str,
        runner_group_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_self_hosted_runner_group_from_org(
        self,
        org: str,
        runner_group_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def update_self_hosted_runner_group_for_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        name: str,
        visibility: Union[Unset, Literal["selected", "all", "private"]] = UNSET,
        allows_public_repositories: Union[Unset, bool] = False,
        restricted_to_workflows: Union[Unset, bool] = False,
        selected_workflows: Union[Unset, List[str]] = UNSET,
    ) -> "Response[RunnerGroupsOrg]":
        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}"

        json = OrgsOrgActionsRunnerGroupsRunnerGroupIdPatchBody(
            **{
                "name": name,
                "visibility": visibility,
                "allows_public_repositories": allows_public_repositories,
                "restricted_to_workflows": restricted_to_workflows,
                "selected_workflows": selected_workflows,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=RunnerGroupsOrg,
        )

    async def async_update_self_hosted_runner_group_for_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        name: str,
        visibility: Union[Unset, Literal["selected", "all", "private"]] = UNSET,
        allows_public_repositories: Union[Unset, bool] = False,
        restricted_to_workflows: Union[Unset, bool] = False,
        selected_workflows: Union[Unset, List[str]] = UNSET,
    ) -> "Response[RunnerGroupsOrg]":
        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}"

        json = OrgsOrgActionsRunnerGroupsRunnerGroupIdPatchBody(
            **{
                "name": name,
                "visibility": visibility,
                "allows_public_repositories": allows_public_repositories,
                "restricted_to_workflows": restricted_to_workflows,
                "selected_workflows": selected_workflows,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=RunnerGroupsOrg,
        )

    def list_repo_access_to_self_hosted_runner_group_in_org(
        self,
        org: str,
        runner_group_id: int,
        page: Union[Unset, int] = 1,
        per_page: Union[Unset, int] = 30,
    ) -> "Response[OrgsOrgActionsRunnerGroupsRunnerGroupIdRepositoriesGetResponse200]":
        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}/repositories"

        params = {
            "page": page,
            "per_page": per_page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=OrgsOrgActionsRunnerGroupsRunnerGroupIdRepositoriesGetResponse200,
        )

    async def async_list_repo_access_to_self_hosted_runner_group_in_org(
        self,
        org: str,
        runner_group_id: int,
        page: Union[Unset, int] = 1,
        per_page: Union[Unset, int] = 30,
    ) -> "Response[OrgsOrgActionsRunnerGroupsRunnerGroupIdRepositoriesGetResponse200]":
        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}/repositories"

        params = {
            "page": page,
            "per_page": per_page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=OrgsOrgActionsRunnerGroupsRunnerGroupIdRepositoriesGetResponse200,
        )

    def set_repo_access_to_self_hosted_runner_group_in_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        selected_repository_ids: List[int],
    ) -> "Response":
        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}/repositories"

        json = OrgsOrgActionsRunnerGroupsRunnerGroupIdRepositoriesPutBody(
            **{
                "selected_repository_ids": selected_repository_ids,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    async def async_set_repo_access_to_self_hosted_runner_group_in_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        selected_repository_ids: List[int],
    ) -> "Response":
        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}/repositories"

        json = OrgsOrgActionsRunnerGroupsRunnerGroupIdRepositoriesPutBody(
            **{
                "selected_repository_ids": selected_repository_ids,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    def add_repo_access_to_self_hosted_runner_group_in_org(
        self,
        org: str,
        runner_group_id: int,
        repository_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}/repositories/{repository_id}"

        return self._github.request(
            "PUT",
            url,
        )

    async def async_add_repo_access_to_self_hosted_runner_group_in_org(
        self,
        org: str,
        runner_group_id: int,
        repository_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}/repositories/{repository_id}"

        return await self._github.arequest(
            "PUT",
            url,
        )

    def remove_repo_access_to_self_hosted_runner_group_in_org(
        self,
        org: str,
        runner_group_id: int,
        repository_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}/repositories/{repository_id}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_remove_repo_access_to_self_hosted_runner_group_in_org(
        self,
        org: str,
        runner_group_id: int,
        repository_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}/repositories/{repository_id}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def list_self_hosted_runners_in_group_for_org(
        self,
        org: str,
        runner_group_id: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[OrgsOrgActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200]":
        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}/runners"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=OrgsOrgActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200,
        )

    async def async_list_self_hosted_runners_in_group_for_org(
        self,
        org: str,
        runner_group_id: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[OrgsOrgActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200]":
        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}/runners"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=OrgsOrgActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200,
        )

    def set_self_hosted_runners_in_group_for_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        runners: List[int],
    ) -> "Response":
        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}/runners"

        json = OrgsOrgActionsRunnerGroupsRunnerGroupIdRunnersPutBody(
            **{
                "runners": runners,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    async def async_set_self_hosted_runners_in_group_for_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        runners: List[int],
    ) -> "Response":
        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}/runners"

        json = OrgsOrgActionsRunnerGroupsRunnerGroupIdRunnersPutBody(
            **{
                "runners": runners,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    def add_self_hosted_runner_to_group_for_org(
        self,
        org: str,
        runner_group_id: int,
        runner_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}/runners/{runner_id}"

        return self._github.request(
            "PUT",
            url,
        )

    async def async_add_self_hosted_runner_to_group_for_org(
        self,
        org: str,
        runner_group_id: int,
        runner_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}/runners/{runner_id}"

        return await self._github.arequest(
            "PUT",
            url,
        )

    def remove_self_hosted_runner_from_group_for_org(
        self,
        org: str,
        runner_group_id: int,
        runner_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}/runners/{runner_id}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_remove_self_hosted_runner_from_group_for_org(
        self,
        org: str,
        runner_group_id: int,
        runner_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}/runners/{runner_id}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def list_self_hosted_runners_for_org(
        self,
        org: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[OrgsOrgActionsRunnersGetResponse200]":
        url = f"/orgs/{org}/actions/runners"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=OrgsOrgActionsRunnersGetResponse200,
        )

    async def async_list_self_hosted_runners_for_org(
        self,
        org: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[OrgsOrgActionsRunnersGetResponse200]":
        url = f"/orgs/{org}/actions/runners"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=OrgsOrgActionsRunnersGetResponse200,
        )

    def list_runner_applications_for_org(
        self,
        org: str,
    ) -> "Response[List[RunnerApplication]]":
        url = f"/orgs/{org}/actions/runners/downloads"

        return self._github.request(
            "GET",
            url,
            response_model=List[RunnerApplication],
        )

    async def async_list_runner_applications_for_org(
        self,
        org: str,
    ) -> "Response[List[RunnerApplication]]":
        url = f"/orgs/{org}/actions/runners/downloads"

        return await self._github.arequest(
            "GET",
            url,
            response_model=List[RunnerApplication],
        )

    def create_registration_token_for_org(
        self,
        org: str,
    ) -> "Response[AuthenticationToken]":
        url = f"/orgs/{org}/actions/runners/registration-token"

        return self._github.request(
            "POST",
            url,
            response_model=AuthenticationToken,
        )

    async def async_create_registration_token_for_org(
        self,
        org: str,
    ) -> "Response[AuthenticationToken]":
        url = f"/orgs/{org}/actions/runners/registration-token"

        return await self._github.arequest(
            "POST",
            url,
            response_model=AuthenticationToken,
        )

    def create_remove_token_for_org(
        self,
        org: str,
    ) -> "Response[AuthenticationToken]":
        url = f"/orgs/{org}/actions/runners/remove-token"

        return self._github.request(
            "POST",
            url,
            response_model=AuthenticationToken,
        )

    async def async_create_remove_token_for_org(
        self,
        org: str,
    ) -> "Response[AuthenticationToken]":
        url = f"/orgs/{org}/actions/runners/remove-token"

        return await self._github.arequest(
            "POST",
            url,
            response_model=AuthenticationToken,
        )

    def get_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
    ) -> "Response[Runner]":
        url = f"/orgs/{org}/actions/runners/{runner_id}"

        return self._github.request(
            "GET",
            url,
            response_model=Runner,
        )

    async def async_get_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
    ) -> "Response[Runner]":
        url = f"/orgs/{org}/actions/runners/{runner_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=Runner,
        )

    def delete_self_hosted_runner_from_org(
        self,
        org: str,
        runner_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/actions/runners/{runner_id}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_self_hosted_runner_from_org(
        self,
        org: str,
        runner_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/actions/runners/{runner_id}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def list_labels_for_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/orgs/{org}/actions/runners/{runner_id}/labels"

        return self._github.request(
            "GET",
            url,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_labels_for_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/orgs/{org}/actions/runners/{runner_id}/labels"

        return await self._github.arequest(
            "GET",
            url,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    def set_custom_labels_for_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        labels: List[str],
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/orgs/{org}/actions/runners/{runner_id}/labels"

        json = OrgsOrgActionsRunnersRunnerIdLabelsPutBody(
            **{
                "labels": labels,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_set_custom_labels_for_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        labels: List[str],
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/orgs/{org}/actions/runners/{runner_id}/labels"

        json = OrgsOrgActionsRunnersRunnerIdLabelsPutBody(
            **{
                "labels": labels,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def add_custom_labels_to_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        labels: List[str],
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/orgs/{org}/actions/runners/{runner_id}/labels"

        json = OrgsOrgActionsRunnersRunnerIdLabelsPostBody(
            **{
                "labels": labels,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_add_custom_labels_to_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        labels: List[str],
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/orgs/{org}/actions/runners/{runner_id}/labels"

        json = OrgsOrgActionsRunnersRunnerIdLabelsPostBody(
            **{
                "labels": labels,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def remove_all_custom_labels_from_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200]":
        url = f"/orgs/{org}/actions/runners/{runner_id}/labels"

        return self._github.request(
            "DELETE",
            url,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200,
            error_models={
                "404": BasicError,
            },
        )

    async def async_remove_all_custom_labels_from_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200]":
        url = f"/orgs/{org}/actions/runners/{runner_id}/labels"

        return await self._github.arequest(
            "DELETE",
            url,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200,
            error_models={
                "404": BasicError,
            },
        )

    def remove_custom_label_from_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        name: str,
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/orgs/{org}/actions/runners/{runner_id}/labels/{name}"

        return self._github.request(
            "DELETE",
            url,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_remove_custom_label_from_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        name: str,
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/orgs/{org}/actions/runners/{runner_id}/labels/{name}"

        return await self._github.arequest(
            "DELETE",
            url,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def list_org_secrets(
        self,
        org: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[OrgsOrgActionsSecretsGetResponse200]":
        url = f"/orgs/{org}/actions/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=OrgsOrgActionsSecretsGetResponse200,
        )

    async def async_list_org_secrets(
        self,
        org: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[OrgsOrgActionsSecretsGetResponse200]":
        url = f"/orgs/{org}/actions/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=OrgsOrgActionsSecretsGetResponse200,
        )

    def get_org_public_key(
        self,
        org: str,
    ) -> "Response[ActionsPublicKey]":
        url = f"/orgs/{org}/actions/secrets/public-key"

        return self._github.request(
            "GET",
            url,
            response_model=ActionsPublicKey,
        )

    async def async_get_org_public_key(
        self,
        org: str,
    ) -> "Response[ActionsPublicKey]":
        url = f"/orgs/{org}/actions/secrets/public-key"

        return await self._github.arequest(
            "GET",
            url,
            response_model=ActionsPublicKey,
        )

    def get_org_secret(
        self,
        org: str,
        secret_name: str,
    ) -> "Response[OrganizationActionsSecret]":
        url = f"/orgs/{org}/actions/secrets/{secret_name}"

        return self._github.request(
            "GET",
            url,
            response_model=OrganizationActionsSecret,
        )

    async def async_get_org_secret(
        self,
        org: str,
        secret_name: str,
    ) -> "Response[OrganizationActionsSecret]":
        url = f"/orgs/{org}/actions/secrets/{secret_name}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=OrganizationActionsSecret,
        )

    def create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        encrypted_value: Union[Unset, str] = UNSET,
        key_id: Union[Unset, str] = UNSET,
        visibility: Literal["all", "private", "selected"],
        selected_repository_ids: Union[Unset, List[int]] = UNSET,
    ) -> "Response[EmptyObject]":
        url = f"/orgs/{org}/actions/secrets/{secret_name}"

        json = OrgsOrgActionsSecretsSecretNamePutBody(
            **{
                "encrypted_value": encrypted_value,
                "key_id": key_id,
                "visibility": visibility,
                "selected_repository_ids": selected_repository_ids,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=EmptyObject,
        )

    async def async_create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        encrypted_value: Union[Unset, str] = UNSET,
        key_id: Union[Unset, str] = UNSET,
        visibility: Literal["all", "private", "selected"],
        selected_repository_ids: Union[Unset, List[int]] = UNSET,
    ) -> "Response[EmptyObject]":
        url = f"/orgs/{org}/actions/secrets/{secret_name}"

        json = OrgsOrgActionsSecretsSecretNamePutBody(
            **{
                "encrypted_value": encrypted_value,
                "key_id": key_id,
                "visibility": visibility,
                "selected_repository_ids": selected_repository_ids,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=EmptyObject,
        )

    def delete_org_secret(
        self,
        org: str,
        secret_name: str,
    ) -> "Response":
        url = f"/orgs/{org}/actions/secrets/{secret_name}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_org_secret(
        self,
        org: str,
        secret_name: str,
    ) -> "Response":
        url = f"/orgs/{org}/actions/secrets/{secret_name}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def list_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        page: Union[Unset, int] = 1,
        per_page: Union[Unset, int] = 30,
    ) -> "Response[OrgsOrgActionsSecretsSecretNameRepositoriesGetResponse200]":
        url = f"/orgs/{org}/actions/secrets/{secret_name}/repositories"

        params = {
            "page": page,
            "per_page": per_page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=OrgsOrgActionsSecretsSecretNameRepositoriesGetResponse200,
        )

    async def async_list_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        page: Union[Unset, int] = 1,
        per_page: Union[Unset, int] = 30,
    ) -> "Response[OrgsOrgActionsSecretsSecretNameRepositoriesGetResponse200]":
        url = f"/orgs/{org}/actions/secrets/{secret_name}/repositories"

        params = {
            "page": page,
            "per_page": per_page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=OrgsOrgActionsSecretsSecretNameRepositoriesGetResponse200,
        )

    def set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        selected_repository_ids: List[int],
    ) -> "Response":
        url = f"/orgs/{org}/actions/secrets/{secret_name}/repositories"

        json = OrgsOrgActionsSecretsSecretNameRepositoriesPutBody(
            **{
                "selected_repository_ids": selected_repository_ids,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    async def async_set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        selected_repository_ids: List[int],
    ) -> "Response":
        url = f"/orgs/{org}/actions/secrets/{secret_name}/repositories"

        json = OrgsOrgActionsSecretsSecretNameRepositoriesPutBody(
            **{
                "selected_repository_ids": selected_repository_ids,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    def add_selected_repo_to_org_secret(
        self,
        org: str,
        secret_name: str,
        repository_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/actions/secrets/{secret_name}/repositories/{repository_id}"

        return self._github.request(
            "PUT",
            url,
            error_models={},
        )

    async def async_add_selected_repo_to_org_secret(
        self,
        org: str,
        secret_name: str,
        repository_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/actions/secrets/{secret_name}/repositories/{repository_id}"

        return await self._github.arequest(
            "PUT",
            url,
            error_models={},
        )

    def remove_selected_repo_from_org_secret(
        self,
        org: str,
        secret_name: str,
        repository_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/actions/secrets/{secret_name}/repositories/{repository_id}"

        return self._github.request(
            "DELETE",
            url,
            error_models={},
        )

    async def async_remove_selected_repo_from_org_secret(
        self,
        org: str,
        secret_name: str,
        repository_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/actions/secrets/{secret_name}/repositories/{repository_id}"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={},
        )

    def list_artifacts_for_repo(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[ReposOwnerRepoActionsArtifactsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/artifacts"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoActionsArtifactsGetResponse200,
        )

    async def async_list_artifacts_for_repo(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[ReposOwnerRepoActionsArtifactsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/artifacts"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoActionsArtifactsGetResponse200,
        )

    def get_artifact(
        self,
        owner: str,
        repo: str,
        artifact_id: int,
    ) -> "Response[Artifact]":
        url = f"/repos/{owner}/{repo}/actions/artifacts/{artifact_id}"

        return self._github.request(
            "GET",
            url,
            response_model=Artifact,
        )

    async def async_get_artifact(
        self,
        owner: str,
        repo: str,
        artifact_id: int,
    ) -> "Response[Artifact]":
        url = f"/repos/{owner}/{repo}/actions/artifacts/{artifact_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=Artifact,
        )

    def delete_artifact(
        self,
        owner: str,
        repo: str,
        artifact_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/artifacts/{artifact_id}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_artifact(
        self,
        owner: str,
        repo: str,
        artifact_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/artifacts/{artifact_id}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def download_artifact(
        self,
        owner: str,
        repo: str,
        artifact_id: int,
        archive_format: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/artifacts/{artifact_id}/{archive_format}"

        return self._github.request(
            "GET",
            url,
            error_models={
                "410": BasicError,
            },
        )

    async def async_download_artifact(
        self,
        owner: str,
        repo: str,
        artifact_id: int,
        archive_format: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/artifacts/{artifact_id}/{archive_format}"

        return await self._github.arequest(
            "GET",
            url,
            error_models={
                "410": BasicError,
            },
        )

    def get_actions_cache_usage(
        self,
        owner: str,
        repo: str,
    ) -> "Response[ActionsCacheUsageByRepository]":
        url = f"/repos/{owner}/{repo}/actions/cache/usage"

        return self._github.request(
            "GET",
            url,
            response_model=ActionsCacheUsageByRepository,
        )

    async def async_get_actions_cache_usage(
        self,
        owner: str,
        repo: str,
    ) -> "Response[ActionsCacheUsageByRepository]":
        url = f"/repos/{owner}/{repo}/actions/cache/usage"

        return await self._github.arequest(
            "GET",
            url,
            response_model=ActionsCacheUsageByRepository,
        )

    def get_actions_cache_list(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
        ref: Union[Unset, str] = UNSET,
        key: Union[Unset, str] = UNSET,
        sort: Union[
            Unset, Literal["created_at", "last_accessed_at", "size_in_bytes"]
        ] = "last_accessed_at",
        direction: Union[Unset, Literal["asc", "desc"]] = "desc",
    ) -> "Response[ActionsCacheList]":
        url = f"/repos/{owner}/{repo}/actions/caches"

        params = {
            "per_page": per_page,
            "page": page,
            "ref": ref,
            "key": key,
            "sort": sort,
            "direction": direction,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ActionsCacheList,
        )

    async def async_get_actions_cache_list(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
        ref: Union[Unset, str] = UNSET,
        key: Union[Unset, str] = UNSET,
        sort: Union[
            Unset, Literal["created_at", "last_accessed_at", "size_in_bytes"]
        ] = "last_accessed_at",
        direction: Union[Unset, Literal["asc", "desc"]] = "desc",
    ) -> "Response[ActionsCacheList]":
        url = f"/repos/{owner}/{repo}/actions/caches"

        params = {
            "per_page": per_page,
            "page": page,
            "ref": ref,
            "key": key,
            "sort": sort,
            "direction": direction,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ActionsCacheList,
        )

    def delete_actions_cache_by_key(
        self,
        owner: str,
        repo: str,
        key: str,
        ref: Union[Unset, str] = UNSET,
    ) -> "Response[ActionsCacheList]":
        url = f"/repos/{owner}/{repo}/actions/caches"

        params = {
            "key": key,
            "ref": ref,
        }

        return self._github.request(
            "DELETE",
            url,
            params=exclude_unset(params),
            response_model=ActionsCacheList,
        )

    async def async_delete_actions_cache_by_key(
        self,
        owner: str,
        repo: str,
        key: str,
        ref: Union[Unset, str] = UNSET,
    ) -> "Response[ActionsCacheList]":
        url = f"/repos/{owner}/{repo}/actions/caches"

        params = {
            "key": key,
            "ref": ref,
        }

        return await self._github.arequest(
            "DELETE",
            url,
            params=exclude_unset(params),
            response_model=ActionsCacheList,
        )

    def delete_actions_cache_by_id(
        self,
        owner: str,
        repo: str,
        cache_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/caches/{cache_id}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_actions_cache_by_id(
        self,
        owner: str,
        repo: str,
        cache_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/caches/{cache_id}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def get_job_for_workflow_run(
        self,
        owner: str,
        repo: str,
        job_id: int,
    ) -> "Response[Job]":
        url = f"/repos/{owner}/{repo}/actions/jobs/{job_id}"

        return self._github.request(
            "GET",
            url,
            response_model=Job,
        )

    async def async_get_job_for_workflow_run(
        self,
        owner: str,
        repo: str,
        job_id: int,
    ) -> "Response[Job]":
        url = f"/repos/{owner}/{repo}/actions/jobs/{job_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=Job,
        )

    def download_job_logs_for_workflow_run(
        self,
        owner: str,
        repo: str,
        job_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/jobs/{job_id}/logs"

        return self._github.request(
            "GET",
            url,
        )

    async def async_download_job_logs_for_workflow_run(
        self,
        owner: str,
        repo: str,
        job_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/jobs/{job_id}/logs"

        return await self._github.arequest(
            "GET",
            url,
        )

    def re_run_job_for_workflow_run(
        self,
        owner: str,
        repo: str,
        job_id: int,
        *,
        body: Union[
            Unset, Union[ReposOwnerRepoActionsJobsJobIdRerunPostBodyType, None]
        ] = UNSET,
    ) -> "Response[EmptyObject]":
        url = f"/repos/{owner}/{repo}/actions/jobs/{job_id}/rerun"

        json = body

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=EmptyObject,
            error_models={
                "403": BasicError,
            },
        )

    async def async_re_run_job_for_workflow_run(
        self,
        owner: str,
        repo: str,
        job_id: int,
        *,
        body: Union[
            Unset, Union[ReposOwnerRepoActionsJobsJobIdRerunPostBodyType, None]
        ] = UNSET,
    ) -> "Response[EmptyObject]":
        url = f"/repos/{owner}/{repo}/actions/jobs/{job_id}/rerun"

        json = body

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=EmptyObject,
            error_models={
                "403": BasicError,
            },
        )

    def get_custom_oidc_sub_claim_for_repo(
        self,
        owner: str,
        repo: str,
    ) -> "Response[OptOutOidcCustomSub]":
        url = f"/repos/{owner}/{repo}/actions/oidc/customization/sub"

        return self._github.request(
            "GET",
            url,
            response_model=OptOutOidcCustomSub,
            error_models={
                "400": BasicError,
                "404": BasicError,
            },
        )

    async def async_get_custom_oidc_sub_claim_for_repo(
        self,
        owner: str,
        repo: str,
    ) -> "Response[OptOutOidcCustomSub]":
        url = f"/repos/{owner}/{repo}/actions/oidc/customization/sub"

        return await self._github.arequest(
            "GET",
            url,
            response_model=OptOutOidcCustomSub,
            error_models={
                "400": BasicError,
                "404": BasicError,
            },
        )

    def set_custom_oidc_sub_claim_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        use_default: bool,
    ) -> "Response[EmptyObject]":
        url = f"/repos/{owner}/{repo}/actions/oidc/customization/sub"

        json = OptOutOidcCustomSub(
            **{
                "use_default": use_default,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=EmptyObject,
            error_models={
                "404": BasicError,
                "400": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_set_custom_oidc_sub_claim_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        use_default: bool,
    ) -> "Response[EmptyObject]":
        url = f"/repos/{owner}/{repo}/actions/oidc/customization/sub"

        json = OptOutOidcCustomSub(
            **{
                "use_default": use_default,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=EmptyObject,
            error_models={
                "404": BasicError,
                "400": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def get_github_actions_permissions_repository(
        self,
        owner: str,
        repo: str,
    ) -> "Response[ActionsRepositoryPermissions]":
        url = f"/repos/{owner}/{repo}/actions/permissions"

        return self._github.request(
            "GET",
            url,
            response_model=ActionsRepositoryPermissions,
        )

    async def async_get_github_actions_permissions_repository(
        self,
        owner: str,
        repo: str,
    ) -> "Response[ActionsRepositoryPermissions]":
        url = f"/repos/{owner}/{repo}/actions/permissions"

        return await self._github.arequest(
            "GET",
            url,
            response_model=ActionsRepositoryPermissions,
        )

    def set_github_actions_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        enabled: bool,
        allowed_actions: Union[Unset, Literal["all", "local_only", "selected"]] = UNSET,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/permissions"

        json = ReposOwnerRepoActionsPermissionsPutBody(
            **{
                "enabled": enabled,
                "allowed_actions": allowed_actions,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    async def async_set_github_actions_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        enabled: bool,
        allowed_actions: Union[Unset, Literal["all", "local_only", "selected"]] = UNSET,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/permissions"

        json = ReposOwnerRepoActionsPermissionsPutBody(
            **{
                "enabled": enabled,
                "allowed_actions": allowed_actions,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    def get_workflow_access_to_repository(
        self,
        owner: str,
        repo: str,
    ) -> "Response[ActionsWorkflowAccessToRepository]":
        url = f"/repos/{owner}/{repo}/actions/permissions/access"

        return self._github.request(
            "GET",
            url,
            response_model=ActionsWorkflowAccessToRepository,
        )

    async def async_get_workflow_access_to_repository(
        self,
        owner: str,
        repo: str,
    ) -> "Response[ActionsWorkflowAccessToRepository]":
        url = f"/repos/{owner}/{repo}/actions/permissions/access"

        return await self._github.arequest(
            "GET",
            url,
            response_model=ActionsWorkflowAccessToRepository,
        )

    def set_workflow_access_to_repository(
        self,
        owner: str,
        repo: str,
        *,
        access_level: Literal["none", "organization", "enterprise"],
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/permissions/access"

        json = ActionsWorkflowAccessToRepository(
            **{
                "access_level": access_level,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    async def async_set_workflow_access_to_repository(
        self,
        owner: str,
        repo: str,
        *,
        access_level: Literal["none", "organization", "enterprise"],
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/permissions/access"

        json = ActionsWorkflowAccessToRepository(
            **{
                "access_level": access_level,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    def get_allowed_actions_repository(
        self,
        owner: str,
        repo: str,
    ) -> "Response[SelectedActions]":
        url = f"/repos/{owner}/{repo}/actions/permissions/selected-actions"

        return self._github.request(
            "GET",
            url,
            response_model=SelectedActions,
        )

    async def async_get_allowed_actions_repository(
        self,
        owner: str,
        repo: str,
    ) -> "Response[SelectedActions]":
        url = f"/repos/{owner}/{repo}/actions/permissions/selected-actions"

        return await self._github.arequest(
            "GET",
            url,
            response_model=SelectedActions,
        )

    def set_allowed_actions_repository(
        self,
        owner: str,
        repo: str,
        *,
        github_owned_allowed: Union[Unset, bool] = UNSET,
        verified_allowed: Union[Unset, bool] = UNSET,
        patterns_allowed: Union[Unset, List[str]] = UNSET,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/permissions/selected-actions"

        json = SelectedActions(
            **{
                "github_owned_allowed": github_owned_allowed,
                "verified_allowed": verified_allowed,
                "patterns_allowed": patterns_allowed,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    async def async_set_allowed_actions_repository(
        self,
        owner: str,
        repo: str,
        *,
        github_owned_allowed: Union[Unset, bool] = UNSET,
        verified_allowed: Union[Unset, bool] = UNSET,
        patterns_allowed: Union[Unset, List[str]] = UNSET,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/permissions/selected-actions"

        json = SelectedActions(
            **{
                "github_owned_allowed": github_owned_allowed,
                "verified_allowed": verified_allowed,
                "patterns_allowed": patterns_allowed,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    def get_github_actions_default_workflow_permissions_repository(
        self,
        owner: str,
        repo: str,
    ) -> "Response[ActionsGetDefaultWorkflowPermissions]":
        url = f"/repos/{owner}/{repo}/actions/permissions/workflow"

        return self._github.request(
            "GET",
            url,
            response_model=ActionsGetDefaultWorkflowPermissions,
        )

    async def async_get_github_actions_default_workflow_permissions_repository(
        self,
        owner: str,
        repo: str,
    ) -> "Response[ActionsGetDefaultWorkflowPermissions]":
        url = f"/repos/{owner}/{repo}/actions/permissions/workflow"

        return await self._github.arequest(
            "GET",
            url,
            response_model=ActionsGetDefaultWorkflowPermissions,
        )

    def set_github_actions_default_workflow_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        default_workflow_permissions: Union[Unset, Literal["read", "write"]] = UNSET,
        can_approve_pull_request_reviews: Union[Unset, bool] = UNSET,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/permissions/workflow"

        json = ActionsSetDefaultWorkflowPermissions(
            **{
                "default_workflow_permissions": default_workflow_permissions,
                "can_approve_pull_request_reviews": can_approve_pull_request_reviews,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            error_models={},
        )

    async def async_set_github_actions_default_workflow_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        default_workflow_permissions: Union[Unset, Literal["read", "write"]] = UNSET,
        can_approve_pull_request_reviews: Union[Unset, bool] = UNSET,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/permissions/workflow"

        json = ActionsSetDefaultWorkflowPermissions(
            **{
                "default_workflow_permissions": default_workflow_permissions,
                "can_approve_pull_request_reviews": can_approve_pull_request_reviews,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            error_models={},
        )

    def list_self_hosted_runners_for_repo(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[ReposOwnerRepoActionsRunnersGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runners"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoActionsRunnersGetResponse200,
        )

    async def async_list_self_hosted_runners_for_repo(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[ReposOwnerRepoActionsRunnersGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runners"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoActionsRunnersGetResponse200,
        )

    def list_runner_applications_for_repo(
        self,
        owner: str,
        repo: str,
    ) -> "Response[List[RunnerApplication]]":
        url = f"/repos/{owner}/{repo}/actions/runners/downloads"

        return self._github.request(
            "GET",
            url,
            response_model=List[RunnerApplication],
        )

    async def async_list_runner_applications_for_repo(
        self,
        owner: str,
        repo: str,
    ) -> "Response[List[RunnerApplication]]":
        url = f"/repos/{owner}/{repo}/actions/runners/downloads"

        return await self._github.arequest(
            "GET",
            url,
            response_model=List[RunnerApplication],
        )

    def create_registration_token_for_repo(
        self,
        owner: str,
        repo: str,
    ) -> "Response[AuthenticationToken]":
        url = f"/repos/{owner}/{repo}/actions/runners/registration-token"

        return self._github.request(
            "POST",
            url,
            response_model=AuthenticationToken,
        )

    async def async_create_registration_token_for_repo(
        self,
        owner: str,
        repo: str,
    ) -> "Response[AuthenticationToken]":
        url = f"/repos/{owner}/{repo}/actions/runners/registration-token"

        return await self._github.arequest(
            "POST",
            url,
            response_model=AuthenticationToken,
        )

    def create_remove_token_for_repo(
        self,
        owner: str,
        repo: str,
    ) -> "Response[AuthenticationToken]":
        url = f"/repos/{owner}/{repo}/actions/runners/remove-token"

        return self._github.request(
            "POST",
            url,
            response_model=AuthenticationToken,
        )

    async def async_create_remove_token_for_repo(
        self,
        owner: str,
        repo: str,
    ) -> "Response[AuthenticationToken]":
        url = f"/repos/{owner}/{repo}/actions/runners/remove-token"

        return await self._github.arequest(
            "POST",
            url,
            response_model=AuthenticationToken,
        )

    def get_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
    ) -> "Response[Runner]":
        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}"

        return self._github.request(
            "GET",
            url,
            response_model=Runner,
        )

    async def async_get_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
    ) -> "Response[Runner]":
        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=Runner,
        )

    def delete_self_hosted_runner_from_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_self_hosted_runner_from_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def list_labels_for_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}/labels"

        return self._github.request(
            "GET",
            url,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_labels_for_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}/labels"

        return await self._github.arequest(
            "GET",
            url,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    def set_custom_labels_for_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        labels: List[str],
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}/labels"

        json = ReposOwnerRepoActionsRunnersRunnerIdLabelsPutBody(
            **{
                "labels": labels,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_set_custom_labels_for_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        labels: List[str],
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}/labels"

        json = ReposOwnerRepoActionsRunnersRunnerIdLabelsPutBody(
            **{
                "labels": labels,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def add_custom_labels_to_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        labels: List[str],
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}/labels"

        json = ReposOwnerRepoActionsRunnersRunnerIdLabelsPostBody(
            **{
                "labels": labels,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_add_custom_labels_to_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        labels: List[str],
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}/labels"

        json = ReposOwnerRepoActionsRunnersRunnerIdLabelsPostBody(
            **{
                "labels": labels,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def remove_all_custom_labels_from_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}/labels"

        return self._github.request(
            "DELETE",
            url,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200,
            error_models={
                "404": BasicError,
            },
        )

    async def async_remove_all_custom_labels_from_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}/labels"

        return await self._github.arequest(
            "DELETE",
            url,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200,
            error_models={
                "404": BasicError,
            },
        )

    def remove_custom_label_from_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        name: str,
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}/labels/{name}"

        return self._github.request(
            "DELETE",
            url,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_remove_custom_label_from_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        name: str,
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}/labels/{name}"

        return await self._github.arequest(
            "DELETE",
            url,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def list_workflow_runs_for_repo(
        self,
        owner: str,
        repo: str,
        actor: Union[Unset, str] = UNSET,
        branch: Union[Unset, str] = UNSET,
        event: Union[Unset, str] = UNSET,
        status: Union[
            Unset,
            Literal[
                "completed",
                "action_required",
                "cancelled",
                "failure",
                "neutral",
                "skipped",
                "stale",
                "success",
                "timed_out",
                "in_progress",
                "queued",
                "requested",
                "waiting",
            ],
        ] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
        created: Union[Unset, datetime] = UNSET,
        exclude_pull_requests: Union[Unset, bool] = False,
        check_suite_id: Union[Unset, int] = UNSET,
    ) -> "Response[ReposOwnerRepoActionsRunsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runs"

        params = {
            "actor": actor,
            "branch": branch,
            "event": event,
            "status": status,
            "per_page": per_page,
            "page": page,
            "created": created,
            "exclude_pull_requests": exclude_pull_requests,
            "check_suite_id": check_suite_id,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoActionsRunsGetResponse200,
        )

    async def async_list_workflow_runs_for_repo(
        self,
        owner: str,
        repo: str,
        actor: Union[Unset, str] = UNSET,
        branch: Union[Unset, str] = UNSET,
        event: Union[Unset, str] = UNSET,
        status: Union[
            Unset,
            Literal[
                "completed",
                "action_required",
                "cancelled",
                "failure",
                "neutral",
                "skipped",
                "stale",
                "success",
                "timed_out",
                "in_progress",
                "queued",
                "requested",
                "waiting",
            ],
        ] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
        created: Union[Unset, datetime] = UNSET,
        exclude_pull_requests: Union[Unset, bool] = False,
        check_suite_id: Union[Unset, int] = UNSET,
    ) -> "Response[ReposOwnerRepoActionsRunsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runs"

        params = {
            "actor": actor,
            "branch": branch,
            "event": event,
            "status": status,
            "per_page": per_page,
            "page": page,
            "created": created,
            "exclude_pull_requests": exclude_pull_requests,
            "check_suite_id": check_suite_id,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoActionsRunsGetResponse200,
        )

    def get_workflow_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        exclude_pull_requests: Union[Unset, bool] = False,
    ) -> "Response[WorkflowRun]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}"

        params = {
            "exclude_pull_requests": exclude_pull_requests,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=WorkflowRun,
        )

    async def async_get_workflow_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        exclude_pull_requests: Union[Unset, bool] = False,
    ) -> "Response[WorkflowRun]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}"

        params = {
            "exclude_pull_requests": exclude_pull_requests,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=WorkflowRun,
        )

    def delete_workflow_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_workflow_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def get_reviews_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
    ) -> "Response[List[EnvironmentApprovals]]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/approvals"

        return self._github.request(
            "GET",
            url,
            response_model=List[EnvironmentApprovals],
        )

    async def async_get_reviews_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
    ) -> "Response[List[EnvironmentApprovals]]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/approvals"

        return await self._github.arequest(
            "GET",
            url,
            response_model=List[EnvironmentApprovals],
        )

    def approve_workflow_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
    ) -> "Response[EmptyObject]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/approve"

        return self._github.request(
            "POST",
            url,
            response_model=EmptyObject,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_approve_workflow_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
    ) -> "Response[EmptyObject]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/approve"

        return await self._github.arequest(
            "POST",
            url,
            response_model=EmptyObject,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    def list_workflow_run_artifacts(
        self,
        owner: str,
        repo: str,
        run_id: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[ReposOwnerRepoActionsRunsRunIdArtifactsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/artifacts"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoActionsRunsRunIdArtifactsGetResponse200,
        )

    async def async_list_workflow_run_artifacts(
        self,
        owner: str,
        repo: str,
        run_id: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[ReposOwnerRepoActionsRunsRunIdArtifactsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/artifacts"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoActionsRunsRunIdArtifactsGetResponse200,
        )

    def get_workflow_run_attempt(
        self,
        owner: str,
        repo: str,
        run_id: int,
        attempt_number: int,
        exclude_pull_requests: Union[Unset, bool] = False,
    ) -> "Response[WorkflowRun]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}"

        params = {
            "exclude_pull_requests": exclude_pull_requests,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=WorkflowRun,
        )

    async def async_get_workflow_run_attempt(
        self,
        owner: str,
        repo: str,
        run_id: int,
        attempt_number: int,
        exclude_pull_requests: Union[Unset, bool] = False,
    ) -> "Response[WorkflowRun]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}"

        params = {
            "exclude_pull_requests": exclude_pull_requests,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=WorkflowRun,
        )

    def list_jobs_for_workflow_run_attempt(
        self,
        owner: str,
        repo: str,
        run_id: int,
        attempt_number: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[ReposOwnerRepoActionsRunsRunIdAttemptsAttemptNumberJobsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}/jobs"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoActionsRunsRunIdAttemptsAttemptNumberJobsGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_jobs_for_workflow_run_attempt(
        self,
        owner: str,
        repo: str,
        run_id: int,
        attempt_number: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[ReposOwnerRepoActionsRunsRunIdAttemptsAttemptNumberJobsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}/jobs"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoActionsRunsRunIdAttemptsAttemptNumberJobsGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    def download_workflow_run_attempt_logs(
        self,
        owner: str,
        repo: str,
        run_id: int,
        attempt_number: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}/logs"

        return self._github.request(
            "GET",
            url,
        )

    async def async_download_workflow_run_attempt_logs(
        self,
        owner: str,
        repo: str,
        run_id: int,
        attempt_number: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}/logs"

        return await self._github.arequest(
            "GET",
            url,
        )

    def cancel_workflow_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
    ) -> "Response[ReposOwnerRepoActionsRunsRunIdCancelPostResponse202]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/cancel"

        return self._github.request(
            "POST",
            url,
            response_model=ReposOwnerRepoActionsRunsRunIdCancelPostResponse202,
            error_models={
                "409": BasicError,
            },
        )

    async def async_cancel_workflow_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
    ) -> "Response[ReposOwnerRepoActionsRunsRunIdCancelPostResponse202]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/cancel"

        return await self._github.arequest(
            "POST",
            url,
            response_model=ReposOwnerRepoActionsRunsRunIdCancelPostResponse202,
            error_models={
                "409": BasicError,
            },
        )

    def list_jobs_for_workflow_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        filter_: Union[Unset, Literal["latest", "all"]] = "latest",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[ReposOwnerRepoActionsRunsRunIdJobsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/jobs"

        params = {
            "filter": filter_,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoActionsRunsRunIdJobsGetResponse200,
        )

    async def async_list_jobs_for_workflow_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        filter_: Union[Unset, Literal["latest", "all"]] = "latest",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[ReposOwnerRepoActionsRunsRunIdJobsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/jobs"

        params = {
            "filter": filter_,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoActionsRunsRunIdJobsGetResponse200,
        )

    def download_workflow_run_logs(
        self,
        owner: str,
        repo: str,
        run_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/logs"

        return self._github.request(
            "GET",
            url,
        )

    async def async_download_workflow_run_logs(
        self,
        owner: str,
        repo: str,
        run_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/logs"

        return await self._github.arequest(
            "GET",
            url,
        )

    def delete_workflow_run_logs(
        self,
        owner: str,
        repo: str,
        run_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/logs"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "403": BasicError,
                "500": BasicError,
            },
        )

    async def async_delete_workflow_run_logs(
        self,
        owner: str,
        repo: str,
        run_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/logs"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "403": BasicError,
                "500": BasicError,
            },
        )

    def get_pending_deployments_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
    ) -> "Response[List[PendingDeployment]]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/pending_deployments"

        return self._github.request(
            "GET",
            url,
            response_model=List[PendingDeployment],
        )

    async def async_get_pending_deployments_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
    ) -> "Response[List[PendingDeployment]]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/pending_deployments"

        return await self._github.arequest(
            "GET",
            url,
            response_model=List[PendingDeployment],
        )

    def review_pending_deployments_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        environment_ids: List[int],
        state: Literal["approved", "rejected"],
        comment: str,
    ) -> "Response[List[Deployment]]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/pending_deployments"

        json = ReposOwnerRepoActionsRunsRunIdPendingDeploymentsPostBody(
            **{
                "environment_ids": environment_ids,
                "state": state,
                "comment": comment,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=List[Deployment],
        )

    async def async_review_pending_deployments_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        environment_ids: List[int],
        state: Literal["approved", "rejected"],
        comment: str,
    ) -> "Response[List[Deployment]]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/pending_deployments"

        json = ReposOwnerRepoActionsRunsRunIdPendingDeploymentsPostBody(
            **{
                "environment_ids": environment_ids,
                "state": state,
                "comment": comment,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=List[Deployment],
        )

    def re_run_workflow(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        body: Union[
            Unset, Union[ReposOwnerRepoActionsRunsRunIdRerunPostBodyType, None]
        ] = UNSET,
    ) -> "Response[ReposOwnerRepoActionsRunsRunIdRerunPostResponse201]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/rerun"

        json = body

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=ReposOwnerRepoActionsRunsRunIdRerunPostResponse201,
        )

    async def async_re_run_workflow(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        body: Union[
            Unset, Union[ReposOwnerRepoActionsRunsRunIdRerunPostBodyType, None]
        ] = UNSET,
    ) -> "Response[ReposOwnerRepoActionsRunsRunIdRerunPostResponse201]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/rerun"

        json = body

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=ReposOwnerRepoActionsRunsRunIdRerunPostResponse201,
        )

    def re_run_workflow_failed_jobs(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        body: Union[
            Unset,
            Union[ReposOwnerRepoActionsRunsRunIdRerunFailedJobsPostBodyType, None],
        ] = UNSET,
    ) -> "Response[EmptyObject]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/rerun-failed-jobs"

        json = body

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=EmptyObject,
        )

    async def async_re_run_workflow_failed_jobs(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        body: Union[
            Unset,
            Union[ReposOwnerRepoActionsRunsRunIdRerunFailedJobsPostBodyType, None],
        ] = UNSET,
    ) -> "Response[EmptyObject]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/rerun-failed-jobs"

        json = body

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=EmptyObject,
        )

    def get_workflow_run_usage(
        self,
        owner: str,
        repo: str,
        run_id: int,
    ) -> "Response[WorkflowRunUsage]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/timing"

        return self._github.request(
            "GET",
            url,
            response_model=WorkflowRunUsage,
        )

    async def async_get_workflow_run_usage(
        self,
        owner: str,
        repo: str,
        run_id: int,
    ) -> "Response[WorkflowRunUsage]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/timing"

        return await self._github.arequest(
            "GET",
            url,
            response_model=WorkflowRunUsage,
        )

    def list_repo_secrets(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[ReposOwnerRepoActionsSecretsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoActionsSecretsGetResponse200,
        )

    async def async_list_repo_secrets(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[ReposOwnerRepoActionsSecretsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoActionsSecretsGetResponse200,
        )

    def get_repo_public_key(
        self,
        owner: str,
        repo: str,
    ) -> "Response[ActionsPublicKey]":
        url = f"/repos/{owner}/{repo}/actions/secrets/public-key"

        return self._github.request(
            "GET",
            url,
            response_model=ActionsPublicKey,
        )

    async def async_get_repo_public_key(
        self,
        owner: str,
        repo: str,
    ) -> "Response[ActionsPublicKey]":
        url = f"/repos/{owner}/{repo}/actions/secrets/public-key"

        return await self._github.arequest(
            "GET",
            url,
            response_model=ActionsPublicKey,
        )

    def get_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
    ) -> "Response[ActionsSecret]":
        url = f"/repos/{owner}/{repo}/actions/secrets/{secret_name}"

        return self._github.request(
            "GET",
            url,
            response_model=ActionsSecret,
        )

    async def async_get_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
    ) -> "Response[ActionsSecret]":
        url = f"/repos/{owner}/{repo}/actions/secrets/{secret_name}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=ActionsSecret,
        )

    def create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        encrypted_value: Union[Unset, str] = UNSET,
        key_id: Union[Unset, str] = UNSET,
    ) -> "Response[ReposOwnerRepoActionsSecretsSecretNamePutResponse201]":
        url = f"/repos/{owner}/{repo}/actions/secrets/{secret_name}"

        json = ReposOwnerRepoActionsSecretsSecretNamePutBody(
            **{
                "encrypted_value": encrypted_value,
                "key_id": key_id,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=ReposOwnerRepoActionsSecretsSecretNamePutResponse201,
        )

    async def async_create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        encrypted_value: Union[Unset, str] = UNSET,
        key_id: Union[Unset, str] = UNSET,
    ) -> "Response[ReposOwnerRepoActionsSecretsSecretNamePutResponse201]":
        url = f"/repos/{owner}/{repo}/actions/secrets/{secret_name}"

        json = ReposOwnerRepoActionsSecretsSecretNamePutBody(
            **{
                "encrypted_value": encrypted_value,
                "key_id": key_id,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=ReposOwnerRepoActionsSecretsSecretNamePutResponse201,
        )

    def delete_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/secrets/{secret_name}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/secrets/{secret_name}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def list_repo_workflows(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[ReposOwnerRepoActionsWorkflowsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/workflows"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoActionsWorkflowsGetResponse200,
        )

    async def async_list_repo_workflows(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[ReposOwnerRepoActionsWorkflowsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/workflows"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoActionsWorkflowsGetResponse200,
        )

    def get_workflow(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
    ) -> "Response[Workflow]":
        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}"

        return self._github.request(
            "GET",
            url,
            response_model=Workflow,
        )

    async def async_get_workflow(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
    ) -> "Response[Workflow]":
        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=Workflow,
        )

    def disable_workflow(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}/disable"

        return self._github.request(
            "PUT",
            url,
        )

    async def async_disable_workflow(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}/disable"

        return await self._github.arequest(
            "PUT",
            url,
        )

    def create_workflow_dispatch(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        *,
        ref: str,
        inputs: Union[
            Unset,
            ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBodyPropInputsType,
        ] = UNSET,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}/dispatches"

        json = ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBody(
            **{
                "ref": ref,
                "inputs": inputs,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
        )

    async def async_create_workflow_dispatch(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        *,
        ref: str,
        inputs: Union[
            Unset,
            ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBodyPropInputsType,
        ] = UNSET,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}/dispatches"

        json = ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBody(
            **{
                "ref": ref,
                "inputs": inputs,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
        )

    def enable_workflow(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}/enable"

        return self._github.request(
            "PUT",
            url,
        )

    async def async_enable_workflow(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}/enable"

        return await self._github.arequest(
            "PUT",
            url,
        )

    def list_workflow_runs(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        actor: Union[Unset, str] = UNSET,
        branch: Union[Unset, str] = UNSET,
        event: Union[Unset, str] = UNSET,
        status: Union[
            Unset,
            Literal[
                "completed",
                "action_required",
                "cancelled",
                "failure",
                "neutral",
                "skipped",
                "stale",
                "success",
                "timed_out",
                "in_progress",
                "queued",
                "requested",
                "waiting",
            ],
        ] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
        created: Union[Unset, datetime] = UNSET,
        exclude_pull_requests: Union[Unset, bool] = False,
        check_suite_id: Union[Unset, int] = UNSET,
    ) -> "Response[ReposOwnerRepoActionsWorkflowsWorkflowIdRunsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}/runs"

        params = {
            "actor": actor,
            "branch": branch,
            "event": event,
            "status": status,
            "per_page": per_page,
            "page": page,
            "created": created,
            "exclude_pull_requests": exclude_pull_requests,
            "check_suite_id": check_suite_id,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoActionsWorkflowsWorkflowIdRunsGetResponse200,
        )

    async def async_list_workflow_runs(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        actor: Union[Unset, str] = UNSET,
        branch: Union[Unset, str] = UNSET,
        event: Union[Unset, str] = UNSET,
        status: Union[
            Unset,
            Literal[
                "completed",
                "action_required",
                "cancelled",
                "failure",
                "neutral",
                "skipped",
                "stale",
                "success",
                "timed_out",
                "in_progress",
                "queued",
                "requested",
                "waiting",
            ],
        ] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
        created: Union[Unset, datetime] = UNSET,
        exclude_pull_requests: Union[Unset, bool] = False,
        check_suite_id: Union[Unset, int] = UNSET,
    ) -> "Response[ReposOwnerRepoActionsWorkflowsWorkflowIdRunsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}/runs"

        params = {
            "actor": actor,
            "branch": branch,
            "event": event,
            "status": status,
            "per_page": per_page,
            "page": page,
            "created": created,
            "exclude_pull_requests": exclude_pull_requests,
            "check_suite_id": check_suite_id,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoActionsWorkflowsWorkflowIdRunsGetResponse200,
        )

    def get_workflow_usage(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
    ) -> "Response[WorkflowUsage]":
        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}/timing"

        return self._github.request(
            "GET",
            url,
            response_model=WorkflowUsage,
        )

    async def async_get_workflow_usage(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
    ) -> "Response[WorkflowUsage]":
        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}/timing"

        return await self._github.arequest(
            "GET",
            url,
            response_model=WorkflowUsage,
        )

    def list_environment_secrets(
        self,
        repository_id: int,
        environment_name: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[RepositoriesRepositoryIdEnvironmentsEnvironmentNameSecretsGetResponse200]":
        url = f"/repositories/{repository_id}/environments/{environment_name}/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=RepositoriesRepositoryIdEnvironmentsEnvironmentNameSecretsGetResponse200,
        )

    async def async_list_environment_secrets(
        self,
        repository_id: int,
        environment_name: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[RepositoriesRepositoryIdEnvironmentsEnvironmentNameSecretsGetResponse200]":
        url = f"/repositories/{repository_id}/environments/{environment_name}/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=RepositoriesRepositoryIdEnvironmentsEnvironmentNameSecretsGetResponse200,
        )

    def get_environment_public_key(
        self,
        repository_id: int,
        environment_name: str,
    ) -> "Response[ActionsPublicKey]":
        url = f"/repositories/{repository_id}/environments/{environment_name}/secrets/public-key"

        return self._github.request(
            "GET",
            url,
            response_model=ActionsPublicKey,
        )

    async def async_get_environment_public_key(
        self,
        repository_id: int,
        environment_name: str,
    ) -> "Response[ActionsPublicKey]":
        url = f"/repositories/{repository_id}/environments/{environment_name}/secrets/public-key"

        return await self._github.arequest(
            "GET",
            url,
            response_model=ActionsPublicKey,
        )

    def get_environment_secret(
        self,
        repository_id: int,
        environment_name: str,
        secret_name: str,
    ) -> "Response[ActionsSecret]":
        url = f"/repositories/{repository_id}/environments/{environment_name}/secrets/{secret_name}"

        return self._github.request(
            "GET",
            url,
            response_model=ActionsSecret,
        )

    async def async_get_environment_secret(
        self,
        repository_id: int,
        environment_name: str,
        secret_name: str,
    ) -> "Response[ActionsSecret]":
        url = f"/repositories/{repository_id}/environments/{environment_name}/secrets/{secret_name}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=ActionsSecret,
        )

    def create_or_update_environment_secret(
        self,
        repository_id: int,
        environment_name: str,
        secret_name: str,
        *,
        encrypted_value: str,
        key_id: str,
    ) -> "Response[EmptyObject]":
        url = f"/repositories/{repository_id}/environments/{environment_name}/secrets/{secret_name}"

        json = (
            RepositoriesRepositoryIdEnvironmentsEnvironmentNameSecretsSecretNamePutBody(
                **{
                    "encrypted_value": encrypted_value,
                    "key_id": key_id,
                }
            ).dict(by_alias=True)
        )

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=EmptyObject,
        )

    async def async_create_or_update_environment_secret(
        self,
        repository_id: int,
        environment_name: str,
        secret_name: str,
        *,
        encrypted_value: str,
        key_id: str,
    ) -> "Response[EmptyObject]":
        url = f"/repositories/{repository_id}/environments/{environment_name}/secrets/{secret_name}"

        json = (
            RepositoriesRepositoryIdEnvironmentsEnvironmentNameSecretsSecretNamePutBody(
                **{
                    "encrypted_value": encrypted_value,
                    "key_id": key_id,
                }
            ).dict(by_alias=True)
        )

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=EmptyObject,
        )

    def delete_environment_secret(
        self,
        repository_id: int,
        environment_name: str,
        secret_name: str,
    ) -> "Response":
        url = f"/repositories/{repository_id}/environments/{environment_name}/secrets/{secret_name}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_environment_secret(
        self,
        repository_id: int,
        environment_name: str,
        secret_name: str,
    ) -> "Response":
        url = f"/repositories/{repository_id}/environments/{environment_name}/secrets/{secret_name}"

        return await self._github.arequest(
            "DELETE",
            url,
        )
