# Copyright 2016-2018 Micael Oliveira
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.


ABINIT_NATIVE_IXC = {'0': [{}],
                     '1': [{'XC_functional_name': 'LDA_XC_TETER93'}],
                     '2': [{'XC_functional_name': 'LDA_X'},
                           {'XC_functional_name': 'LDA_C_PZ'}],
                     # 3 - LDA, old Teter rational polynomial parametrization (4/91)
                     '4': [{'XC_functional_name': 'LDA_X'},
                           {'XC_functional_name': 'LDA_C_WIGNER'}],
                     '5': [{'XC_functional_name': 'LDA_X'},
                           {'XC_functional_name': 'LDA_C_HL'}],
                     '6': [{'XC_functional_name': 'LDA_X'},
                           {'XC_functional_name': 'LDA_C_XALPHA'}],
                     '7': [{'XC_functional_name': 'LDA_X'},
                           {'XC_functional_name': 'LDA_C_PW'}],
                     # 8 - x-only part of the Perdew-Wang 92 functional
                     # 9 - x- and RPA correlation part of the Perdew-Wang 92 functional
                     # 10 - non-existent
                     '11': [{'XC_functional_name': 'GGA_X_PBE'},
                            {'XC_functional_name': 'GGA_C_PBE'}],
                     '12': [{'XC_functional_name': 'GGA_X_PBE'}],
                     '13': [{'XC_functional_name': 'GGA_X_LB'},
                            {'XC_functional_name': 'LDA_C_PW'}],
                     '14': [{'XC_functional_name': 'GGA_X_PBE_R'},
                            {'XC_functional_name': '?'}],
                     '15': [{'XC_functional_name': 'GGA_X_RPBE'},
                            {'XC_functional_name': '?'}],
                     '16': [{'XC_functional_name': 'GGA_XC_HCTH_93'}],
                     '17': [{'XC_functional_name': 'GGA_XC_HCTH_120'}],
                     '18': [{'XC_functional_name': 'GGA_X_B88'},
                            {'XC_functional_name': 'GGA_C_LYP'}],
                     '19': [{'XC_functional_name': 'GGA_X_B88'},
                            {'XC_functional_name': 'GGA_C_P86'}],
                     # 20 - Fermi-Amaldi xc ( -1/N Hartree energy, where N is the number of electrons per cell;
                     #      G=0 is not taken into account however), for TDDFT tests.
                     # 21 - same as 20, except that the xc-kernel is the LDA (ixc=1) one, for TDDFT tests.
                     # 22 - same as 20, except that the xc-kernel is the Burke-Petersilka-Gross hybrid, for
                     #      TDDFT tests.
                     '23': [{'XC_functional_name': 'GGA_X_WC'},
                            {'XC_functional_name': '?'}],
                     '24': [{'XC_functional_name': 'GGA_X_C09X'},
                            {'XC_functional_name': '?'}],
                     # 25 - non-existent
                     '26': [{'XC_functional_name': 'GGA_XC_HCTH_147'}],
                     '27': [{'XC_functional_name': 'GGA_XC_HCTH_407'}],
                     '28': [{'XC_functional_name': 'GGA_X_OPTX'},
                            {'XC_functional_name': 'GGA_C_LYP'}],
                     '40': [{'XC_functional_name': 'HF_X'}],
                     '41': [{'XC_functional_name': 'HYB_GGA_XC_PBEH'}],
                     '42': [{'XC_functional_name': 'HYB_GGA_XC_PBE0_13'}]
                     }

ABINIT_LIBXC_IXC = {"1":   {"XC_functional_name": "LDA_X"},
                    "2":   {"XC_functional_name": "LDA_C_WIGNER"},
                    "3":   {"XC_functional_name": "LDA_C_RPA"},
                    "4":   {"XC_functional_name": "LDA_C_HL"},
                    "5":   {"XC_functional_name": "LDA_C_GL"},
                    "6":   {"XC_functional_name": "LDA_C_XALPHA"},
                    "7":   {"XC_functional_name": "LDA_C_VWN"},
                    "8":   {"XC_functional_name": "LDA_C_VWN_RPA"},
                    "9":   {"XC_functional_name": "LDA_C_PZ"},
                    "10":  {"XC_functional_name": "LDA_C_PZ_MOD"},
                    "11":  {"XC_functional_name": "LDA_C_OB_PZ"},
                    "12":  {"XC_functional_name": "LDA_C_PW"},
                    "13":  {"XC_functional_name": "LDA_C_PW_MOD"},
                    "14":  {"XC_functional_name": "LDA_C_OB_PW"},
                    "15":  {"XC_functional_name": "LDA_C_2D_AMGB"},
                    "16":  {"XC_functional_name": "LDA_C_2D_PRM"},
                    "17":  {"XC_functional_name": "LDA_C_vBH"},
                    "18":  {"XC_functional_name": "LDA_C_1D_CSC"},
                    "19":  {"XC_functional_name": "LDA_X_2D"},
                    "20":  {"XC_functional_name": "LDA_XC_TETER93"},
                    "21":  {"XC_functional_name": "LDA_X_1D"},
                    "22":  {"XC_functional_name": "LDA_C_ML1"},
                    "23":  {"XC_functional_name": "LDA_C_ML2"},
                    "24":  {"XC_functional_name": "LDA_C_GOMBAS"},
                    "25":  {"XC_functional_name": "LDA_C_PW_RPA"},
                    "26":  {"XC_functional_name": "LDA_C_1D_LOOS"},
                    "27":  {"XC_functional_name": "LDA_C_RC04"},
                    "28":  {"XC_functional_name": "LDA_C_VWN_1"},
                    "29":  {"XC_functional_name": "LDA_C_VWN_2"},
                    "30":  {"XC_functional_name": "LDA_C_VWN_3"},
                    "31":  {"XC_functional_name": "LDA_C_VWN_4"},
                    "32":  {"XC_functional_name": "GGA_X_GAM"},
                    "33":  {"XC_functional_name": "GGA_C_GAM"},
                    "34":  {"XC_functional_name": "GGA_X_HCTH_A"},
                    "35":  {"XC_functional_name": "GGA_X_EV93"},
                    "36":  {"XC_functional_name": "HYB_MGGA_X_DLDF"},
                    "37":  {"XC_functional_name": "MGGA_C_DLDF"},
                    "38":  {"XC_functional_name": "GGA_X_BCGP"},
                    "39":  {"XC_functional_name": "GGA_C_BCGP"},
                    "40":  {"XC_functional_name": "GGA_X_LAMBDA_OC2_N"},
                    "41":  {"XC_functional_name": "GGA_X_B86_R"},
                    "42":  {"XC_functional_name": "MGGA_XC_ZLP"},
                    "43":  {"XC_functional_name": "LDA_XC_ZLP"},
                    "44":  {"XC_functional_name": "GGA_X_LAMBDA_CH_N"},
                    "45":  {"XC_functional_name": "GGA_X_LAMBDA_LO_N"},
                    "46":  {"XC_functional_name": "GGA_X_HJS_B88_V2"},
                    "47":  {"XC_functional_name": "GGA_C_Q2D"},
                    "48":  {"XC_functional_name": "GGA_X_Q2D"},
                    "49":  {"XC_functional_name": "GGA_X_PBE_MOL"},
                    "50":  {"XC_functional_name": "LDA_K_TF"},
                    "51":  {"XC_functional_name": "LDA_K_LP"},
                    "52":  {"XC_functional_name": "GGA_K_TFVW"},
                    "53":  {"XC_functional_name": "GGA_K_REVAPBEINT"},
                    "54":  {"XC_functional_name": "GGA_K_APBEINT"},
                    "55":  {"XC_functional_name": "GGA_K_REVAPBE"},
                    "56":  {"XC_functional_name": "GGA_X_AK13"},
                    "57":  {"XC_functional_name": "GGA_K_MEYER"},
                    "58":  {"XC_functional_name": "GGA_X_LV_RPW86"},
                    "59":  {"XC_functional_name": "GGA_X_PBE_TCA"},
                    "60":  {"XC_functional_name": "GGA_X_PBEINT"},
                    "61":  {"XC_functional_name": "GGA_C_ZPBEINT"},
                    "62":  {"XC_functional_name": "GGA_C_PBEINT"},
                    "63":  {"XC_functional_name": "GGA_C_ZPBESOL"},
                    "64":  {"XC_functional_name": "MGGA_XC_OTPSS_D"},
                    "65":  {"XC_functional_name": "GGA_XC_OPBE_D"},
                    "66":  {"XC_functional_name": "GGA_XC_OPWLYP_D"},
                    "67":  {"XC_functional_name": "GGA_XC_OBLYP_D"},
                    "68":  {"XC_functional_name": "GGA_X_VMT84_GE"},
                    "69":  {"XC_functional_name": "GGA_X_VMT84_PBE"},
                    "70":  {"XC_functional_name": "GGA_X_VMT_GE"},
                    "71":  {"XC_functional_name": "GGA_X_VMT_PBE"},
                    "72":  {"XC_functional_name": "MGGA_C_CS"},
                    "73":  {"XC_functional_name": "MGGA_C_MN12_SX"},
                    "74":  {"XC_functional_name": "MGGA_C_MN12_L"},
                    "75":  {"XC_functional_name": "MGGA_C_M11_L"},
                    "76":  {"XC_functional_name": "MGGA_C_M11"},
                    "77":  {"XC_functional_name": "MGGA_C_M08_SO"},
                    "78":  {"XC_functional_name": "MGGA_C_M08_HX"},
                    "79":  {"XC_functional_name": "GGA_C_N12_SX"},
                    "80":  {"XC_functional_name": "GGA_C_N12"},
                    "81":  {"XC_functional_name": "HYB_GGA_X_N12_SX"},
                    "82":  {"XC_functional_name": "GGA_X_N12"},
                    "83":  {"XC_functional_name": "GGA_C_REGTPSS"},
                    "84":  {"XC_functional_name": "GGA_C_OP_XALPHA"},
                    "85":  {"XC_functional_name": "GGA_C_OP_G96"},
                    "86":  {"XC_functional_name": "GGA_C_OP_PBE"},
                    "87":  {"XC_functional_name": "GGA_C_OP_B88"},
                    "88":  {"XC_functional_name": "GGA_C_FT97"},
                    "89":  {"XC_functional_name": "GGA_C_SPBE"},
                    "90":  {"XC_functional_name": "GGA_X_SSB_SW"},
                    "91":  {"XC_functional_name": "GGA_X_SSB"},
                    "92":  {"XC_functional_name": "GGA_X_SSB_D"},
                    "93":  {"XC_functional_name": "GGA_XC_HCTH_407P"},
                    "94":  {"XC_functional_name": "GGA_XC_HCTH_P76"},
                    "95":  {"XC_functional_name": "GGA_XC_HCTH_P14"},
                    "96":  {"XC_functional_name": "GGA_XC_B97_GGA1"},
                    "97":  {"XC_functional_name": "GGA_C_HCTH_A"},
                    "98":  {"XC_functional_name": "GGA_X_BPCCAC"},
                    "99":  {"XC_functional_name": "GGA_C_REVTCA"},
                    "100": {"XC_functional_name": "GGA_C_TCA"},
                    "101": {"XC_functional_name": "GGA_X_PBE"},
                    "102": {"XC_functional_name": "GGA_X_PBE_R"},
                    "103": {"XC_functional_name": "GGA_X_B86"},
                    "104": {"XC_functional_name": "GGA_X_HERMAN"},
                    "105": {"XC_functional_name": "GGA_X_B86_MGC"},
                    "106": {"XC_functional_name": "GGA_X_B88"},
                    "107": {"XC_functional_name": "GGA_X_G96"},
                    "108": {"XC_functional_name": "GGA_X_PW86"},
                    "109": {"XC_functional_name": "GGA_X_PW91"},
                    "110": {"XC_functional_name": "GGA_X_OPTX"},
                    "111": {"XC_functional_name": "GGA_X_DK87_R1"},
                    "112": {"XC_functional_name": "GGA_X_DK87_R2"},
                    "113": {"XC_functional_name": "GGA_X_LG93"},
                    "114": {"XC_functional_name": "GGA_X_FT97_A"},
                    "115": {"XC_functional_name": "GGA_X_FT97_B"},
                    "116": {"XC_functional_name": "GGA_X_PBE_SOL"},
                    "117": {"XC_functional_name": "GGA_X_RPBE"},
                    "118": {"XC_functional_name": "GGA_X_WC"},
                    "119": {"XC_functional_name": "GGA_X_MPW91"},
                    "120": {"XC_functional_name": "GGA_X_AM05"},
                    "121": {"XC_functional_name": "GGA_X_PBEA"},
                    "122": {"XC_functional_name": "GGA_X_MPBE"},
                    "123": {"XC_functional_name": "GGA_X_XPBE"},
                    "124": {"XC_functional_name": "GGA_X_2D_B86_MGC"},
                    "125": {"XC_functional_name": "GGA_X_BAYESIAN"},
                    "126": {"XC_functional_name": "GGA_X_PBE_JSJR"},
                    "127": {"XC_functional_name": "GGA_X_2D_B88"},
                    "128": {"XC_functional_name": "GGA_X_2D_B86"},
                    "129": {"XC_functional_name": "GGA_X_2D_PBE"},
                    "130": {"XC_functional_name": "GGA_C_PBE"},
                    "131": {"XC_functional_name": "GGA_C_LYP"},
                    "132": {"XC_functional_name": "GGA_C_P86"},
                    "133": {"XC_functional_name": "GGA_C_PBE_SOL"},
                    "134": {"XC_functional_name": "GGA_C_PW91"},
                    "135": {"XC_functional_name": "GGA_C_AM05"},
                    "136": {"XC_functional_name": "GGA_C_XPBE"},
                    "137": {"XC_functional_name": "GGA_C_LM"},
                    "138": {"XC_functional_name": "GGA_C_PBE_JRGX"},
                    "139": {"XC_functional_name": "GGA_X_OPTB88_VDW"},
                    "140": {"XC_functional_name": "GGA_X_PBEK1_VDW"},
                    "141": {"XC_functional_name": "GGA_X_OPTPBE_VDW"},
                    "142": {"XC_functional_name": "GGA_X_RGE2"},
                    "143": {"XC_functional_name": "GGA_C_RGE2"},
                    "144": {"XC_functional_name": "GGA_X_RPW86"},
                    "145": {"XC_functional_name": "GGA_X_KT1"},
                    "146": {"XC_functional_name": "GGA_XC_KT2"},
                    "147": {"XC_functional_name": "GGA_C_WL"},
                    "148": {"XC_functional_name": "GGA_C_WI"},
                    "149": {"XC_functional_name": "GGA_X_MB88"},
                    "150": {"XC_functional_name": "GGA_X_SOGGA"},
                    "151": {"XC_functional_name": "GGA_X_SOGGA11"},
                    "152": {"XC_functional_name": "GGA_C_SOGGA11"},
                    "153": {"XC_functional_name": "GGA_C_WI0"},
                    "154": {"XC_functional_name": "GGA_XC_TH1"},
                    "155": {"XC_functional_name": "GGA_XC_TH2"},
                    "156": {"XC_functional_name": "GGA_XC_TH3"},
                    "157": {"XC_functional_name": "GGA_XC_TH4"},
                    "158": {"XC_functional_name": "GGA_X_C09X"},
                    "159": {"XC_functional_name": "GGA_C_SOGGA11_X"},
                    "160": {"XC_functional_name": "GGA_X_LB"},
                    "161": {"XC_functional_name": "GGA_XC_HCTH_93"},
                    "162": {"XC_functional_name": "GGA_XC_HCTH_120"},
                    "163": {"XC_functional_name": "GGA_XC_HCTH_147"},
                    "164": {"XC_functional_name": "GGA_XC_HCTH_407"},
                    "165": {"XC_functional_name": "GGA_XC_EDF1"},
                    "166": {"XC_functional_name": "GGA_XC_XLYP"},
                    "167": {"XC_functional_name": "GGA_X_EB88"},
                    "168": {"XC_functional_name": "GGA_C_PBE_MOL"},
                    "169": {"XC_functional_name": "HYB_GGA_XC_PBE_MOL0"},
                    "170": {"XC_functional_name": "GGA_XC_B97_D"},
                    "171": {"XC_functional_name": "HYB_GGA_XC_PBE_SOL0"},
                    "172": {"XC_functional_name": "HYB_GGA_XC_PBEB0"},
                    "173": {"XC_functional_name": "GGA_XC_PBE1W"},
                    "174": {"XC_functional_name": "GGA_XC_MPWLYP1W"},
                    "175": {"XC_functional_name": "GGA_XC_PBELYP1W"},
                    "176": {"XC_functional_name": "HYB_GGA_XC_PBE_MOLB0"},
                    "177": {"XC_functional_name": "GGA_K_ABSP3"},
                    "178": {"XC_functional_name": "GGA_K_ABSP4"},
                    "182": {"XC_functional_name": "GGA_X_LBM"},
                    "183": {"XC_functional_name": "GGA_X_OL2"},
                    "184": {"XC_functional_name": "GGA_X_APBE"},
                    "185": {"XC_functional_name": "GGA_K_APBE"},
                    "186": {"XC_functional_name": "GGA_C_APBE"},
                    "187": {"XC_functional_name": "GGA_K_TW1"},
                    "188": {"XC_functional_name": "GGA_K_TW2"},
                    "189": {"XC_functional_name": "GGA_K_TW3"},
                    "190": {"XC_functional_name": "GGA_K_TW4"},
                    "191": {"XC_functional_name": "GGA_X_HTBS"},
                    "192": {"XC_functional_name": "GGA_X_AIRY"},
                    "193": {"XC_functional_name": "GGA_X_LAG"},
                    "194": {"XC_functional_name": "GGA_XC_MOHLYP"},
                    "195": {"XC_functional_name": "GGA_XC_MOHLYP2"},
                    "196": {"XC_functional_name": "GGA_XC_TH_FL"},
                    "197": {"XC_functional_name": "GGA_XC_TH_FC"},
                    "198": {"XC_functional_name": "GGA_XC_TH_FCFO"},
                    "199": {"XC_functional_name": "GGA_XC_TH_FCO"},
                    "200": {"XC_functional_name": "GGA_C_OPTC"},
                    "201": {"XC_functional_name": "MGGA_X_LTA"},
                    "202": {"XC_functional_name": "MGGA_X_TPSS"},
                    "203": {"XC_functional_name": "MGGA_X_M06_L"},
                    "204": {"XC_functional_name": "MGGA_X_GVT4"},
                    "205": {"XC_functional_name": "MGGA_X_TAU_HCTH"},
                    "206": {"XC_functional_name": "MGGA_X_BR89"},
                    "207": {"XC_functional_name": "MGGA_X_BJ06"},
                    "208": {"XC_functional_name": "MGGA_X_TB09"},
                    "209": {"XC_functional_name": "MGGA_X_RPP09"},
                    "210": {"XC_functional_name": "MGGA_X_2D_PRHG07"},
                    "211": {"XC_functional_name": "MGGA_X_2D_PRHG07_PRP10"},
                    "212": {"XC_functional_name": "MGGA_X_REVTPSS"},
                    "213": {"XC_functional_name": "MGGA_X_PKZB"},
                    "214": {"XC_functional_name": "MGGA_X_M05"},
                    "215": {"XC_functional_name": "MGGA_X_M05_2X"},
                    "216": {"XC_functional_name": "MGGA_X_M06_HF"},
                    "217": {"XC_functional_name": "MGGA_X_M06"},
                    "218": {"XC_functional_name": "MGGA_X_M06_2X"},
                    "219": {"XC_functional_name": "MGGA_X_M08_HX"},
                    "220": {"XC_functional_name": "MGGA_X_M08_SO"},
                    "221": {"XC_functional_name": "MGGA_X_MS0"},
                    "222": {"XC_functional_name": "MGGA_X_MS1"},
                    "223": {"XC_functional_name": "MGGA_X_MS2"},
                    "224": {"XC_functional_name": "HYB_MGGA_X_MS2H"},
                    "225": {"XC_functional_name": "MGGA_X_M11"},
                    "226": {"XC_functional_name": "MGGA_X_M11_L"},
                    "227": {"XC_functional_name": "MGGA_X_MN12_L"},
                    "229": {"XC_functional_name": "MGGA_C_CC06"},
                    "230": {"XC_functional_name": "MGGA_X_MK00"},
                    "231": {"XC_functional_name": "MGGA_C_TPSS"},
                    "232": {"XC_functional_name": "MGGA_C_VSXC"},
                    "233": {"XC_functional_name": "MGGA_C_M06_L"},
                    "234": {"XC_functional_name": "MGGA_C_M06_HF"},
                    "235": {"XC_functional_name": "MGGA_C_M06"},
                    "236": {"XC_functional_name": "MGGA_C_M06_2X"},
                    "237": {"XC_functional_name": "MGGA_C_M05"},
                    "238": {"XC_functional_name": "MGGA_C_M05_2X"},
                    "239": {"XC_functional_name": "MGGA_C_PKZB"},
                    "240": {"XC_functional_name": "MGGA_C_BC95"},
                    "241": {"XC_functional_name": "MGGA_C_REVTPSS"},
                    "242": {"XC_functional_name": "MGGA_XC_TPSSLYP1W"},
                    "243": {"XC_functional_name": "MGGA_X_MK00B"},
                    "244": {"XC_functional_name": "MGGA_X_BLOC"},
                    "245": {"XC_functional_name": "MGGA_X_MODTPSS"},
                    "246": {"XC_functional_name": "GGA_C_PBELOC"},
                    "247": {"XC_functional_name": "MGGA_C_TPSSLOC"},
                    "248": {"XC_functional_name": "HYB_MGGA_X_MN12_SX"},
                    "249": {"XC_functional_name": "MGGA_X_MBEEF"},
                    "250": {"XC_functional_name": "MGGA_X_MBEEFVDW"},
                    "254": {"XC_functional_name": "MGGA_XC_B97M_V"},
                    "255": {"XC_functional_name": "GGA_XC_VV10"},
                    "257": {"XC_functional_name": "MGGA_X_MVS"},
                    "258": {"XC_functional_name": "GGA_C_PBEFE"},
                    "259": {"XC_functional_name": "LDA_XC_KSDT"},
                    "260": {"XC_functional_name": "MGGA_X_MN15_L"},
                    "261": {"XC_functional_name": "MGGA_C_MN15_L"},
                    "262": {"XC_functional_name": "GGA_C_OP_PW91"},
                    "263": {"XC_functional_name": "MGGA_X_SCAN"},
                    "264": {"XC_functional_name": "HYB_MGGA_X_SCAN0"},
                    "265": {"XC_functional_name": "GGA_X_PBEFE"},
                    "266": {"XC_functional_name": "HYB_GGA_XC_B97_1p"},
                    "267": {"XC_functional_name": "MGGA_C_SCAN"},
                    "268": {"XC_functional_name": "HYB_MGGA_X_MN15"},
                    "269": {"XC_functional_name": "MGGA_C_MN15"},
                    "270": {"XC_functional_name": "GGA_X_CAP"},
                    "401": {"XC_functional_name": "HYB_GGA_XC_B3PW91"},
                    "402": {"XC_functional_name": "HYB_GGA_XC_B3LYP"},
                    "403": {"XC_functional_name": "HYB_GGA_XC_B3P86"},
                    "404": {"XC_functional_name": "HYB_GGA_XC_O3LYP"},
                    "405": {"XC_functional_name": "HYB_GGA_XC_mPW1K"},
                    "406": {"XC_functional_name": "HYB_GGA_XC_PBEH"},
                    "407": {"XC_functional_name": "HYB_GGA_XC_B97"},
                    "408": {"XC_functional_name": "HYB_GGA_XC_B97_1"},
                    "410": {"XC_functional_name": "HYB_GGA_XC_B97_2"},
                    "411": {"XC_functional_name": "HYB_GGA_XC_X3LYP"},
                    "412": {"XC_functional_name": "HYB_GGA_XC_B1WC"},
                    "413": {"XC_functional_name": "HYB_GGA_XC_B97_K"},
                    "414": {"XC_functional_name": "HYB_GGA_XC_B97_3"},
                    "415": {"XC_functional_name": "HYB_GGA_XC_MPW3PW"},
                    "416": {"XC_functional_name": "HYB_GGA_XC_B1LYP"},
                    "417": {"XC_functional_name": "HYB_GGA_XC_B1PW91"},
                    "418": {"XC_functional_name": "HYB_GGA_XC_mPW1PW"},
                    "419": {"XC_functional_name": "HYB_GGA_XC_MPW3LYP"},
                    "420": {"XC_functional_name": "HYB_GGA_XC_SB98_1a"},
                    "421": {"XC_functional_name": "HYB_GGA_XC_SB98_1b"},
                    "422": {"XC_functional_name": "HYB_GGA_XC_SB98_1c"},
                    "423": {"XC_functional_name": "HYB_GGA_XC_SB98_2a"},
                    "424": {"XC_functional_name": "HYB_GGA_XC_SB98_2b"},
                    "425": {"XC_functional_name": "HYB_GGA_XC_SB98_2c"},
                    "426": {"XC_functional_name": "HYB_GGA_X_SOGGA11_X"},
                    "427": {"XC_functional_name": "HYB_GGA_XC_HSE03"},
                    "428": {"XC_functional_name": "HYB_GGA_XC_HSE06"},
                    "429": {"XC_functional_name": "HYB_GGA_XC_HJS_PBE"},
                    "430": {"XC_functional_name": "HYB_GGA_XC_HJS_PBE_SOL"},
                    "431": {"XC_functional_name": "HYB_GGA_XC_HJS_B88"},
                    "432": {"XC_functional_name": "HYB_GGA_XC_HJS_B97X"},
                    "433": {"XC_functional_name": "HYB_GGA_XC_CAM_B3LYP"},
                    "434": {"XC_functional_name": "HYB_GGA_XC_TUNED_CAM_B3LYP"},
                    "435": {"XC_functional_name": "HYB_GGA_XC_BHANDH"},
                    "436": {"XC_functional_name": "HYB_GGA_XC_BHANDHLYP"},
                    "437": {"XC_functional_name": "HYB_GGA_XC_MB3LYP_RC04"},
                    "438": {"XC_functional_name": "HYB_MGGA_XC_M05"},
                    "439": {"XC_functional_name": "HYB_MGGA_XC_M05_2X"},
                    "440": {"XC_functional_name": "HYB_MGGA_XC_B88B95"},
                    "441": {"XC_functional_name": "HYB_MGGA_XC_B86B95"},
                    "442": {"XC_functional_name": "HYB_MGGA_XC_PW86B95"},
                    "443": {"XC_functional_name": "HYB_MGGA_XC_BB1K"},
                    "444": {"XC_functional_name": "HYB_MGGA_XC_M06_HF"},
                    "445": {"XC_functional_name": "HYB_MGGA_XC_MPW1B95"},
                    "446": {"XC_functional_name": "HYB_MGGA_XC_MPWB1K"},
                    "447": {"XC_functional_name": "HYB_MGGA_XC_X1B95"},
                    "448": {"XC_functional_name": "HYB_MGGA_XC_XB1K"},
                    "449": {"XC_functional_name": "HYB_MGGA_XC_M06"},
                    "450": {"XC_functional_name": "HYB_MGGA_XC_M06_2X"},
                    "451": {"XC_functional_name": "HYB_MGGA_XC_PW6B95"},
                    "452": {"XC_functional_name": "HYB_MGGA_XC_PWB6K"},
                    "453": {"XC_functional_name": "HYB_GGA_XC_MPWLYP1M"},
                    "454": {"XC_functional_name": "HYB_GGA_XC_REVB3LYP"},
                    "455": {"XC_functional_name": "HYB_GGA_XC_CAMY_BLYP"},
                    "456": {"XC_functional_name": "HYB_GGA_XC_PBE0_13"},
                    "457": {"XC_functional_name": "HYB_MGGA_XC_TPSSH"},
                    "458": {"XC_functional_name": "HYB_MGGA_XC_REVTPSSH"},
                    "459": {"XC_functional_name": "HYB_GGA_XC_B3LYPs"},
                    "460": {"XC_functional_name": "HYB_MGGA_XC_M08_HX"},
                    "461": {"XC_functional_name": "HYB_MGGA_XC_M08_SO"},
                    "462": {"XC_functional_name": "HYB_MGGA_XC_M11"},
                    "463": {"XC_functional_name": "HYB_GGA_XC_WB97"},
                    "464": {"XC_functional_name": "HYB_GGA_XC_WB97X"},
                    "465": {"XC_functional_name": "HYB_GGA_XC_LRC_WPBEH"},
                    "466": {"XC_functional_name": "HYB_GGA_XC_WB97X_V"},
                    "467": {"XC_functional_name": "HYB_GGA_XC_LCY_PBE"},
                    "468": {"XC_functional_name": "HYB_GGA_XC_LCY_BLYP"},
                    "469": {"XC_functional_name": "HYB_GGA_XC_LC_VV10"},
                    "470": {"XC_functional_name": "HYB_GGA_XC_CAMY_B3LYP"},
                    "471": {"XC_functional_name": "HYB_GGA_XC_WB97X_D"},
                    "472": {"XC_functional_name": "HYB_GGA_XC_HPBEINT"},
                    "473": {"XC_functional_name": "HYB_GGA_XC_LRC_WPBE"},
                    "474": {"XC_functional_name": "HYB_MGGA_X_MVSH"},
                    "475": {"XC_functional_name": "HYB_GGA_XC_B3LYP5"},
                    "476": {"XC_functional_name": "HYB_GGA_XC_EDF2"},
                    "477": {"XC_functional_name": "HYB_GGA_XC_CAP0"},
                    "478": {"XC_functional_name": "HYB_GGA_XC_LC_WPBE"},
                    "500": {"XC_functional_name": "GGA_K_VW"},
                    "501": {"XC_functional_name": "GGA_K_GE2"},
                    "502": {"XC_functional_name": "GGA_K_GOLDEN"},
                    "503": {"XC_functional_name": "GGA_K_YT65"},
                    "504": {"XC_functional_name": "GGA_K_BALTIN"},
                    "505": {"XC_functional_name": "GGA_K_LIEB"},
                    "506": {"XC_functional_name": "GGA_K_ABSP1"},
                    "507": {"XC_functional_name": "GGA_K_ABSP2"},
                    "508": {"XC_functional_name": "GGA_K_GR"},
                    "509": {"XC_functional_name": "GGA_K_LUDENA"},
                    "510": {"XC_functional_name": "GGA_K_GP85"},
                    "511": {"XC_functional_name": "GGA_K_PEARSON"},
                    "512": {"XC_functional_name": "GGA_K_OL1"},
                    "513": {"XC_functional_name": "GGA_K_OL2"},
                    "514": {"XC_functional_name": "GGA_K_FR_B88"},
                    "515": {"XC_functional_name": "GGA_K_FR_PW86"},
                    "516": {"XC_functional_name": "GGA_K_DK"},
                    "517": {"XC_functional_name": "GGA_K_PERDEW"},
                    "518": {"XC_functional_name": "GGA_K_VSK"},
                    "519": {"XC_functional_name": "GGA_K_VJKS"},
                    "520": {"XC_functional_name": "GGA_K_ERNZERHOF"},
                    "521": {"XC_functional_name": "GGA_K_LC94"},
                    "522": {"XC_functional_name": "GGA_K_LLP"},
                    "523": {"XC_functional_name": "GGA_K_THAKKAR"},
                    "524": {"XC_functional_name": "GGA_X_WPBEH"},
                    "525": {"XC_functional_name": "GGA_X_HJS_PBE"},
                    "526": {"XC_functional_name": "GGA_X_HJS_PBE_SOL"},
                    "527": {"XC_functional_name": "GGA_X_HJS_B88"},
                    "528": {"XC_functional_name": "GGA_X_HJS_B97X"},
                    "529": {"XC_functional_name": "GGA_X_ITYH"},
                    "530": {"XC_functional_name": "GGA_X_SFAT"},
                    "531": {"XC_functional_name": "HYB_MGGA_XC_WB97M_V"}
                    }