import json

from cve_driller.driller import CVEDriller


if __name__ == "__main__":
    driller = CVEDriller()
    cve_id = "CVE-2020-20276"

    input_path = f"data/inputs/{cve_id}.txt"
    description = open(input_path, 'r').read()

    detail_type, details = driller(description)

    print(details)

    if details:
        output_path = f"data/outputs/{detail_type.value}/{cve_id}.json"

        with open(output_path, 'w') as f:
            json.dump(details, f, indent=4)
