import json
import pandas as pd

from pathlib import Path

data_path = Path(__file__).parent.parent / "data" / "outputs"


def load_data_as_dataframe() -> pd.DataFrame:
    samples = []

    for folder in data_path.iterdir():
        if folder.is_dir():
            for file in folder.iterdir():
                if file.suffix == ".json":
                    with open(file, "r") as f:
                        sample = json.load(f)
                        sample["cve_id"] = file.stem
                        samples.append(sample)

    return pd.DataFrame(samples)


df = load_data_as_dataframe()

#for i, row in df[["cve_id", "impact"]].sort_values(by="cve_id").iterrows():
#    print(row[["cve_id", "impact"]].values)

print(df["impact"].value_counts())
