"use strict";
const assert_1 = require("@aws-cdk/assert");
const lib_1 = require("../lib");
const util_1 = require("./util");
// tslint:disable:max-line-length
const CLUSTER_VERSION = lib_1.KubernetesVersion.V1_16;
module.exports = {
    'basic usage'(test) {
        // GIVEN
        const { stack } = util_1.testFixtureNoVpc();
        const cluster = new lib_1.Cluster(stack, 'cluster', { version: CLUSTER_VERSION });
        const manifest = [
            {
                apiVersion: 'v1',
                kind: 'Service',
                metadata: {
                    name: 'hello-kubernetes',
                },
                spec: {
                    type: 'LoadBalancer',
                    ports: [
                        { port: 80, targetPort: 8080 },
                    ],
                    selector: {
                        app: 'hello-kubernetes',
                    },
                },
            },
            {
                apiVersion: 'apps/v1',
                kind: 'Deployment',
                metadata: {
                    name: 'hello-kubernetes',
                },
                spec: {
                    replicas: 2,
                    selector: {
                        matchLabels: {
                            app: 'hello-kubernetes',
                        },
                    },
                    template: {
                        metadata: {
                            labels: {
                                app: 'hello-kubernetes',
                            },
                        },
                        spec: {
                            containers: [
                                {
                                    name: 'hello-kubernetes',
                                    image: 'paulbouwer/hello-kubernetes:1.5',
                                    ports: [
                                        { containerPort: 8080 },
                                    ],
                                },
                            ],
                        },
                    },
                },
            },
        ];
        // WHEN
        new lib_1.KubernetesResource(stack, 'manifest', {
            cluster,
            manifest,
        });
        assert_1.expect(stack).to(assert_1.haveResource(lib_1.KubernetesResource.RESOURCE_TYPE, {
            Manifest: JSON.stringify(manifest),
        }));
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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