import { Test } from 'nodeunit';
declare const _default: {
    setUp(callback: any): void;
    create: {
        'onCreate: minimal defaults (vpc + role)'(test: Test): Promise<void>;
        'generated cluster name does not exceed 100 characters'(test: Test): Promise<void>;
        'onCreate: explicit cluster name'(test: Test): Promise<void>;
        'with no specific version'(test: Test): Promise<void>;
        'isCreateComplete still not complete if cluster is not ACTIVE'(test: Test): Promise<void>;
        'isCreateComplete is complete when cluster is ACTIVE'(test: Test): Promise<void>;
    };
    delete: {
        'returns correct physical name'(test: Test): Promise<void>;
        'onDelete ignores ResourceNotFoundException'(test: Test): Promise<void>;
        'isDeleteComplete returns false as long as describeCluster succeeds'(test: Test): Promise<void>;
        'isDeleteComplete returns true when describeCluster throws a ResourceNotFound exception'(test: Test): Promise<void>;
        'isDeleteComplete propagates other errors'(test: Test): Promise<void>;
    };
    update: {
        'no change'(test: Test): Promise<void>;
        'isUpdateComplete is not complete when status is not ACTIVE'(test: Test): Promise<void>;
        'isUpdateComplete waits for ACTIVE'(test: Test): Promise<void>;
        'requires replacement': {
            'name change': {
                'explicit name change'(test: Test): Promise<void>;
                'from auto-gen name to explicit name'(test: Test): Promise<void>;
            };
            'subnets or security groups requires a replacement'(test: Test): Promise<void>;
            '"roleArn" requires a replacement'(test: Test): Promise<void>;
            'fails if cluster has an explicit "name" that is the same as the old "name"'(test: Test): Promise<void>;
            'succeeds if cluster had an explicit "name" and now it does not'(test: Test): Promise<void>;
            'succeeds if cluster had an explicit "name" and now it has a different name'(test: Test): Promise<void>;
        };
        'isUpdateComplete with EKS update ID': {
            'with "Failed" status'(test: Test): Promise<void>;
            'with "InProgress" status, returns IsComplete=false'(test: Test): Promise<void>;
            'with "Successful" status, returns IsComplete=true with "Data"'(test: Test): Promise<void>;
        };
        'in-place': {
            'version change': {
                'from undefined to a specific value'(test: Test): Promise<void>;
                'from a specific value to another value'(test: Test): Promise<void>;
                'to a new value that is already the current version'(test: Test): Promise<void>;
                'fails from specific value to undefined'(test: Test): Promise<void>;
            };
            'logging or access change': {
                'from undefined to partial logging enabled'(test: Test): Promise<void>;
                'from partial vpc configuration to only private access enabled'(test: Test): Promise<void>;
                'from undefined to both logging and access fully enabled'(test: Test): Promise<void>;
            };
        };
    };
};
export = _default;
