"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LifecycleLabel = exports.renderBottlerocketUserData = exports.renderAmazonLinuxUserData = void 0;
const core_1 = require("@aws-cdk/core");
// tslint:disable-next-line:max-line-length
function renderAmazonLinuxUserData(clusterName, autoScalingGroup, options = {}) {
    const stack = core_1.Stack.of(autoScalingGroup);
    // determine logical id of ASG so we can signal cloudformation
    const cfn = autoScalingGroup.node.defaultChild;
    const asgLogicalId = cfn.logicalId;
    const extraArgs = new Array();
    extraArgs.push(`--use-max-pods ${options.useMaxPods === undefined ? true : options.useMaxPods}`);
    if (options.awsApiRetryAttempts) {
        extraArgs.push(`--aws-api-retry-attempts ${options.awsApiRetryAttempts}`);
    }
    if (options.enableDockerBridge) {
        extraArgs.push('--enable-docker-bridge true');
    }
    if (options.dockerConfigJson) {
        extraArgs.push(`--docker-config-json '${options.dockerConfigJson}'`);
    }
    if (options.additionalArgs) {
        extraArgs.push(options.additionalArgs);
    }
    const commandLineSuffix = extraArgs.join(' ');
    const kubeletExtraArgsSuffix = options.kubeletExtraArgs || '';
    // determine lifecycle label based on whether the ASG has a spot price.
    const lifecycleLabel = autoScalingGroup.spotPrice ? LifecycleLabel.SPOT : LifecycleLabel.ON_DEMAND;
    const withTaints = autoScalingGroup.spotPrice ? '--register-with-taints=spotInstance=true:PreferNoSchedule' : '';
    const kubeletExtraArgs = `--node-labels lifecycle=${lifecycleLabel} ${withTaints} ${kubeletExtraArgsSuffix}`.trim();
    return [
        'set -o xtrace',
        `/etc/eks/bootstrap.sh ${clusterName} --kubelet-extra-args "${kubeletExtraArgs}" ${commandLineSuffix}`.trim(),
        `/opt/aws/bin/cfn-signal --exit-code $? --stack ${stack.stackName} --resource ${asgLogicalId} --region ${stack.region}`,
    ];
}
exports.renderAmazonLinuxUserData = renderAmazonLinuxUserData;
function renderBottlerocketUserData(cluster) {
    return [
        '[settings.kubernetes]',
        `api-server="${cluster.clusterEndpoint}"`,
        `cluster-certificate="${cluster.clusterCertificateAuthorityData}"`,
        `cluster-name="${cluster.clusterName}"`,
    ];
}
exports.renderBottlerocketUserData = renderBottlerocketUserData;
/**
 * The lifecycle label for node selector
 */
var LifecycleLabel;
(function (LifecycleLabel) {
    /**
     * on-demand instances
     */
    LifecycleLabel["ON_DEMAND"] = "OnDemand";
    /**
     * spot instances
     */
    LifecycleLabel["SPOT"] = "Ec2Spot";
})(LifecycleLabel = exports.LifecycleLabel || (exports.LifecycleLabel = {}));
//# sourceMappingURL=data:application/json;base64,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