# Apologies Python Library

[![pypi](https://img.shields.io/pypi/v/apologies.svg)](https://pypi.org/project/apologies/)
[![license](https://img.shields.io/pypi/l/apologies.svg)](https://github.com/pronovic/apologies/blob/master/LICENSE)
[![wheel](https://img.shields.io/pypi/wheel/apologies.svg)](https://pypi.org/project/apologies/)
[![python](https://img.shields.io/pypi/pyversions/apologies.svg)](https://pypi.org/project/apologies/)
[![Test Suite](https://github.com/pronovic/apologies/workflows/Test%20Suite/badge.svg)](https://github.com/pronovic/apologies/actions?query=workflow%3A%22Test+Suite%22)
[![docs](https://readthedocs.org/projects/apologies/badge/?version=stable&style=flat)](https://apologies.readthedocs.io/en/stable/)
[![coverage](https://coveralls.io/repos/github/pronovic/apologies/badge.svg?branch=master)](https://coveralls.io/github/pronovic/apologies?branch=master)

This is a Python library that implements a game similar to the [Sorry](https://en.wikipedia.org/wiki/Sorry!_(game)) board game.  On UNIX-like platforms, it includes a console demo that plays the game with automated players, intended for use by developers and not by end users.

It was written as a learning exercise and technology demonstration effort, and serves as a complete example of how to manage a modern (circa 2020) Python project, including style checks, code formatting, integration with IntelliJ, [CI builds at GitHub](https://github.com/pronovic/apologies/actions), and integration with [PyPI](https://pypi.org/project/apologies/) and [Read the Docs](https://apologies.readthedocs.io/en/stable/).

Developer documentation is found in [DEVELOPER.md](DEVELOPER.md).  See that file for notes about how the code is structured, how to set up a development environment, etc.

If you want to use this as a starting point for your own repository, check out the [cookiecutter-pypi](https://github.com/pronovic/cookiecutter-pypi) template repository.
