#!/usr/bin/env python3
# @generated AUTOGENERATED file. Do not Change!

from dataclasses import dataclass, field as _field
from ...config import custom_scalars, datetime
from gql_client.runtime.variables import encode_variables
from gql import gql, Client
from gql.transport.exceptions import TransportQueryError
from functools import partial
from numbers import Number
from typing import Any, AsyncGenerator, Dict, List, Generator, Optional
from time import perf_counter
from dataclasses_json import DataClassJsonMixin, config


# fmt: off
QUERY: List[str] = ["""
query SearchQuery(
  $name: String!
  $after: Cursor
  $first: Int = 10
  $before: Cursor
  $last: Int
) {
  searchForNode(
    name: $name
    after: $after
    first: $first
    before: $before
    last: $last
  ) {
    edges {
      node {
        typename: __typename
        ... on Location {
          id
          externalId
          name
          locationType {
            name
          }
        }
      }
    }
  }
}

"""
]


class SearchQuery:
    @dataclass(frozen=True)
    class SearchQueryData(DataClassJsonMixin):
        @dataclass(frozen=True)
        class SearchNodesConnection(DataClassJsonMixin):
            @dataclass(frozen=True)
            class SearchNodeEdge(DataClassJsonMixin):
                @dataclass(frozen=True)
                class Node(DataClassJsonMixin):
                    @dataclass(frozen=True)
                    class LocationType(DataClassJsonMixin):
                        name: str

                    typename: str
                    id: str
                    externalId: Optional[str]
                    name: str
                    locationType: LocationType

                node: Optional[Node]

            edges: List[SearchNodeEdge]

        searchForNode: SearchNodesConnection

    # fmt: off
    @classmethod
    def execute(cls, client: Client, name: str, after: Optional[str] = None, first: Optional[int] = 10, before: Optional[str] = None, last: Optional[int] = None) -> SearchQueryData.SearchNodesConnection:
        variables: Dict[str, Any] = {"name": name, "after": after, "first": first, "before": before, "last": last}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = client.execute(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.SearchQueryData.from_dict(response_text)
        return res.searchForNode

    # fmt: off
    @classmethod
    async def execute_async(cls, client: Client, name: str, after: Optional[str] = None, first: Optional[int] = 10, before: Optional[str] = None, last: Optional[int] = None) -> SearchQueryData.SearchNodesConnection:
        variables: Dict[str, Any] = {"name": name, "after": after, "first": first, "before": before, "last": last}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = await client.execute_async(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.SearchQueryData.from_dict(response_text)
        return res.searchForNode
