#!/usr/bin/env python3
# @generated AUTOGENERATED file. Do not Change!

from dataclasses import dataclass, field as _field
from ...config import custom_scalars, datetime
from gql_client.runtime.variables import encode_variables
from gql import gql, Client
from gql.transport.exceptions import TransportQueryError
from functools import partial
from numbers import Number
from typing import Any, AsyncGenerator, Dict, List, Generator, Optional
from time import perf_counter
from dataclasses_json import DataClassJsonMixin, config

from ..fragment.project_type import ProjectTypeFragment, QUERY as ProjectTypeFragmentQuery


# fmt: off
QUERY: List[str] = ProjectTypeFragmentQuery + ["""
query ProjectTypeDetailsQuery($id: ID!) {
  projectType: node(id: $id) {
    ... on ProjectType {
      ...ProjectTypeFragment
    }
  }
}
"""
]


class ProjectTypeDetailsQuery:
    @dataclass(frozen=True)
    class ProjectTypeDetailsQueryData(DataClassJsonMixin):
        @dataclass(frozen=True)
        class Node(ProjectTypeFragment):
            pass

        projectType: Optional[Node]

    # fmt: off
    @classmethod
    def execute(cls, client: Client, id: str) -> Optional[ProjectTypeDetailsQueryData.Node]:
        variables: Dict[str, Any] = {"id": id}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = client.execute(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.ProjectTypeDetailsQueryData.from_dict(response_text)
        return res.projectType

    # fmt: off
    @classmethod
    async def execute_async(cls, client: Client, id: str) -> Optional[ProjectTypeDetailsQueryData.Node]:
        variables: Dict[str, Any] = {"id": id}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = await client.execute_async(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.ProjectTypeDetailsQueryData.from_dict(response_text)
        return res.projectType
