<a id="mypy-boto3-sso-oidc"></a>

# mypy-boto3-sso-oidc

[![PyPI - mypy-boto3-sso-oidc](https://img.shields.io/pypi/v/mypy-boto3-sso-oidc.svg?color=blue)](https://pypi.org/project/mypy-boto3-sso-oidc)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-sso-oidc.svg?color=blue)](https://pypi.org/project/mypy-boto3-sso-oidc)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-sso-oidc?color=blue)](https://pypistats.org/packages/mypy-boto3-sso-oidc)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.SSOOIDC 1.17.112](https://boto3.amazonaws.com/v1/documentation/api/1.17.112/reference/services/sso-oidc.html#SSOOIDC)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-buider 5.0.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-sso-oidc docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_sso_oidc/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-sso-oidc](#mypy-boto3-sso-oidc)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `SSOOIDC` service.

```bash
python -m pip install boto3-stubs[sso-oidc]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[sso-oidc]` in your environment:
  `python -m pip install 'boto3-stubs[sso-oidc]'`

Both type checking and auto-complete should work for `SSOOIDC` service. No
explicit type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[sso-oidc]` in your environment:
  `python -m pip install 'boto3-stubs[sso-oidc]'`

Both type checking and auto-complete should work for `SSOOIDC` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[sso-oidc]` in your environment:
  `python -m pip install 'boto3-stubs[sso-oidc]'`
- Run `mypy` as usual

Type checking should work for `SSOOIDC` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[sso-oidc]` in your environment:
  `python -m pip install 'boto3-stubs[sso-oidc]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `SSOOIDC` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`SSOOIDCClient` provides annotations for `boto3.client("sso-oidc")`.

```python
import boto3

from mypy_boto3_sso_oidc import SSOOIDCClient

client: SSOOIDCClient = boto3.client("sso-oidc")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: SSOOIDCClient = session.client("sso-oidc")
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_sso_oidc.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_sso_oidc.type_defs import (
    CreateTokenRequestRequestTypeDef,
    CreateTokenResponseTypeDef,
    RegisterClientRequestRequestTypeDef,
    RegisterClientResponseTypeDef,
    ResponseMetadataTypeDef,
    StartDeviceAuthorizationRequestRequestTypeDef,
    StartDeviceAuthorizationResponseTypeDef,
)

def get_structure() -> CreateTokenRequestRequestTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-sso-oidc` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-sso-oidc docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_sso_oidc/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
