# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['LAMP', 'LAMP.api', 'LAMP.models']

package_data = \
{'': ['*']}

install_requires = \
['certifi>=14.05.14',
 'nulltype>=2.3.1,<3.0.0',
 'python-dateutil>=2.5.3',
 'urllib3>=1.15.1']

setup_kwargs = {
    'name': 'lamp-core',
    'version': '2021.5.20',
    'description': 'The LAMP Platform API.',
    'long_description': '# Python API client for the LAMP Platform.\n\n## Overview\n\nThis API client is used to connect to the LAMP Platform from the Python programming language. [Visit our documentation for more information about the LAMP Platform.](https://docs.lamp.digital/)\n\n## Installation\n### Prerequisites\n\nPython 3.4+ and `pip`. \n  - You may need root permissions, using `sudo`.\n  - Alternatively, to install locally, use `pip --user`.\n  - If `pip` is not recognized as a command, use `python3 -m pip`.\n\n### Installation\n\n```sh\npip install LAMP-core\n```\n\n### Configuration\n\nEnsure your `server_address` is set correctly. If using the default server, it will be `api.lamp.digital`. Keep your `access_key` (sometimes an email address) and `secret_key` (sometimes a password) private and do not share them with others.\n\n```python\nimport LAMP\nLAMP.connect(access_key, secret_key, server_address)\n```\n\n## API Endpoints\n\nClass | Method | HTTP request | Description\n------------ | ------------- | ------------- | -------------\n*LAMP.API* | [**query**](docs/APIApi.md#query) | **POST** / | Query the LAMP Database.\n*LAMP.API* | [**schema**](docs/APIApi.md#schema) | **GET** / | View the API schema document.\n*LAMP.Activity* | [**all**](docs/ActivityApi.md#all) | **GET** /activity | Get the set of all activities.\n*LAMP.Activity* | [**all_by_participant**](docs/ActivityApi.md#all_by_participant) | **GET** /participant/{participant_id}/activity | Get all activities for a participant.\n*LAMP.Activity* | [**all_by_researcher**](docs/ActivityApi.md#all_by_researcher) | **GET** /researcher/{researcher_id}/activity | Get all activities for a researcher.\n*LAMP.Activity* | [**all_by_study**](docs/ActivityApi.md#all_by_study) | **GET** /study/{study_id}/activity | Get all activities in a study.\n*LAMP.Activity* | [**create**](docs/ActivityApi.md#create) | **POST** /study/{study_id}/activity | Create a new Activity under the given Study.\n*LAMP.Activity* | [**delete**](docs/ActivityApi.md#delete) | **DELETE** /activity/{activity_id} | Delete an Activity.\n*LAMP.Activity* | [**update**](docs/ActivityApi.md#update) | **PUT** /activity/{activity_id} | Update an Activity&#39;s settings.\n*LAMP.Activity* | [**view**](docs/ActivityApi.md#view) | **GET** /activity/{activity_id} | Get a single activity, by identifier.\n*LAMP.ActivityEvent* | [**all_by_participant**](docs/ActivityEventApi.md#all_by_participant) | **GET** /participant/{participant_id}/activity_event | Get all activity events for a participant.\n*LAMP.ActivityEvent* | [**all_by_researcher**](docs/ActivityEventApi.md#all_by_researcher) | **GET** /researcher/{researcher_id}/activity_event | Get all activity events for a researcher by participant.\n*LAMP.ActivityEvent* | [**all_by_study**](docs/ActivityEventApi.md#all_by_study) | **GET** /study/{study_id}/activity_event | Get all activity events for a study by participant.\n*LAMP.ActivityEvent* | [**create**](docs/ActivityEventApi.md#create) | **POST** /participant/{participant_id}/activity_event | Create a new ActivityEvent for the given Participant.\n*LAMP.ActivityEvent* | [**delete**](docs/ActivityEventApi.md#delete) | **DELETE** /participant/{participant_id}/activity_event | Delete a ActivityEvent.\n*LAMP.ActivitySpec* | [**all**](docs/ActivitySpecApi.md#all) | **GET** /activity_spec | Get all ActivitySpecs registered.\n*LAMP.ActivitySpec* | [**create**](docs/ActivitySpecApi.md#create) | **POST** /activity_spec | Create a new ActivitySpec.\n*LAMP.ActivitySpec* | [**delete**](docs/ActivitySpecApi.md#delete) | **DELETE** /activity_spec/{activity_spec_name} | Delete an ActivitySpec.\n*LAMP.ActivitySpec* | [**update**](docs/ActivitySpecApi.md#update) | **PUT** /activity_spec/{activity_spec_name} | Update an ActivitySpec.\n*LAMP.ActivitySpec* | [**view**](docs/ActivitySpecApi.md#view) | **GET** /activity_spec/{activity_spec_name} | View an ActivitySpec.\n*LAMP.Credential* | [**create**](docs/CredentialApi.md#create) | **POST** /type/{type_id}/credential | \n*LAMP.Credential* | [**delete**](docs/CredentialApi.md#delete) | **DELETE** /type/{type_id}/credential/{access_key} | \n*LAMP.Credential* | [**list**](docs/CredentialApi.md#list) | **GET** /type/{type_id}/credential | \n*LAMP.Credential* | [**update**](docs/CredentialApi.md#update) | **PUT** /type/{type_id}/credential/{access_key} | \n*LAMP.Participant* | [**all**](docs/ParticipantApi.md#all) | **GET** /participant | Get the set of all participants.\n*LAMP.Participant* | [**all_by_researcher**](docs/ParticipantApi.md#all_by_researcher) | **GET** /researcher/{researcher_id}/participant | Get the set of all participants under a single researcher.\n*LAMP.Participant* | [**all_by_study**](docs/ParticipantApi.md#all_by_study) | **GET** /study/{study_id}/participant | Get the set of all participants in a single study.\n*LAMP.Participant* | [**create**](docs/ParticipantApi.md#create) | **POST** /study/{study_id}/participant | Create a new Participant for the given Study.\n*LAMP.Participant* | [**delete**](docs/ParticipantApi.md#delete) | **DELETE** /participant/{participant_id} | Delete a participant AND all owned data or event streams.\n*LAMP.Participant* | [**update**](docs/ParticipantApi.md#update) | **PUT** /participant/{participant_id} | Update a Participant&#39;s settings.\n*LAMP.Participant* | [**view**](docs/ParticipantApi.md#view) | **GET** /participant/{participant_id} | Get a single participant, by identifier.\n*LAMP.Researcher* | [**all**](docs/ResearcherApi.md#all) | **GET** /researcher | Get the set of all researchers.\n*LAMP.Researcher* | [**create**](docs/ResearcherApi.md#create) | **POST** /researcher | Create a new Researcher.\n*LAMP.Researcher* | [**delete**](docs/ResearcherApi.md#delete) | **DELETE** /researcher/{researcher_id} | Delete a researcher.\n*LAMP.Researcher* | [**update**](docs/ResearcherApi.md#update) | **PUT** /researcher/{researcher_id} | Update a Researcher&#39;s settings.\n*LAMP.Researcher* | [**view**](docs/ResearcherApi.md#view) | **GET** /researcher/{researcher_id} | Get a single researcher, by identifier.\n*LAMP.Sensor* | [**all**](docs/SensorApi.md#all) | **GET** /sensor | Get the set of all sensors.\n*LAMP.Sensor* | [**all_by_participant**](docs/SensorApi.md#all_by_participant) | **GET** /participant/{participant_id}/sensor | Get all sensors for a participant.\n*LAMP.Sensor* | [**all_by_researcher**](docs/SensorApi.md#all_by_researcher) | **GET** /researcher/{researcher_id}/sensor | Get all sensors for a researcher.\n*LAMP.Sensor* | [**all_by_study**](docs/SensorApi.md#all_by_study) | **GET** /study/{study_id}/sensor | View all sensors in a study.\n*LAMP.Sensor* | [**create**](docs/SensorApi.md#create) | **POST** /study/{study_id}/sensor | Create a new Sensor under the given Study.\n*LAMP.Sensor* | [**delete**](docs/SensorApi.md#delete) | **DELETE** /sensor/{sensor_id} | Delete a Sensor.\n*LAMP.Sensor* | [**update**](docs/SensorApi.md#update) | **PUT** /sensor/{sensor_id} | Update an Sensor&#39;s settings.\n*LAMP.Sensor* | [**view**](docs/SensorApi.md#view) | **GET** /sensor/{sensor_id} | Get a single sensor, by identifier.\n*LAMP.SensorEvent* | [**all_by_participant**](docs/SensorEventApi.md#all_by_participant) | **GET** /participant/{participant_id}/sensor_event | Get all sensor events for a participant.\n*LAMP.SensorEvent* | [**all_by_researcher**](docs/SensorEventApi.md#all_by_researcher) | **GET** /researcher/{researcher_id}/sensor_event | Get all sensor events for a researcher by participant.\n*LAMP.SensorEvent* | [**all_by_study**](docs/SensorEventApi.md#all_by_study) | **GET** /study/{study_id}/sensor_event | Get all sensor events for a study by participant.\n*LAMP.SensorEvent* | [**create**](docs/SensorEventApi.md#create) | **POST** /participant/{participant_id}/sensor_event | Create a new SensorEvent for the given Participant.\n*LAMP.SensorEvent* | [**delete**](docs/SensorEventApi.md#delete) | **DELETE** /participant/{participant_id}/sensor_event | Delete a sensor event.\n*LAMP.SensorSpec* | [**all**](docs/SensorSpecApi.md#all) | **GET** /sensor_spec | Get all SensorSpecs registered.\n*LAMP.SensorSpec* | [**create**](docs/SensorSpecApi.md#create) | **POST** /sensor_spec | Create a new SensorSpec.\n*LAMP.SensorSpec* | [**delete**](docs/SensorSpecApi.md#delete) | **DELETE** /sensor_spec/{sensor_spec_name} | Delete an SensorSpec.\n*LAMP.SensorSpec* | [**update**](docs/SensorSpecApi.md#update) | **PUT** /sensor_spec/{sensor_spec_name} | Update an SensorSpec.\n*LAMP.SensorSpec* | [**view**](docs/SensorSpecApi.md#view) | **GET** /sensor_spec/{sensor_spec_name} | Get a SensorSpec.\n*LAMP.Study* | [**all**](docs/StudyApi.md#all) | **GET** /study | Get the set of all studies.\n*LAMP.Study* | [**all_by_researcher**](docs/StudyApi.md#all_by_researcher) | **GET** /researcher/{researcher_id}/study | Get the set of studies for a single researcher.\n*LAMP.Study* | [**create**](docs/StudyApi.md#create) | **POST** /researcher/{researcher_id}/study | Create a new Study for the given Researcher.\n*LAMP.Study* | [**delete**](docs/StudyApi.md#delete) | **DELETE** /study/{study_id} | Delete a study.\n*LAMP.Study* | [**update**](docs/StudyApi.md#update) | **PUT** /study/{study_id} | Update the study.\n*LAMP.Study* | [**view**](docs/StudyApi.md#view) | **GET** /study/{study_id} | Get a single study, by identifier.\n*LAMP.Type* | [**get_attachment**](docs/TypeApi.md#get_attachment) | **GET** /type/{type_id}/attachment/{attachment_key} | \n*LAMP.Type* | [**get_dynamic_attachment**](docs/TypeApi.md#get_dynamic_attachment) | **GET** /type/{type_id}/attachment/dynamic/{attachment_key} | \n*LAMP.Type* | [**list_attachments**](docs/TypeApi.md#list_attachments) | **GET** /type/{type_id}/attachment | \n*LAMP.Type* | [**parent**](docs/TypeApi.md#parent) | **GET** /type/{type_id}/parent | Find the owner(s) of the resource.\n*LAMP.Type* | [**set_attachment**](docs/TypeApi.md#set_attachment) | **PUT** /type/{type_id}/attachment/{attachment_key}/{target} | \n*LAMP.Type* | [**set_dynamic_attachment**](docs/TypeApi.md#set_dynamic_attachment) | **PUT** /type/{type_id}/attachment/dynamic/{attachment_key}/{target} | \n\n\n## Documentation For Models\n\n - [AccessCitation](docs/AccessCitation.md)\n - [Activity](docs/Activity.md)\n - [ActivityEvent](docs/ActivityEvent.md)\n - [ActivitySpec](docs/ActivitySpec.md)\n - [Credential](docs/Credential.md)\n - [Document](docs/Document.md)\n - [DurationInterval](docs/DurationInterval.md)\n - [DurationIntervalLegacy](docs/DurationIntervalLegacy.md)\n - [DynamicAttachment](docs/DynamicAttachment.md)\n - [Error](docs/Error.md)\n - [Metadata](docs/Metadata.md)\n - [Participant](docs/Participant.md)\n - [Researcher](docs/Researcher.md)\n - [Sensor](docs/Sensor.md)\n - [SensorEvent](docs/SensorEvent.md)\n - [SensorSpec](docs/SensorSpec.md)\n - [Study](docs/Study.md)\n - [TemporalSlice](docs/TemporalSlice.md)\n',
    'author': 'Division of Digital Psychiatry at Beth Israel Deaconess Medical Center',
    'author_email': 'team@digitalpsych.org',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://docs.lamp.digital/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.0,<4.0',
}


setup(**setup_kwargs)
