from enum import Enum, EnumMeta, unique

@unique
class ContractErrors(Enum):
    ERROR_40001 = "Cloud account not found"
    ERROR_40002 = "out_trade_no not found"
    ERROR_40003 = "out_trade_no already existed"
    ERROR_40004 = "Cloud account count limit"
    ERROR_40005 = "Transfer vol precision error"
    ERROR_40006 = "Invalid ip error"
    ERROR_40007 = "Parse parameter error"
    ERROR_40008 = "Check nonce error"
    ERROR_40009 = "Check ver error"
    ERROR_40010 = "Not found func error"
    ERROR_40011 = "Invalid request"
    ERROR_40012 = "System error"
    ERROR_40013 = "Access too often: CLIENT_TIME_INVALID. Please check your system time."
    ERROR_40014 = "This contract is offline"
    ERROR_40015 = "This contract's exchange has been paused"
    ERROR_40016 = "This order would trigger user position liquidate"
    ERROR_40017 = "It is not possible to open and close simultaneously in the same position"
    ERROR_40018 = "Your position is closed"
    ERROR_40019 = "Your position is in liquidation delegating"
    ERROR_40020 = "Your position volume is not enough"
    ERROR_40021 = "The position is not exsit"
    ERROR_40022 = "The position is not isolated"
    ERROR_40023 = "The position would liquidate when sub margin"
    ERROR_40024 = "The position would be warnning of liquidation when sub margin"
    ERROR_40025 = "The position's margin should not be lower than the base limit"
    ERROR_40026 = "You cross margin position is in liquidation delegating"
    ERROR_40027 = "You contract account available balance not enough"
    ERROR_40028 = "Your plan order's count is more than system maximum limit."
    ERROR_40029 = "The order's leverage is too large."
    ERROR_40030 = "The order's leverage is too small."
    ERROR_40031 = "The deviation between current price and trigger price is too large."
    ERROR_40032 = "The plan order's life cycle is too long."
    ERROR_40033 = "The plan order's life cycle is too short."
    ERROR_40034 = "The Symbol is not exist"
    ERROR_40035 = "The order is not exist"
    ERROR_40036 = "The order status is invalid"
    ERROR_40037 = "The order id is not exist"
    ERROR_40038 = "The k-line step is invalid"
    ERROR_40039 = "The timestamp is invalid"
    ERROR_40040 = "The order leverage is invalid"
    ERROR_40041 = "The order side is invalid"
    ERROR_40042 = "The order type is invalid"
    ERROR_40043 = "The order precision is invalid"
    ERROR_40044 = "The order range is invalid"
    ERROR_40045 = "The order open type is invalid"
    ERROR_40046 = "The account is not opened futures"

@unique
class AuthenticationErrors(Enum):
    ERROR_30000 = "Not found"
    ERROR_30001 = "Header X-BM-KEY is empty"
    ERROR_30002 = "Header X-BM-KEY not found"
    ERROR_30003 = "Header X-BM-KEY has frozen"
    ERROR_30004 = "Header X-BM-SIGN is empty"
    ERROR_30005 = "Header X-BM-SIGN is wrong"
    ERROR_30006 = "Header X-BM-TIMESTAMP is empty"
    ERROR_30007 = "Header X-BM-TIMESTAMP range. Within a minute"
    ERROR_30008 = "Header X-BM-TIMESTAMP invalid format"
    ERROR_30010 = "IP is forbidden. We recommend enabling IP whitelist for API trading. After that reauth your account"
    ERROR_30011 = "Header X-BM-KEY over expire time"
    ERROR_30012 = "Header X-BM-KEY is forbidden to request it"
    ERROR_30013 = "Request too many requests"
    ERROR_30014 = "Service unavailable"

@unique
class AccountErrors(Enum):
    ERROR_60000 = "Invalid request (maybe the body is empty, or the int parameter passes string data)"
    ERROR_60001 = "Asset account type does not exist"
    ERROR_60002 = "currency does not exist"
    ERROR_60003 = "Currency has been closed recharge channel, if there is any problem, please consult customer service"
    ERROR_60004 = "Currency has been closed withdraw channel, if there is any problem, please consult customer service"
    ERROR_60005 = "Minimum amount error"
    ERROR_60006 = "Maximum withdraw precision is error"
    ERROR_60007 = "Only withdrawals from added addresses are allowed"
    ERROR_60008 = "Balance not enough"
    ERROR_60009 = "Beyond the limit"
    ERROR_60010 = "Withdraw id or deposit id not found"
    ERROR_60011 = "Address is not valid"
    ERROR_60012 = "This action is not supported in this currency(If IOTA, HLX recharge and withdraw calls are prohibited)"
    ERROR_61003 = "The specified sub-account could not be found"
    ERROR_61004 = "Duplicate requests (such as using an existing requestNo)"
    ERROR_60020 = "Your account is not allowed to recharge"
    ERROR_60021 = "Your account is not allowed to withdraw"
    ERROR_60022 = "No withdrawals for 24 hours"
    ERROR_60026 = "Sub-account does not have permission to operate"
    ERROR_60027 = "Only supports sub-account calls"
    ERROR_60028 = "Account is disabled for security reasons, please contact customer service"
    ERROR_60029 = "The account is frozen by the master account, please contact the master account to unfreeze the account"
    ERROR_61005 = "Asset transfer between accounts is not available"
    ERROR_61006 = "The sub-account api only supports organization accounts"
    ERROR_60030 = "Method Not Allowed"
    ERROR_60031 = "Unsupported Media Type"
    ERROR_60050 = "User account not found"
    ERROR_60051 = "Internal Server Error"

@unique
class SpotMarginErrors(Enum):
    ERROR_50000 = "Bad Request"
    ERROR_50001 = "Symbol not found"
    ERROR_50002 = "From Or To format error"
    ERROR_50003 = "Step format error"
    ERROR_50004 = "Kline size over 500"
    ERROR_50005 = "Order Id not found"
    ERROR_50006 = "Minimum size is %s"
    ERROR_50007 = "Maximum size is %s"
    ERROR_50008 = "Minimum price is %s"
    ERROR_50009 = "Minimum count*price is %s"
    ERROR_50010 = "RequestParam size is required"
    ERROR_50011 = "RequestParam price is required"
    ERROR_50012 = "RequestParam notional is required"
    ERROR_50013 = "Maximum limit*offset is %d"
    ERROR_50014 = "RequestParam limit is required"
    ERROR_50015 = "Minimum limit is 1"
    ERROR_50016 = "Maximum limit is %d"
    ERROR_50017 = "RequestParam offset is required"
    ERROR_50018 = "Minimum offset is 1"
    ERROR_50019 = "Invalid status. validate status is [1=Failed, 2=Success, 3=Frozen Failed, 4=Frozen Success, 5=Partially Filled, 6=Fully Fulled, 7=Canceling, 8=Canceled"
    ERROR_50020 = "Balance not enough"
    ERROR_50021 = "Invalid %s"
    ERROR_50022 = "Service unavailable"
    ERROR_50023 = "This Symbol can't place order by api"
    ERROR_50024 = "Order book size over 200"
    ERROR_50025 = "Maximum price is %s"
    ERROR_50026 = "The buy order price cannot be higher than the open price"
    ERROR_50027 = "The sell order price cannot be lower than the open price"
    ERROR_50028 = "Missing parameters"
    ERROR_50029 = "The parameters do not match"
    ERROR_50030 = "Order is already canceled"
    ERROR_50031 = "Order is already completed"
    ERROR_50032 = "Order does not exist"
    ERROR_50033 = "The order quantity should be greater than 0 and less than or equal to 10"
    ERROR_50034 = "The price is high and there is no matching depth"
    ERROR_50035 = "The price is low and there is no matching depth"
    ERROR_50036 = "Cancel failed, order is not revocable status"
    ERROR_50037 = "The maximum length of clientOrderId cannot exceed 32"
    ERROR_50038 = "ClientOrderId only allows a combination of numbers and letters"
    ERROR_50039 = "Order_id and clientOrderId cannot be empty at the same time"
    ERROR_50040 = "Symbol Not Available"
    ERROR_50041 = "Out of query time range"
    ERROR_51000 = "Currency not found"
    ERROR_51001 = "Margin Account not Opened"
    ERROR_51002 = "Margin Account Not Available"
    ERROR_51003 = "Account Limit"
    ERROR_51004 = "Exceed the maximum number of borrows available"
    ERROR_51005 = "Less than the minimum borrowable amount"
    ERROR_51006 = "Exceeds the amount to be repaid"
    ERROR_51007 = "order_mode not found"
    ERROR_51008 = "Operation is limited, please try again later"
    ERROR_51009 = "Parameter mismatch: limit order/market order quantity should be greater than the minimum number of should buy/sell"
    ERROR_51010 = "Parameter mismatch: limit order price should be greater than the minimum buy price"
    ERROR_51011 = "Parameter mismatch: Limit order quantity * price should be greater than the minimum transaction amount"
    ERROR_51012 = "Participation mismatch: the number of market order buy orders should be greater than the minimum buyable amount"
    ERROR_51013 = "Parameter mismatch: the price of market order buy order placed is too small"
    ERROR_51014 = "Parameter mismatch: the amount of market order sell orders placed is too small"
    ERROR_51015 = "Quantity is too small"
    ERROR_53000 = "Your account is frozen due to security policies. Please contact customer service"
    ERROR_53001 = "Your kyc country is restricted. Please contact customer service."
    ERROR_53002 = "Your account has not yet completed the kyc advanced certification, please complete first"
    ERROR_53003 = "No permission, please contact the main account"
    ERROR_53004 = "This trading pair is not available to trade in your region"
    ERROR_57001 = "Method Not Allowed"
    ERROR_58001 = "Unsupported Media Type"
    ERROR_59001 = "User account not found"
    ERROR_59002 = "Internal Server Error"
    ERROR_59003 = "Spot wallet call fail"
    ERROR_59004 = "Margin wallet service call exception"
    ERROR_59005 = "Margin wallet service restricted"
    ERROR_59006 = "Transfer fail"
    ERROR_59007 = "Get symbol risk data fail"
    ERROR_59008 = "Trading order failure"
    ERROR_59009 = "Loan success,but trading order failure"


@unique
class WebsocketErrors(Enum):
    ERROR_90001 = "Invalid message format"
    ERROR_90002 = "Invalid op param"
    ERROR_90003 = "Invalid args param"
    ERROR_90004 = "Invalid channel param"
    ERROR_91001 = "API KEY is empty"
    ERROR_91002 = "API KEY not found"
    ERROR_91003 = "API KEY has frozen"
    ERROR_91004 = "API KEY over expire time"
    ERROR_91005 = "Already logged in"
    ERROR_91006 = "User not logged in / User must be logged in"
    ERROR_91010 = "Param sign is empty"
    ERROR_91011 = "Param sign is wrong"
    ERROR_91021 = "Param timestamp is empty"
    ERROR_91022 = "Param timestamp range. Within a minute"
    ERROR_91023 = "Param timestamp invalid format"
    ERROR_92001 = "Invalid symbol param"
    ERROR_94001 = "Request frequency exceeds limit"
    ERROR_95000 = "Internal system error"


