# About
<!-- UPDATE VERSION IN BADGE MANUALLY -->
![PyPI Version](https://img.shields.io/badge/pypi-v0.2.1-orange)
![Build](https://img.shields.io/github/workflow/status/andrewt110216/iq-tester-game/Tests?style=plastic)

`iqtester` is a simple command-line version of the classic game "IQ Tester"

[PyPI Home Page](https://pypi.org/project/iqtester/)

# Quick Start

## How to Play

IQ Tester is played on a triangular board, typically with 5 rows of holes and pegs.

Start with any one hole empty. As you jump the pegs remove them from the board.

Try to leave only one peg. See how you rate!

## Support Python Versions

Python 3.7+

## Mac / Linux
```
pip install iqtester
python3 -m iqtester
```

## Windows
```
pip install iqtester
python -m iqtester
```

# Demos

## Standard Game

*A standard game looks like this (current board is on the bottom):*

<img src="demo-gifs/play.gif">

<br>

## Ask for a Hint

*Request a hint using '>' to see the move that would lead to the best possible outcome*

<img src="demo-gifs/hint.gif">

<br>


## Undo a Move

*Undo the last move using '.' if you made a mistake or found a better move*

<img src="demo-gifs/back.gif">

<br>

## Multiple Pegs to Jump

*To move a peg that has multiple possible jumps, choose the peg to move then choose the peg to jump over*

<img src="demo-gifs/multiple-jumps.gif">

<br>

## Change Board Size

*Change the board size to have 4, 5, or 6 rows*

<img src="demo-gifs/increase-size.gif">

<br>