/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.bits;

import it.unimi.dsi.bits.AbstractBitVector;
import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.bits.TransformationStrategies;
import it.unimi.dsi.bits.TransformationStrategy;
import it.unimi.dsi.io.OfflineIterable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BitVectors {
    public static final BitVector EMPTY_VECTOR = new AbstractBitVector(){

        public final long length() {
            return 0L;
        }

        public final BitVector copy(long from, long to) {
            BitVectors.ensureFromTo(0L, from, to);
            return EMPTY_VECTOR;
        }

        public final boolean getBoolean(long index) {
            throw new IndexOutOfBoundsException();
        }

        public BitVector copy() {
            return this;
        }

        public Object readResolve() {
            return EMPTY_VECTOR;
        }
    };
    public static final BitVector ZERO = new AbstractBitVector(){

        public final long length() {
            return 1L;
        }

        public final BitVector copy(long from, long to) {
            BitVectors.ensureFromTo(1L, from, to);
            return from == to ? EMPTY_VECTOR : this;
        }

        public final boolean getBoolean(long index) {
            if (index > 0L) {
                throw new IndexOutOfBoundsException();
            }
            return false;
        }

        public BitVector copy() {
            return this;
        }

        public Object readResolve() {
            return ZERO;
        }
    };
    public static final BitVector ONE = new AbstractBitVector(){

        public final long length() {
            return 1L;
        }

        public final BitVector copy(long from, long to) {
            BitVectors.ensureFromTo(1L, from, to);
            return from == to ? EMPTY_VECTOR : this;
        }

        public final boolean getBoolean(long index) {
            if (index > 0L) {
                throw new IndexOutOfBoundsException();
            }
            return true;
        }

        public BitVector copy() {
            return this;
        }

        public Object readResolve() {
            return ONE;
        }
    };
    public static BitVectorOfflineSerializer OFFLINE_SERIALIZER = new BitVectorOfflineSerializer();

    private BitVectors() {
    }

    @Deprecated
    public static <T extends BitVector> TransformationStrategy<T> identity() {
        return TransformationStrategies.identity();
    }

    public static void ensureFromTo(long bitVectorLength, long from, long to) {
        if (from < 0L) {
            throw new ArrayIndexOutOfBoundsException("Start index (" + from + ") is negative");
        }
        if (from > to) {
            throw new IllegalArgumentException("Start index (" + from + ") is greater than end index (" + to + ")");
        }
        if (to > bitVectorLength) {
            throw new ArrayIndexOutOfBoundsException("End index (" + to + ") is greater than bit vector length (" + bitVectorLength + ")");
        }
    }

    public static void writeFast(BitVector v, DataOutputStream dos) throws IOException {
        long i;
        long length = v.length();
        long l = length - length % 64L;
        dos.writeLong(length);
        for (i = 0L; i < l; i += 64L) {
            dos.writeLong(v.getLong(i, i + 64L));
        }
        if (i < length) {
            dos.writeLong(v.getLong(i, length));
        }
    }

    public static LongArrayBitVector readFast(DataInputStream dis) throws IOException {
        long length = dis.readLong();
        long[] bits = new long[LongArrayBitVector.numWords(length)];
        int l = bits.length;
        for (int i = 0; i < l; ++i) {
            bits[i] = dis.readLong();
        }
        return LongArrayBitVector.wrap(bits, length);
    }

    public static LongArrayBitVector readFast(DataInputStream dis, LongArrayBitVector bv) throws IOException {
        long length = dis.readLong();
        bv.ensureCapacity(length);
        int l = LongArrayBitVector.numWords(length);
        for (int i = 0; i < l; ++i) {
            bv.bits[i] = dis.readLong();
        }
        bv.length(length);
        return bv;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BitVectorOfflineSerializer
    implements OfflineIterable.Serializer<BitVector, LongArrayBitVector> {
        private BitVectorOfflineSerializer() {
        }

        @Override
        public void write(BitVector bv, DataOutputStream dos) throws IOException {
            BitVectors.writeFast(bv, dos);
        }

        @Override
        public void read(DataInputStream dis, LongArrayBitVector bv) throws IOException {
            BitVectors.readFast(dis, bv);
        }
    }
}

