/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.search;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.parameters.AxiomAnnotations;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.search.Filters;
import org.semanticweb.owlapi.search.Searcher;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public class EntitySearcher {
    private EntitySearcher() {
    }

    public static Stream<OWLAnnotation> getAnnotations(OWLEntity e, OWLOntology ontology) {
        return EntitySearcher.getAnnotations(e.getIRI(), ontology);
    }

    public static Stream<OWLAnnotation> getAnnotations(OWLAnnotationSubject e, OWLOntology ontology) {
        return Searcher.annotations(ontology.annotationAssertionAxioms(e));
    }

    public static Stream<OWLAnnotation> getAnnotations(OWLEntity e, OWLOntology ontology, OWLAnnotationProperty annotationProperty) {
        return EntitySearcher.getAnnotations((OWLAnnotationSubject)e.getIRI(), ontology, annotationProperty);
    }

    public static Stream<OWLAnnotation> getAnnotationObjects(OWLEntity e, OWLOntology ontology, @Nullable OWLAnnotationProperty annotationProperty) {
        return EntitySearcher.getAnnotationObjects((OWLAnnotationSubject)e.getIRI(), ontology, annotationProperty);
    }

    public static Stream<OWLAnnotation> getAnnotationObjects(OWLEntity e, OWLOntology ontology) {
        return EntitySearcher.getAnnotationObjects((OWLAnnotationSubject)e.getIRI(), ontology, null);
    }

    public static Stream<OWLAnnotation> getAnnotationObjects(OWLAnnotationSubject e, OWLOntology ontology, @Nullable OWLAnnotationProperty annotationProperty) {
        return Searcher.annotationObjects(ontology.annotationAssertionAxioms(e), annotationProperty);
    }

    public static Stream<OWLAnnotation> getAnnotationObjects(OWLAnnotationSubject e, Stream<OWLOntology> ontologies, @Nullable OWLAnnotationProperty annotationProperty) {
        return ontologies.flatMap(o -> EntitySearcher.getAnnotationObjects(e, o, annotationProperty));
    }

    public static Stream<OWLAnnotation> getAnnotationObjects(OWLEntity e, Stream<OWLOntology> ontologies, @Nullable OWLAnnotationProperty annotationProperty) {
        return ontologies.flatMap(o -> EntitySearcher.getAnnotationObjects(e, o, annotationProperty));
    }

    public static Stream<OWLAnnotation> getAnnotations(OWLAnnotationSubject e, OWLOntology ontology, OWLAnnotationProperty annotationProperty) {
        return Searcher.annotations(ontology.annotationAssertionAxioms(e), annotationProperty);
    }

    public static Stream<OWLAnnotation> getAnnotations(OWLAnnotationSubject e, Stream<OWLOntology> ontologies, OWLAnnotationProperty annotationProperty) {
        return ontologies.flatMap(o -> EntitySearcher.getAnnotations(e, o, annotationProperty));
    }

    public static Stream<OWLAnnotation> getAnnotations(OWLEntity e, Stream<OWLOntology> ontologies, OWLAnnotationProperty annotationProperty) {
        return ontologies.flatMap(o -> EntitySearcher.getAnnotations(e, o, annotationProperty));
    }

    public static Stream<OWLAnnotationAssertionAxiom> getAnnotationAssertionAxioms(OWLEntity e, OWLOntology ontology) {
        return EntitySearcher.getAnnotationAssertionAxioms(e.getIRI(), ontology);
    }

    public static Stream<OWLAnnotationAssertionAxiom> getAnnotationAssertionAxioms(OWLAnnotationSubject e, OWLOntology ontology) {
        return ontology.annotationAssertionAxioms(e);
    }

    public static <P extends OWLPropertyExpression> Stream<P> getSubProperties(P e, OWLOntology ontology) {
        if (e.isObjectPropertyExpression()) {
            return Searcher.sub(ontology.axioms(Filters.subObjectPropertyWithSuper, e, Imports.EXCLUDED));
        }
        if (e.isDataPropertyExpression()) {
            return Searcher.sub(ontology.axioms(Filters.subDataPropertyWithSuper, e, Imports.EXCLUDED));
        }
        return Searcher.sub(ontology.axioms(Filters.subAnnotationWithSuper, e, Imports.EXCLUDED));
    }

    public static <P extends OWLPropertyExpression> Stream<P> getSubProperties(P e, Stream<OWLOntology> ontologies) {
        return ontologies.flatMap(o -> EntitySearcher.getSubProperties(e, o));
    }

    public static <P extends OWLPropertyExpression> Stream<P> getSuperProperties(P e, OWLOntology ontology) {
        if (e.isObjectPropertyExpression()) {
            return Searcher.sup(ontology.axioms(Filters.subObjectPropertyWithSub, e, Imports.EXCLUDED));
        }
        if (e.isDataPropertyExpression()) {
            return Searcher.sup(ontology.axioms(Filters.subDataPropertyWithSub, e, Imports.EXCLUDED));
        }
        return Searcher.sup(ontology.axioms(Filters.subAnnotationWithSub, e, Imports.EXCLUDED));
    }

    public static <P extends OWLPropertyExpression> Stream<P> getSuperProperties(P e, Stream<OWLOntology> ontologies) {
        return ontologies.flatMap(o -> EntitySearcher.getSuperProperties(e, o));
    }

    public static Stream<OWLClassExpression> getSuperClasses(OWLClass e, OWLOntology ontology) {
        return Searcher.sup(ontology.subClassAxiomsForSubClass(e));
    }

    public static Stream<OWLClassExpression> getSuperClasses(OWLClass e, Stream<OWLOntology> ontologies) {
        return ontologies.flatMap(o -> EntitySearcher.getSuperClasses(e, o));
    }

    public static Stream<OWLClassExpression> getSubClasses(OWLClass e, OWLOntology ontology) {
        return Searcher.sub(ontology.subClassAxiomsForSuperClass(e));
    }

    public static Stream<OWLClassExpression> getSubClasses(OWLClass e, Stream<OWLOntology> ontologies) {
        return ontologies.flatMap(o -> EntitySearcher.getSubClasses(e, o));
    }

    public static Stream<OWLClassExpression> getEquivalentClasses(OWLClass e, OWLOntology ontology) {
        return Searcher.equivalent(ontology.equivalentClassesAxioms(e)).filter(c -> !c.equals(e)).map(c -> (OWLClassExpression)c);
    }

    public static Stream<OWLClassExpression> getEquivalentClasses(OWLClass e, Stream<OWLOntology> ontologies) {
        return ontologies.flatMap(o -> EntitySearcher.getEquivalentClasses(e, o));
    }

    public static Stream<OWLClassExpression> getDisjointClasses(OWLClass e, OWLOntology ontology) {
        return Searcher.different(ontology.disjointClassesAxioms(e));
    }

    public static Stream<OWLClassExpression> getDisjointClasses(OWLClass e, Stream<OWLOntology> ontologies) {
        return ontologies.flatMap(o -> EntitySearcher.getDisjointClasses(e, o));
    }

    public static Stream<OWLIndividual> getDifferentIndividuals(OWLIndividual e, OWLOntology ontology) {
        return Searcher.different(ontology.differentIndividualAxioms(e));
    }

    public static Stream<OWLIndividual> getDifferentIndividuals(OWLIndividual e, Stream<OWLOntology> ontologies) {
        return ontologies.flatMap(o -> EntitySearcher.getDifferentIndividuals(e, o));
    }

    public static Stream<OWLIndividual> getSameIndividuals(OWLIndividual e, OWLOntology ontology) {
        return Searcher.equivalent(ontology.sameIndividualAxioms(e)).filter(c -> !c.equals(e)).map(c -> (OWLIndividual)c);
    }

    public static Stream<OWLIndividual> getSameIndividuals(OWLIndividual e, Stream<OWLOntology> ontologies) {
        return ontologies.flatMap(o -> EntitySearcher.getSameIndividuals(e, o));
    }

    public static Stream<OWLDataPropertyExpression> getEquivalentProperties(OWLDataProperty e, OWLOntology ontology) {
        return Searcher.equivalent(ontology.equivalentDataPropertiesAxioms(e)).filter(c -> !c.equals(e)).map(c -> (OWLDataProperty)c);
    }

    public static Stream<OWLDataPropertyExpression> getEquivalentProperties(OWLDataProperty e, Stream<OWLOntology> ontologies) {
        return ontologies.flatMap(o -> EntitySearcher.getEquivalentProperties(e, o));
    }

    public static <P extends OWLPropertyExpression> Stream<P> getDisjointProperties(P e, OWLOntology ontology) {
        if (e.isObjectPropertyExpression()) {
            return Searcher.different(ontology.disjointObjectPropertiesAxioms(e.asObjectPropertyExpression()));
        }
        if (e.isDataPropertyExpression()) {
            return Searcher.different(ontology.disjointDataPropertiesAxioms((OWLDataProperty)e));
        }
        return OWLAPIStreamUtils.empty();
    }

    public static <P extends OWLPropertyExpression> Stream<P> getDisjointProperties(P e, Stream<OWLOntology> ontologies) {
        return ontologies.flatMap(o -> EntitySearcher.getDisjointProperties(e, o));
    }

    public static Stream<OWLObjectPropertyExpression> getEquivalentProperties(OWLObjectPropertyExpression e, OWLOntology ontology) {
        return Searcher.equivalent(ontology.equivalentObjectPropertiesAxioms(e)).filter(c -> !c.equals(e)).map(c -> (OWLObjectPropertyExpression)c);
    }

    public static Stream<OWLObjectPropertyExpression> getEquivalentProperties(OWLObjectPropertyExpression e, Stream<OWLOntology> ontologies) {
        return ontologies.flatMap(o -> EntitySearcher.getEquivalentProperties(e, o));
    }

    public static Stream<OWLIndividual> getIndividuals(OWLClass e, OWLOntology ontology) {
        return Searcher.instances(ontology.classAssertionAxioms(e));
    }

    public static Stream<OWLIndividual> getIndividuals(OWLClass e, Stream<OWLOntology> ontologies) {
        return ontologies.flatMap(o -> EntitySearcher.getIndividuals(e, o));
    }

    public static Stream<OWLAxiom> getReferencingAxioms(OWLEntity e, OWLOntology ontology) {
        return ontology.referencingAxioms(e, Imports.EXCLUDED);
    }

    public static Stream<OWLAxiom> getReferencingAxioms(OWLEntity e, OWLOntology ontology, Imports includeImports) {
        return ontology.referencingAxioms(e, includeImports);
    }

    public static Stream<OWLClassExpression> getDomains(OWLDataProperty e, OWLOntology ontology) {
        return Searcher.domain(ontology.dataPropertyDomainAxioms(e));
    }

    public static Stream<OWLClassExpression> getDomains(OWLDataProperty e, Stream<OWLOntology> ontologies) {
        return ontologies.flatMap(o -> EntitySearcher.getDomains(e, o));
    }

    public static Stream<OWLClassExpression> getDomains(OWLObjectPropertyExpression e, OWLOntology ontology) {
        return Searcher.domain(ontology.objectPropertyDomainAxioms(e));
    }

    public static Stream<OWLDataRange> getRanges(OWLDataProperty e, OWLOntology ontology) {
        return Searcher.range(ontology.dataPropertyRangeAxioms(e));
    }

    public static Stream<OWLDataRange> getRanges(OWLDataProperty e, Stream<OWLOntology> ontologies) {
        return ontologies.flatMap(o -> EntitySearcher.getRanges(e, o));
    }

    public static Stream<OWLClassExpression> getDomains(OWLObjectPropertyExpression e, Stream<OWLOntology> ontologies) {
        return ontologies.flatMap(o -> EntitySearcher.getDomains(e, o));
    }

    public static Stream<OWLClassExpression> getRanges(OWLObjectPropertyExpression e, OWLOntology ontology) {
        return Searcher.range(ontology.objectPropertyRangeAxioms(e));
    }

    public static Stream<OWLClassExpression> getRanges(OWLObjectPropertyExpression e, Stream<OWLOntology> ontologies) {
        return ontologies.flatMap(o -> EntitySearcher.getRanges(e, o));
    }

    public static Stream<IRI> getDomains(OWLAnnotationProperty e, OWLOntology ontology) {
        return Searcher.domain(ontology.annotationPropertyDomainAxioms(e));
    }

    public static Stream<IRI> getDomains(OWLAnnotationProperty e, Stream<OWLOntology> ontologies) {
        return ontologies.flatMap(o -> EntitySearcher.getDomains(e, o));
    }

    public static Stream<IRI> getRanges(OWLAnnotationProperty e, OWLOntology ontology) {
        return Searcher.range(ontology.annotationPropertyRangeAxioms(e));
    }

    public static Stream<IRI> getRanges(OWLAnnotationProperty e, Stream<OWLOntology> ontologies) {
        return ontologies.flatMap(o -> EntitySearcher.getRanges(e, o));
    }

    public static boolean isTransitive(OWLObjectPropertyExpression e, OWLOntology o) {
        return o.transitiveObjectPropertyAxioms(e).findAny().isPresent();
    }

    public static boolean isTransitive(OWLObjectPropertyExpression e, Stream<OWLOntology> ontologies) {
        return ontologies.anyMatch(o -> EntitySearcher.isTransitive(e, o));
    }

    public static boolean isSymmetric(OWLObjectPropertyExpression e, OWLOntology o) {
        return o.symmetricObjectPropertyAxioms(e).findAny().isPresent();
    }

    public static boolean isSymmetric(OWLObjectPropertyExpression e, Stream<OWLOntology> ontologies) {
        return ontologies.anyMatch(o -> EntitySearcher.isSymmetric(e, o));
    }

    public static boolean isAsymmetric(OWLObjectPropertyExpression e, OWLOntology o) {
        return o.asymmetricObjectPropertyAxioms(e).findAny().isPresent();
    }

    public static boolean isAsymmetric(OWLObjectPropertyExpression e, Stream<OWLOntology> ontologies) {
        return ontologies.anyMatch(o -> EntitySearcher.isAsymmetric(e, o));
    }

    public static boolean isReflexive(OWLObjectPropertyExpression e, OWLOntology o) {
        return o.reflexiveObjectPropertyAxioms(e).findAny().isPresent();
    }

    public static boolean isReflexive(OWLObjectPropertyExpression e, Stream<OWLOntology> ontologies) {
        return ontologies.anyMatch(o -> EntitySearcher.isReflexive(e, o));
    }

    public static boolean isIrreflexive(OWLObjectPropertyExpression e, OWLOntology o) {
        return o.irreflexiveObjectPropertyAxioms(e).findAny().isPresent();
    }

    public static boolean isIrreflexive(OWLObjectPropertyExpression e, Stream<OWLOntology> ontologies) {
        return ontologies.anyMatch(o -> EntitySearcher.isIrreflexive(e, o));
    }

    public static boolean isInverseFunctional(OWLObjectPropertyExpression e, OWLOntology o) {
        return o.inverseFunctionalObjectPropertyAxioms(e).findAny().isPresent();
    }

    public static boolean isInverseFunctional(OWLObjectPropertyExpression e, Stream<OWLOntology> ontologies) {
        return ontologies.anyMatch(o -> EntitySearcher.isInverseFunctional(e, o));
    }

    public static boolean isFunctional(OWLObjectPropertyExpression e, OWLOntology o) {
        return o.functionalObjectPropertyAxioms(e).findAny().isPresent();
    }

    public static boolean isFunctional(OWLObjectPropertyExpression e, Stream<OWLOntology> ontologies) {
        return ontologies.anyMatch(o -> EntitySearcher.isFunctional(e, o));
    }

    public static boolean isFunctional(OWLDataProperty e, OWLOntology o) {
        return o.functionalDataPropertyAxioms(e).findAny().isPresent();
    }

    public static boolean isFunctional(OWLDataProperty e, Stream<OWLOntology> ontologies) {
        return ontologies.anyMatch(o -> EntitySearcher.isFunctional(e, o));
    }

    public static boolean isDefined(OWLClass c, OWLOntology o) {
        return o.equivalentClassesAxioms(c).findAny().isPresent();
    }

    public static boolean isDefined(OWLClass c, Stream<OWLOntology> ontologies) {
        return ontologies.anyMatch(o -> EntitySearcher.isDefined(c, o));
    }

    public static boolean containsAxiom(OWLAxiom a, OWLOntology o, Imports imports) {
        return o.containsAxiom(a, imports, AxiomAnnotations.CONSIDER_AXIOM_ANNOTATIONS);
    }

    public static boolean containsAxiom(OWLAxiom a, Stream<OWLOntology> ontologies, Imports imports) {
        return ontologies.anyMatch(o -> EntitySearcher.containsAxiom(a, o, imports));
    }

    public static boolean containsAxiomIgnoreAnnotations(OWLAxiom a, OWLOntology o, boolean imports) {
        return o.containsAxiom(a, Imports.fromBoolean(imports), AxiomAnnotations.IGNORE_AXIOM_ANNOTATIONS);
    }

    public static boolean containsAxiomIgnoreAnnotations(OWLAxiom a, Stream<OWLOntology> ontologies, boolean imports) {
        return ontologies.anyMatch(o -> EntitySearcher.containsAxiomIgnoreAnnotations(a, o, imports));
    }

    public static Collection<OWLAxiom> getAxiomsIgnoreAnnotations(OWLAxiom a, OWLOntology o, Imports imports) {
        return OWLAPIStreamUtils.asList(o.axiomsIgnoreAnnotations(a, imports));
    }

    public static Stream<OWLAxiom> axiomsIgnoreAnnotations(OWLAxiom a, OWLOntology o, Imports imports) {
        return o.axiomsIgnoreAnnotations(a, imports);
    }

    public static Stream<OWLLiteral> getDataPropertyValues(OWLIndividual i, OWLDataPropertyExpression p, OWLOntology ontology) {
        return Searcher.values(ontology.dataPropertyAssertionAxioms(i), p);
    }

    public static Stream<OWLLiteral> getDataPropertyValues(OWLIndividual i, OWLDataPropertyExpression p, Stream<OWLOntology> ontologies) {
        return ontologies.flatMap(o -> EntitySearcher.getDataPropertyValues(i, p, o));
    }

    public static Stream<OWLIndividual> getObjectPropertyValues(OWLIndividual i, OWLObjectPropertyExpression p, OWLOntology ontology) {
        return Searcher.values(ontology.objectPropertyAssertionAxioms(i), p);
    }

    public static Stream<OWLIndividual> getObjectPropertyValues(OWLIndividual i, OWLObjectPropertyExpression p, Stream<OWLOntology> ontologies) {
        return ontologies.flatMap(o -> EntitySearcher.getObjectPropertyValues(i, p, o));
    }

    public static Stream<OWLLiteral> getNegativeDataPropertyValues(OWLIndividual i, OWLDataPropertyExpression p, OWLOntology ontology) {
        return Searcher.negValues(ontology.negativeDataPropertyAssertionAxioms(i), p);
    }

    public static Stream<OWLLiteral> getNegativeDataPropertyValues(OWLIndividual i, OWLDataPropertyExpression p, Stream<OWLOntology> ontologies) {
        return ontologies.flatMap(o -> EntitySearcher.getNegativeDataPropertyValues(i, p, o));
    }

    public static Stream<OWLIndividual> getNegativeObjectPropertyValues(OWLIndividual i, OWLObjectPropertyExpression p, OWLOntology ontology) {
        return Searcher.negValues(ontology.negativeObjectPropertyAssertionAxioms(i), p);
    }

    public static Stream<OWLIndividual> getNegativeObjectPropertyValues(OWLIndividual i, OWLObjectPropertyExpression p, Stream<OWLOntology> ontologies) {
        return ontologies.flatMap(o -> EntitySearcher.getNegativeObjectPropertyValues(i, p, o));
    }

    public static boolean hasDataPropertyValues(OWLIndividual i, OWLDataPropertyExpression p, OWLOntology ontology) {
        return Searcher.values(ontology.dataPropertyAssertionAxioms(i), p).findAny().isPresent();
    }

    public static boolean hasDataPropertyValues(OWLIndividual i, OWLDataPropertyExpression p, Stream<OWLOntology> ontologies) {
        return ontologies.anyMatch(o -> EntitySearcher.hasDataPropertyValues(i, p, o));
    }

    public static boolean hasObjectPropertyValues(OWLIndividual i, OWLObjectPropertyExpression p, OWLOntology ontology) {
        return Searcher.values(ontology.objectPropertyAssertionAxioms(i), p).findAny().isPresent();
    }

    public static boolean hasObjectPropertyValues(OWLIndividual i, OWLObjectPropertyExpression p, Stream<OWLOntology> ontologies) {
        return ontologies.anyMatch(o -> EntitySearcher.hasObjectPropertyValues(i, p, o));
    }

    public static boolean hasNegativeDataPropertyValues(OWLIndividual i, OWLDataPropertyExpression p, OWLOntology ontology) {
        return Searcher.negValues(ontology.negativeDataPropertyAssertionAxioms(i), p).findAny().isPresent();
    }

    public static boolean hasNegativeDataPropertyValues(OWLIndividual i, OWLDataPropertyExpression p, Stream<OWLOntology> ontologies) {
        return ontologies.anyMatch(o -> EntitySearcher.hasNegativeDataPropertyValues(i, p, o));
    }

    public static boolean hasNegativeObjectPropertyValues(OWLIndividual i, OWLObjectPropertyExpression p, OWLOntology ontology) {
        return Searcher.negValues(ontology.negativeObjectPropertyAssertionAxioms(i), p).findAny().isPresent();
    }

    public static boolean hasNegativeObjectPropertyValues(OWLIndividual i, OWLObjectPropertyExpression p, Stream<OWLOntology> ontologies) {
        return ontologies.anyMatch(o -> EntitySearcher.hasNegativeObjectPropertyValues(i, p, o));
    }

    public static boolean hasDataPropertyValue(OWLIndividual i, OWLDataPropertyExpression p, OWLLiteral lit, OWLOntology ontology) {
        return OWLAPIStreamUtils.contains(Searcher.values(ontology.dataPropertyAssertionAxioms(i), p), lit);
    }

    public static boolean hasDataPropertyValue(OWLIndividual i, OWLDataPropertyExpression p, OWLLiteral lit, Stream<OWLOntology> ontologies) {
        return ontologies.anyMatch(o -> EntitySearcher.hasDataPropertyValue(i, p, lit, o));
    }

    public static boolean hasObjectPropertyValue(OWLIndividual i, OWLObjectPropertyExpression p, OWLIndividual j, OWLOntology ontology) {
        return OWLAPIStreamUtils.contains(Searcher.values(ontology.objectPropertyAssertionAxioms(i), p), j);
    }

    public static boolean hasObjectPropertyValue(OWLIndividual i, OWLObjectPropertyExpression p, OWLIndividual j, Stream<OWLOntology> ontologies) {
        return ontologies.anyMatch(o -> EntitySearcher.hasObjectPropertyValue(i, p, j, o));
    }

    public static boolean hasNegativeDataPropertyValue(OWLIndividual i, OWLDataPropertyExpression p, OWLLiteral lit, OWLOntology ontology) {
        return OWLAPIStreamUtils.contains(Searcher.negValues(ontology.negativeDataPropertyAssertionAxioms(i), p), lit);
    }

    public static boolean hasNegativeDataPropertyValue(OWLIndividual i, OWLDataPropertyExpression p, OWLLiteral lit, Stream<OWLOntology> ontologies) {
        return ontologies.anyMatch(o -> EntitySearcher.hasNegativeDataPropertyValue(i, p, lit, o));
    }

    public static boolean hasNegativeObjectPropertyValue(OWLIndividual i, OWLObjectPropertyExpression p, OWLIndividual j, OWLOntology ontology) {
        return OWLAPIStreamUtils.contains(Searcher.negValues(ontology.negativeObjectPropertyAssertionAxioms(i), p), j);
    }

    public static boolean hasNegativeObjectPropertyValue(OWLIndividual i, OWLObjectPropertyExpression p, OWLIndividual j, Stream<OWLOntology> ontologies) {
        return ontologies.anyMatch(o -> EntitySearcher.hasNegativeObjectPropertyValue(i, p, j, o));
    }

    public static Multimap<OWLDataPropertyExpression, OWLLiteral> getDataPropertyValues(OWLIndividual i, OWLOntology ontology) {
        LinkedListMultimap map = LinkedListMultimap.create();
        ontology.dataPropertyAssertionAxioms(i).forEach(arg_0 -> EntitySearcher.lambda$getDataPropertyValues$53((Multimap)map, arg_0));
        return map;
    }

    public static Multimap<OWLDataPropertyExpression, OWLLiteral> getDataPropertyValues(OWLIndividual i, Stream<OWLOntology> ontologies) {
        LinkedListMultimap map = LinkedListMultimap.create();
        ontologies.forEach(arg_0 -> EntitySearcher.lambda$getDataPropertyValues$54((Multimap)map, i, arg_0));
        return map;
    }

    public static Multimap<OWLObjectPropertyExpression, OWLIndividual> getObjectPropertyValues(OWLIndividual i, OWLOntology ontology) {
        LinkedListMultimap map = LinkedListMultimap.create();
        ontology.objectPropertyAssertionAxioms(i).forEach(arg_0 -> EntitySearcher.lambda$getObjectPropertyValues$55((Multimap)map, arg_0));
        return map;
    }

    public static Multimap<OWLObjectPropertyExpression, OWLIndividual> getObjectPropertyValues(OWLIndividual i, Stream<OWLOntology> ontologies) {
        LinkedListMultimap map = LinkedListMultimap.create();
        ontologies.forEach(arg_0 -> EntitySearcher.lambda$getObjectPropertyValues$56((Multimap)map, i, arg_0));
        return map;
    }

    public static Multimap<OWLObjectPropertyExpression, OWLIndividual> getNegativeObjectPropertyValues(OWLIndividual i, OWLOntology ontology) {
        LinkedListMultimap map = LinkedListMultimap.create();
        ontology.negativeObjectPropertyAssertionAxioms(i).forEach(arg_0 -> EntitySearcher.lambda$getNegativeObjectPropertyValues$57((Multimap)map, arg_0));
        return map;
    }

    public static Multimap<OWLDataPropertyExpression, OWLLiteral> getNegativeDataPropertyValues(OWLIndividual i, OWLOntology ontology) {
        LinkedListMultimap map = LinkedListMultimap.create();
        ontology.negativeDataPropertyAssertionAxioms(i).forEach(arg_0 -> EntitySearcher.lambda$getNegativeDataPropertyValues$58((Multimap)map, arg_0));
        return map;
    }

    public static Multimap<OWLObjectPropertyExpression, OWLIndividual> getNegativeObjectPropertyValues(OWLIndividual i, Stream<OWLOntology> ontologies) {
        LinkedListMultimap map = LinkedListMultimap.create();
        ontologies.forEach(arg_0 -> EntitySearcher.lambda$getNegativeObjectPropertyValues$59((Multimap)map, i, arg_0));
        return map;
    }

    public static Multimap<OWLDataPropertyExpression, OWLLiteral> getNegativeDataPropertyValues(OWLIndividual i, Stream<OWLOntology> ontologies) {
        LinkedListMultimap map = LinkedListMultimap.create();
        ontologies.forEach(arg_0 -> EntitySearcher.lambda$getNegativeDataPropertyValues$60((Multimap)map, i, arg_0));
        return map;
    }

    public static Stream<OWLObjectPropertyExpression> getInverses(OWLObjectPropertyExpression e, OWLOntology ontology) {
        return Searcher.inverse(ontology.inverseObjectPropertyAxioms(e), e);
    }

    public static Stream<OWLObjectPropertyExpression> getInverses(OWLObjectPropertyExpression e, Stream<OWLOntology> ontologies) {
        return ontologies.flatMap(o -> EntitySearcher.getInverses(e, o));
    }

    public static Stream<OWLIndividual> getInstances(OWLClassExpression e, OWLOntology ontology) {
        return Searcher.instances(ontology.classAssertionAxioms(e));
    }

    public static Stream<OWLIndividual> getInstances(OWLClassExpression e, Stream<OWLOntology> ontologies) {
        return ontologies.flatMap(o -> EntitySearcher.getInstances(e, o));
    }

    public static Stream<OWLClassExpression> getTypes(OWLIndividual e, OWLOntology ontology) {
        return Searcher.types(ontology.classAssertionAxioms(e));
    }

    public static Stream<OWLClassExpression> getTypes(OWLIndividual e, Stream<OWLOntology> ontologies) {
        return ontologies.flatMap(o -> EntitySearcher.getTypes(e, o));
    }

    private static /* synthetic */ void lambda$getNegativeDataPropertyValues$60(Multimap map, OWLIndividual i, OWLOntology o) {
        map.putAll(EntitySearcher.getNegativeDataPropertyValues(i, o));
    }

    private static /* synthetic */ void lambda$getNegativeObjectPropertyValues$59(Multimap map, OWLIndividual i, OWLOntology o) {
        map.putAll(EntitySearcher.getNegativeObjectPropertyValues(i, o));
    }

    private static /* synthetic */ void lambda$getNegativeDataPropertyValues$58(Multimap map, OWLNegativeDataPropertyAssertionAxiom ax) {
        map.put((Object)ax.getProperty(), ax.getObject());
    }

    private static /* synthetic */ void lambda$getNegativeObjectPropertyValues$57(Multimap map, OWLNegativeObjectPropertyAssertionAxiom ax) {
        map.put((Object)ax.getProperty(), ax.getObject());
    }

    private static /* synthetic */ void lambda$getObjectPropertyValues$56(Multimap map, OWLIndividual i, OWLOntology o) {
        map.putAll(EntitySearcher.getObjectPropertyValues(i, o));
    }

    private static /* synthetic */ void lambda$getObjectPropertyValues$55(Multimap map, OWLObjectPropertyAssertionAxiom ax) {
        map.put((Object)ax.getProperty(), ax.getObject());
    }

    private static /* synthetic */ void lambda$getDataPropertyValues$54(Multimap map, OWLIndividual i, OWLOntology o) {
        map.putAll(EntitySearcher.getDataPropertyValues(i, o));
    }

    private static /* synthetic */ void lambda$getDataPropertyValues$53(Multimap map, OWLDataPropertyAssertionAxiom ax) {
        map.put((Object)ax.getProperty(), ax.getObject());
    }
}

