/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.arq.querybuilder.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.jena.arq.querybuilder.handlers.Handler;
import org.apache.jena.arq.querybuilder.rewriters.AbstractRewriter;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.syntax.Template;

public class ConstructHandler
implements Handler {
    private final Query query;
    private List<Triple> constructs;

    public ConstructHandler(Query query) {
        this.query = query;
        this.constructs = new ArrayList<Triple>();
        if (query.getConstructTemplate() != null) {
            for (Triple t : query.getConstructTemplate().getTriples()) {
                this.constructs.add(t);
            }
        }
    }

    public void addConstruct(Triple t) {
        this.constructs.add(t);
        this.query.setConstructTemplate(new Template(BasicPattern.wrap(this.constructs)));
    }

    public void addAll(ConstructHandler handler) {
        this.constructs.addAll(handler.constructs);
        this.query.setConstructTemplate(new Template(BasicPattern.wrap(this.constructs)));
    }

    @Override
    public void setVars(Map<Var, Node> values) {
        if (values.isEmpty()) {
            return;
        }
        AbstractRewriter<Node> rw = new AbstractRewriter<Node>(values){};
        this.query.setConstructTemplate(new Template(BasicPattern.wrap(rw.rewrite(this.constructs))));
    }

    @Override
    public void build() {
    }
}

