/*
 * Decompiled with CFR 0.152.
 */
package org.cts.op.projection;

import java.util.HashMap;
import java.util.Map;
import org.cts.CoordinateDimensionException;
import org.cts.Identifier;
import org.cts.datum.Ellipsoid;
import org.cts.op.NonInvertibleOperationException;
import org.cts.op.projection.Projection;
import org.cts.units.Measure;
import org.cts.units.Unit;
import org.cts.util.Complex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniversalTransverseMercator
extends Projection {
    public static final Identifier UTM = new Identifier("EPSG", "9824", "Transverse Mercator Zoned Grid System", "UTM");
    public static final String NORTH = "NORTH";
    public static final String SOUTH = "SOUTH";
    protected final double FE;
    protected final double lon0;
    protected final double n;
    protected final double xs;
    protected final double ys;
    protected final double[] dircoeff;
    protected final double[] invcoeff;

    public UniversalTransverseMercator(Ellipsoid ellipsoid, Map<String, Measure> parameters) {
        super(UTM, ellipsoid, parameters);
        this.FE = 500000.0;
        double y0 = this.getFalseNorthing();
        double k0 = 0.9996;
        this.lon0 = this.getCentralMeridian();
        double lat0 = 0.0;
        this.n = k0 * ellipsoid.getSemiMajorAxis();
        this.xs = this.FE;
        this.ys = y0 - this.n * ellipsoid.curvilinearAbscissa(lat0);
        this.dircoeff = UniversalTransverseMercator.getDirectUTMCoeff(ellipsoid);
        this.invcoeff = UniversalTransverseMercator.getInverseUTMCoeff(ellipsoid);
    }

    public static UniversalTransverseMercator createUTM(Ellipsoid ellipsoid, int zone, String hemisphere) {
        HashMap<String, Measure> parameters = new HashMap<String, Measure>();
        parameters.put("central meridian", new Measure(6.0 * ((double)zone - 31.0) + 3.0, Unit.DEGREE));
        if (hemisphere.equalsIgnoreCase(SOUTH)) {
            parameters.put("false northing", new Measure(1.0E7, Unit.METER));
        } else {
            parameters.put("false northing", new Measure(0.0, Unit.METER));
        }
        return new UniversalTransverseMercator(ellipsoid, parameters);
    }

    public static double[] getDirectUTMCoeff(Ellipsoid ellps) {
        double e2 = ellps.getSquareEccentricity();
        double e4 = e2 * e2;
        double e6 = e4 * e2;
        double e8 = e4 * e4;
        double[] dir_utm_coeff = new double[]{1.0 - e2 * 1.0 / 4.0 - e4 * 3.0 / 64.0 - e6 * 5.0 / 256.0 - e8 * 175.0 / 16384.0, e2 * 1.0 / 8.0 - e4 * 1.0 / 96.0 - e6 * 9.0 / 1024.0 - e8 * 901.0 / 184320.0, e4 * 13.0 / 768.0 + e6 * 17.0 / 5120.0 - e8 * 311.0 / 737280.0, e6 * 61.0 / 15360.0 + e8 * 899.0 / 430080.0, e8 * 49561.0 / 4.128768E7};
        return dir_utm_coeff;
    }

    public static double[] getInverseUTMCoeff(Ellipsoid ellps) {
        double e2 = ellps.getSquareEccentricity();
        double e4 = e2 * e2;
        double e6 = e4 * e2;
        double e8 = e4 * e4;
        double[] inv_utm_coeff = new double[]{1.0 - e2 * 1.0 / 4.0 - e4 * 3.0 / 64.0 - e6 * 5.0 / 256.0 - e8 * 175.0 / 16384.0, e2 * 1.0 / 8.0 + e4 * 1.0 / 48.0 + e6 * 7.0 / 2048.0 + e8 * 1.0 / 61440.0, e4 * 1.0 / 768.0 + e6 * 3.0 / 1280.0 + e8 * 559.0 / 368640.0, e6 * 17.0 / 30720.0 + e8 * 283.0 / 430080.0, e8 * 4397.0 / 4.128768E7};
        return inv_utm_coeff;
    }

    @Override
    public double[] transform(double[] coord) throws CoordinateDimensionException {
        double latIsoPhi = this.ellipsoid.isometricLatitude(coord[0]);
        double PHI = Math.asin(Math.sin(coord[1] - this.lon0) / Math.cosh(latIsoPhi));
        double latIsoPHI = Ellipsoid.SPHERE.isometricLatitude(PHI);
        double lambda = Math.atan(Math.sinh(latIsoPhi) / Math.cos(coord[1] - this.lon0));
        Complex z = new Complex(lambda, latIsoPHI);
        Complex Z = z.times(this.n * this.dircoeff[0]);
        for (int i = 1; i < 5; ++i) {
            Z = Z.plus(Complex.sin(z.times(2.0 * (double)i)).times(this.n * this.dircoeff[i]));
        }
        coord[0] = this.xs + Z.im();
        coord[1] = this.ys + Z.re();
        return coord;
    }

    @Override
    public Projection inverse() throws NonInvertibleOperationException {
        return new UniversalTransverseMercator(this.ellipsoid, this.parameters){

            public double[] transform(double[] coord) throws CoordinateDimensionException {
                double lat;
                Complex z;
                Complex Z = z = new Complex((coord[1] - this.ys) / (this.n * this.invcoeff[0]), (coord[0] - this.xs) / (this.n * this.invcoeff[0]));
                for (int i = 1; i < 5; ++i) {
                    Z = Z.plus(Complex.sin(z.times(2.0 * (double)i)).times(-this.invcoeff[i]));
                }
                double lon = this.lon0 + Math.atan(Math.sinh(Z.im()) / Math.cos(Z.re()));
                double PHI = Math.asin(Math.sin(Z.re()) / Math.cosh(Z.im()));
                double latIso = Ellipsoid.SPHERE.isometricLatitude(PHI);
                coord[0] = lat = this.ellipsoid.latitude(latIso);
                coord[1] = lon;
                return coord;
            }

            public Projection inverse() throws NonInvertibleOperationException {
                return UniversalTransverseMercator.this;
            }

            public boolean isDirect() {
                return false;
            }

            public String toString() {
                return UniversalTransverseMercator.this.toString() + " inverse";
            }
        };
    }

    @Override
    public Projection.Surface getSurface() {
        return Projection.Surface.CYLINDRICAL;
    }

    @Override
    public Projection.Property getProperty() {
        return Projection.Property.CONFORMAL;
    }

    @Override
    public Projection.Orientation getOrientation() {
        return Projection.Orientation.TRANSVERSE;
    }
}

