/*
 * Decompiled with CFR 0.152.
 */
package org.cts.cs;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

public class Axis {
    private static Map<Direction, Map<String, Axis>> axisFromDirAndName = new EnumMap<Direction, Map<String, Axis>>(Direction.class);
    public static final Axis EASTING = new Axis("Easting", Direction.EAST);
    public static final Axis NORTHING = new Axis("Northing", Direction.NORTH);
    public static final Axis WESTING = new Axis("Westing", Direction.WEST);
    public static final Axis SOUTHING = new Axis("Southing", Direction.SOUTH);
    public static final Axis x = new Axis("X", Direction.EAST);
    public static final Axis y = new Axis("Y", Direction.NORTH);
    public static final Axis ALTITUDE = new Axis("Altitude", Direction.UP);
    public static final Axis DEPTH = new Axis("Depth", Direction.DOWN);
    public static final Axis LATITUDE = new Axis("Latitude", Direction.NORTH);
    public static final Axis LONGITUDE = new Axis("Longitude", Direction.EAST);
    public static final Axis HEIGHT = new Axis("Height", Direction.UP);
    public static final Axis X = new Axis("X", Direction.OTHER);
    public static final Axis Y = new Axis("Y", Direction.EAST);
    public static final Axis Z = new Axis("Z", Direction.NORTH);
    public static final Axis TIME = new Axis("Time", Direction.OTHER);
    private String name;
    private Direction direction;

    private void registerAxis() {
        Map<String, Axis> map = axisFromDirAndName.get((Object)this.getDirection());
        if (map == null) {
            axisFromDirAndName.put(this.getDirection(), new HashMap());
        }
        axisFromDirAndName.get((Object)this.getDirection()).put(this.getName().toLowerCase(), this);
    }

    public static Axis getAxis(Direction dir, String name) {
        Map<String, Axis> map = axisFromDirAndName.get((Object)dir);
        if (map == null) {
            return null;
        }
        return map.get(name);
    }

    public Axis(String name, Direction dir) {
        this.name = name;
        this.direction = dir;
        this.registerAxis();
    }

    public String getName() {
        return this.name;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public static Direction getDirection(String dir) {
        Direction direction = null;
        if (dir != null) {
            direction = dir.equals("EAST") ? Direction.EAST : (dir.equals("NORTH") ? Direction.NORTH : (dir.equals("WEST") ? Direction.WEST : (dir.equals("SOUTH") ? Direction.SOUTH : (dir.equals("UP") ? Direction.UP : (dir.equals("DOWN") ? Direction.DOWN : Direction.OTHER)))));
        }
        return direction;
    }

    public String toWKT() {
        StringBuilder w = new StringBuilder();
        w.append("AXIS[\"");
        w.append(this.getName());
        w.append("\",");
        w.append((Object)this.getDirection());
        w.append(']');
        return w.toString();
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Axis axis = (Axis)o;
        return this.direction == axis.direction;
    }

    public int hashCode() {
        return this.direction.hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        EAST,
        WEST,
        NORTH,
        SOUTH,
        UP,
        DOWN,
        OTHER;

    }
}

