/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.search;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.CharBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;

public class TermCompletionAnalyzer
extends Analyzer {
    private final Pattern wordBoundary;
    private final Pattern subWordBoundary;
    private final Pattern discard;
    private final boolean alwaysDiscard;

    public TermCompletionAnalyzer(Pattern wordBoundary, Pattern subWordBoundary, Pattern softHyphens, boolean alwaysRemoveSoftHypens) {
        this.wordBoundary = wordBoundary;
        this.subWordBoundary = subWordBoundary;
        if (softHyphens != null) {
            this.discard = softHyphens;
            this.alwaysDiscard = alwaysRemoveSoftHypens;
        } else {
            this.discard = Pattern.compile("(?!)");
            this.alwaysDiscard = true;
        }
    }

    public TermCompletionAnalyzer(Pattern wordBoundary, Pattern subWordBoundary) {
        this(wordBoundary, subWordBoundary, null, true);
    }

    public TokenStream tokenStream(String ignoredFieldName, Reader reader) {
        return new TermCompletionTokenStream((StringReader)reader);
    }

    static String getStringReaderContents(StringReader reader) {
        try {
            reader.mark(Integer.MAX_VALUE);
            int length = (int)reader.skip(Integer.MAX_VALUE);
            reader.reset();
            char[] fileContent = new char[length];
            reader.read(fileContent);
            reader.reset();
            return new String(fileContent);
        }
        catch (IOException e) {
            throw new RuntimeException("Impossible", e);
        }
    }

    private class TermCompletionTokenStream
    extends TokenStream {
        final String[] words;
        final TermAttribute termAtt;
        char[] currentWord = new char[0];
        Matcher softMatcher;
        int currentWordIx = -1;
        int charPos = 0;
        private String afterDiscard;
        private CharBuffer found;

        public TermCompletionTokenStream(StringReader reader) {
            this.termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
            this.words = TermCompletionAnalyzer.this.wordBoundary.split(TermCompletionAnalyzer.getStringReaderContents(reader));
        }

        public boolean incrementToken() throws IOException {
            if (this.next()) {
                if (this.afterDiscard != null) {
                    int lg = this.afterDiscard.length();
                    this.afterDiscard.getChars(0, lg, this.termAtt.termBuffer(), 0);
                    this.termAtt.setTermLength(lg);
                } else {
                    int lg = this.found.length();
                    this.found.get(this.termAtt.termBuffer(), 0, lg);
                    this.termAtt.setTermLength(lg);
                }
                return true;
            }
            return false;
        }

        private boolean next() {
            if (this.currentWordIx >= this.words.length) {
                return false;
            }
            if (!TermCompletionAnalyzer.this.alwaysDiscard && this.afterDiscard != null) {
                this.afterDiscard = null;
                return true;
            }
            this.afterDiscard = null;
            if (this.charPos + 1 < this.currentWord.length && this.softMatcher.find(this.charPos + 1)) {
                this.charPos = this.softMatcher.end();
                this.maybeDiscardHyphens();
                return true;
            }
            return this.nextWord();
        }

        void maybeDiscardHyphens() {
            this.found = CharBuffer.wrap(this.currentWord, this.charPos, this.currentWord.length - this.charPos);
            Matcher discarding = TermCompletionAnalyzer.this.discard.matcher(this.found);
            if (discarding.find()) {
                this.afterDiscard = discarding.replaceAll("");
            }
        }

        private boolean nextWord() {
            ++this.currentWordIx;
            if (this.currentWordIx >= this.words.length) {
                return false;
            }
            this.currentWord = this.words[this.currentWordIx].toCharArray();
            this.termAtt.resizeTermBuffer(this.currentWord.length);
            this.charPos = 0;
            this.softMatcher = TermCompletionAnalyzer.this.subWordBoundary.matcher(this.words[this.currentWordIx]);
            this.maybeDiscardHyphens();
            return true;
        }
    }
}

