/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.NV;
import com.bigdata.rdf.sparql.ast.GroupMemberNodeBase;
import com.bigdata.rdf.sparql.ast.PathNode;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.TermNode;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openrdf.query.algebra.StatementPattern;

public class PropertyPathNode
extends GroupMemberNodeBase<PropertyPathNode> {
    private static final long serialVersionUID = -1697848422480337886L;

    public PropertyPathNode(PropertyPathNode op) {
        super(op);
    }

    public PropertyPathNode(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
    }

    public PropertyPathNode(TermNode s, PathNode p, TermNode o) {
        this(s, p, o, null, StatementPattern.Scope.DEFAULT_CONTEXTS);
    }

    public PropertyPathNode(TermNode s, PathNode p, TermNode o, TermNode c, StatementPattern.Scope scope) {
        super(new BOp[]{s, p, o, c}, scope == null ? null : NV.asMap(new NV("scope", scope)));
        if (scope == null) {
            throw new IllegalArgumentException();
        }
        if (s == null || p == null || o == null) {
            throw new IllegalArgumentException();
        }
        if (scope == StatementPattern.Scope.NAMED_CONTEXTS && c == null) {
            throw new IllegalArgumentException();
        }
    }

    public final TermNode s() {
        return (TermNode)this.get(0);
    }

    public final PathNode p() {
        return (PathNode)this.get(1);
    }

    public final TermNode o() {
        return (TermNode)this.get(2);
    }

    public final TermNode c() {
        return (TermNode)this.get(3);
    }

    public final void setC(TermNode c) {
        this.setArg(3, c);
    }

    public final StatementPattern.Scope getScope() {
        return (StatementPattern.Scope)this.getRequiredProperty("scope");
    }

    public final void setScope(StatementPattern.Scope scope) {
        if (scope == null) {
            throw new IllegalArgumentException();
        }
        this.setProperty("scope", scope);
    }

    @Override
    public String toString(int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n").append(PropertyPathNode.indent(indent)).append(this.toShortString());
        if (this.getQueryHints() != null && !this.getQueryHints().isEmpty()) {
            sb.append("\n");
            sb.append(PropertyPathNode.indent(indent + 1));
            sb.append("queryHints");
            sb.append("=");
            sb.append(this.getQueryHints().toString());
        }
        return sb.toString();
    }

    @Override
    public String toShortString() {
        StringBuilder sb = new StringBuilder();
        Integer id = (Integer)this.getProperty(BOp.Annotations.BOP_ID);
        sb.append("StatementPatternNode");
        if (id != null) {
            sb.append("[").append(id.toString()).append("]");
        }
        sb.append("(");
        sb.append(this.s()).append(", ");
        sb.append(this.p()).append(", ");
        sb.append(this.o());
        TermNode c = this.c();
        if (c != null) {
            sb.append(", ").append(c);
        }
        sb.append(")");
        StatementPattern.Scope scope = this.getScope();
        if (scope != null) {
            sb.append(" [scope=" + scope + "]");
        }
        return sb.toString();
    }

    @Override
    public Set<IVariable<?>> getRequiredBound(StaticAnalysis sa) {
        return new HashSet();
    }

    @Override
    public Set<IVariable<?>> getDesiredBound(StaticAnalysis sa) {
        return sa.getSpannedVariables(this, true, new HashSet());
    }

    public static interface Annotations
    extends GroupMemberNodeBase.Annotations {
        public static final String SCOPE = "scope";
    }
}

