/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast;

import com.bigdata.bop.BOp;
import com.bigdata.rdf.sparql.ast.AbstractStatementContainer;
import com.bigdata.rdf.sparql.ast.GroupNodeBase;
import com.bigdata.rdf.sparql.ast.IGroupNode;
import com.bigdata.rdf.sparql.ast.IStatementContainer;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import java.util.Map;

public class ConstructNode
extends AbstractStatementContainer<StatementPatternNode>
implements IStatementContainer {
    private static final long serialVersionUID = 1L;

    public ConstructNode() {
    }

    public ConstructNode(AST2BOpContext ctx) {
        if (ctx.nativeDistinctSPO) {
            this.setNativeDistinct(true);
        }
    }

    public ConstructNode(ConstructNode op) {
        super(op);
    }

    public ConstructNode(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
    }

    @Override
    public IGroupNode<StatementPatternNode> addChild(StatementPatternNode child) {
        if (!(child instanceof StatementPatternNode)) {
            throw new UnsupportedOperationException();
        }
        super.addChild(child);
        return this;
    }

    public boolean isNativeDistinct() {
        return this.getProperty("nativeDistinct", false);
    }

    public void setNativeDistinct(boolean nativeDistinct) {
        this.setProperty("nativeDistinct", nativeDistinct);
    }

    public boolean isDistinctQuads() {
        return this.getProperty("quadsDistinct", false);
    }

    public void setDistinctQuads(boolean quads) {
        this.setProperty("quadsDistinct", quads);
    }

    @Override
    public String toString(int indent) {
        StringBuilder sb = new StringBuilder();
        String s = ConstructNode.indent(indent);
        sb.append("\n").append(s).append("CONSTRUCT {");
        for (StatementPatternNode v : this) {
            sb.append(v.toString(indent + 1));
        }
        sb.append("\n").append(s).append("}");
        if (this.isNativeDistinct()) {
            sb.append(" [nativeDistinct]");
        }
        return sb.toString();
    }

    public static interface Annotations
    extends GroupNodeBase.Annotations {
        public static final String NATIVE_DISTINCT = "nativeDistinct";
        public static final String DISTINCT_QUADS = "quadsDistinct";
        public static final boolean DEFAULT_NATIVE_DISTINCT = false;
        public static final boolean DEFAULT_DISTINCT_QUADS = false;
    }
}

