/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal;

import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.io.compression.IUnicodeCompressor;
import com.bigdata.io.compression.NoCompressor;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Comparator;

public class IVUnicode {
    private static IUnicodeCompressor uc = new NoCompressor();

    public static byte[] encode1(String s) {
        int slen = s.length();
        if (slen > Short.MAX_VALUE) {
            throw new UnsupportedOperationException();
        }
        int capacity = 2 + (slen << 1);
        KeyBuilder k = new KeyBuilder(capacity);
        k.append((short)slen);
        for (int i = 0; i < slen; ++i) {
            char ch = s.charAt(i);
            short sh = (short)ch;
            k.append(sh);
        }
        assert (k.array().length == capacity);
        return k.array();
    }

    static int decode(InputStream in, StringBuilder out) throws IOException {
        DataInputStream dis = new DataInputStream(in);
        int slen = IVUnicode.decodeShort(dis.readShort());
        assert (slen <= Short.MAX_VALUE) : slen;
        assert (slen >= 0) : slen;
        out.ensureCapacity(slen);
        for (int i = 0; i < slen; ++i) {
            short unsignedShort = IVUnicode.decodeShort(dis.readShort());
            char ch = (char)unsignedShort;
            out.append(ch);
        }
        return 2 + (slen << 1);
    }

    private static short decodeShort(short signedShort) {
        int v = signedShort;
        v = v < 0 ? (v += 32768) : (v -= 32768);
        short slen = (short)v;
        return slen;
    }

    public static int byteLengthUnicode(String s) {
        return 4 + s.length();
    }

    public static class IVUnicodeComparator
    implements Comparator<String> {
        public static final IVUnicodeComparator INSTANCE = new IVUnicodeComparator();

        private IVUnicodeComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            int ret;
            int len2;
            int len1 = o1.length();
            int n = len1 < (len2 = o2.length()) ? -1 : (ret = len1 > len2 ? 1 : 0);
            if (ret == 0) {
                ret = o1.compareTo(o2);
            }
            return ret;
        }
    }
}

