/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.htree;

import com.bigdata.btree.PO;
import com.bigdata.btree.data.IAbstractNodeData;
import com.bigdata.htree.AbstractHTree;
import com.bigdata.htree.BucketPage;
import com.bigdata.htree.DirectoryPage;
import com.bigdata.htree.HTree;
import com.bigdata.htree.HTreePageStats;
import com.bigdata.util.BytesUtil;
import java.io.PrintStream;
import java.lang.ref.Reference;
import java.util.Iterator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

abstract class AbstractPage
extends PO
implements IAbstractNodeData {
    protected static final Logger log = Logger.getLogger(AbstractPage.class);
    protected static final boolean INFO = log.isInfoEnabled();
    protected static final boolean DEBUG = log.isDebugEnabled();
    protected static final boolean TRACE = log.isTraceEnabled();
    protected final transient AbstractHTree htree;
    protected transient Reference<DirectoryPage> parent = null;
    protected final transient Reference<? extends AbstractPage> self;
    protected transient int referenceCount = 0;
    protected int globalDepth;

    @Override
    public String toShortString() {
        return super.toShortString() + "{d=" + this.globalDepth + "}";
    }

    public int getGlobalDepth() {
        return this.globalDepth;
    }

    public int getNumBuddies() {
        int nbuddies = (1 << this.htree.addressBits) / (1 << this.globalDepth);
        return nbuddies;
    }

    public int getSlotsPerBuddy() {
        int slotsPerBuddy = 1 << this.globalDepth;
        return slotsPerBuddy;
    }

    public final int getPrefixLength() {
        DirectoryPage dp;
        int ret = 0;
        DirectoryPage directoryPage = dp = this.parent != null ? this.parent.get() : null;
        while (dp != null) {
            ret += dp.globalDepth;
            dp = dp.parent != null ? (DirectoryPage)dp.parent.get() : null;
        }
        return ret;
    }

    public final int getLevel() {
        DirectoryPage dp;
        int ret = 0;
        DirectoryPage directoryPage = dp = this.parent != null ? this.parent.get() : null;
        while (dp != null) {
            ++ret;
            dp = dp.parent != null ? (DirectoryPage)dp.parent.get() : null;
        }
        return ret;
    }

    public int getLocalHashCode(byte[] key, int prefixLength) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        int maxbits = key.length * 8;
        if (prefixLength >= maxbits) {
            return 0;
        }
        if (prefixLength + this.globalDepth > maxbits) {
            int bitlen = maxbits - prefixLength;
            int ret = BytesUtil.getBits((byte[])key, (int)prefixLength, (int)bitlen);
            return ret << this.globalDepth - bitlen;
        }
        return BytesUtil.getBits((byte[])key, (int)prefixLength, (int)this.globalDepth);
    }

    public int getLocalHashCode(int key, int prefixLength) {
        return BytesUtil.getBits((int)key, (int)prefixLength, (int)this.globalDepth);
    }

    public DirectoryPage getParentDirectory() {
        return this.parent != null ? this.parent.get() : null;
    }

    private AbstractPage() {
        throw new UnsupportedOperationException();
    }

    protected AbstractPage(HTree htree, boolean dirty, int globalDepth) {
        if (htree == null) {
            throw new IllegalArgumentException();
        }
        if (globalDepth < 0) {
            throw new IllegalArgumentException();
        }
        if (globalDepth > htree.addressBits) {
            throw new IllegalArgumentException();
        }
        this.htree = htree;
        this.globalDepth = globalDepth;
        this.self = htree.newRef(this);
        if (!dirty) {
            this.setDirty(false);
        }
        htree.touch(this);
    }

    protected AbstractPage(AbstractPage src) {
        this((HTree)src.htree, true, src.globalDepth);
        assert (this.isDirty());
        assert (!this.isPersistent());
        assert (!src.isDirty());
        assert (src.isReadOnly());
        assert (src == this.htree.root || src.parent != null && src.parent.get() != null);
        this.parent = src.parent;
    }

    @Override
    public void delete() throws IllegalStateException {
        if (this.deleted) {
            throw new IllegalStateException();
        }
        this.parent = null;
        if (this.identity != 0L) {
            // empty if block
        }
        this.deleted = true;
    }

    protected abstract boolean dump(Level var1, PrintStream var2, int var3, boolean var4, boolean var5);

    abstract void PP(StringBuilder var1, boolean var2);

    protected String PPID() {
        int hash = this.hashCode() % 100;
        String hashStr = "#" + (hash < 10 ? "0" : "") + hash;
        return (this.isLeaf() ? "B" : "D") + hashStr + (this.isDirty() ? "*" : " ");
    }

    public final Iterator<AbstractPage> postOrderNodeIterator() {
        return this.postOrderNodeIterator(false, false);
    }

    public final Iterator<AbstractPage> postOrderNodeIterator(boolean dirtyNodesOnly) {
        return this.postOrderNodeIterator(dirtyNodesOnly, false);
    }

    public abstract Iterator<AbstractPage> postOrderNodeIterator(boolean var1, boolean var2);

    protected AbstractPage copyOnWrite() {
        assert (this.isLeaf());
        return this.copyOnWrite(0L);
    }

    protected AbstractPage copyOnWrite(long triggeredByChildId) {
        AbstractPage newNode;
        if (!this.isReadOnly()) {
            this.htree.touch(this);
            return this;
        }
        if (DEBUG) {
            log.debug((Object)("this=" + this.toShortString() + ", trigger=" + triggeredByChildId));
        }
        HTree htree = (HTree)this.htree;
        long oldId = this.identity;
        assert (oldId != 0L);
        DirectoryPage parent = this.getParentDirectory();
        if (this.isLeaf()) {
            newNode = new BucketPage((BucketPage)this);
            ++htree.getBtreeCounters().leavesCopyOnWrite;
        } else {
            newNode = new DirectoryPage((DirectoryPage)this, triggeredByChildId);
            ++htree.getBtreeCounters().nodesCopyOnWrite;
        }
        this.delete();
        if (htree.root == this) {
            assert (parent == null);
            if (INFO) {
                log.info((Object)"Copy-on-write : replaced root node on htree.");
            }
            boolean wasDirty = htree.root.dirty;
            assert (newNode != null);
            htree.root = (DirectoryPage)newNode;
            if (!wasDirty) {
                htree.fireDirtyEvent();
            }
        } else {
            assert (parent != null);
            if (!parent.isDirty()) {
                parent = (DirectoryPage)parent.copyOnWrite(oldId);
            }
            parent.replaceChildRef(oldId, newNode);
        }
        return newNode;
    }

    final boolean dirtyHierarchy() {
        AbstractPage tmp = this;
        while (tmp != null) {
            if (!tmp.isDirty()) {
                return false;
            }
            tmp = tmp.parent == null ? null : tmp.parent.get();
        }
        return true;
    }

    abstract boolean isClean();

    public abstract int removeAll(byte[] var1);

    public abstract byte[] removeFirst(byte[] var1);

    public abstract void dumpPages(boolean var1, boolean var2, HTreePageStats var3);
}

