/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.ha.msg;

import com.bigdata.ha.msg.IHASendStoreResponse;
import com.bigdata.io.ChecksumUtility;
import com.bigdata.journal.IRootBlockView;
import com.bigdata.journal.RootBlockView;
import com.bigdata.util.BytesUtil;
import java.nio.ByteBuffer;

public class HASendStoreResponse
implements IHASendStoreResponse {
    private static final long serialVersionUID = 1L;
    private final byte[] rootBlock0;
    private final byte[] rootBlock1;
    final long byteCount;
    final long blockCount;

    public HASendStoreResponse(IRootBlockView rootBlock0, IRootBlockView rootBlock1, long byteCount, long blockCount) {
        if (rootBlock0 == null) {
            throw new IllegalArgumentException();
        }
        if (rootBlock1 == null) {
            throw new IllegalArgumentException();
        }
        this.rootBlock0 = BytesUtil.toArray((ByteBuffer)rootBlock0.asReadOnlyBuffer());
        this.rootBlock1 = BytesUtil.toArray((ByteBuffer)rootBlock1.asReadOnlyBuffer());
        this.byteCount = byteCount;
        this.blockCount = blockCount;
    }

    @Override
    public IRootBlockView getRootBlock0() {
        return new RootBlockView(true, ByteBuffer.wrap(this.rootBlock0), new ChecksumUtility());
    }

    @Override
    public IRootBlockView getRootBlock1() {
        return new RootBlockView(false, ByteBuffer.wrap(this.rootBlock1), new ChecksumUtility());
    }

    @Override
    public long getByteCount() {
        return this.byteCount;
    }

    @Override
    public long getBlockCount() {
        return this.blockCount;
    }

    public String toString() {
        return this.getClass() + "{rootBlock0=" + this.getRootBlock0() + ", rootBlock1=" + this.getRootBlock1() + ", bytesSent=" + this.getByteCount() + ", blocksSent=" + this.getBlockCount() + "}";
    }
}

