/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters.striped;

import com.bigdata.counters.CounterSet;
import java.lang.reflect.Constructor;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.system.SystemUtil;

public class StripedCounters<T extends StripedCounters<T>> {
    protected int batchSize;
    protected int n;
    private final StripedCounters<?>[] a;
    protected final ReentrantLock[] locks;
    protected T parent;
    private int threadHash;

    private final int threadHash() {
        return Math.abs(Thread.currentThread().hashCode() % this.a.length);
    }

    public final T acquire() {
        int i;
        if (this.a == null) {
            return (T)this;
        }
        this.a[i].threadHash = i = this.threadHash();
        this.locks[i].lock();
        return (T)this.a[i];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void release() {
        if (this.parent == null) {
            return;
        }
        if (--this.n == 0) {
            this.n = this.batchSize;
            T t = this.parent;
            synchronized (t) {
                this.parent.add((StripedCounters)this);
            }
            this.clear();
        }
        ((StripedCounters)this.parent).locks[this.threadHash].unlock();
    }

    public StripedCounters() {
        this.a = null;
        this.locks = null;
        this.parent = null;
        this.n = 1;
        this.batchSize = 1;
    }

    public StripedCounters(int batchSize) {
        this(SystemUtil.numProcessors() * 2, batchSize);
    }

    public StripedCounters(int nstripes, int batchSize) {
        if (nstripes < 1) {
            throw new IllegalArgumentException();
        }
        if (batchSize < 1) {
            throw new IllegalArgumentException();
        }
        this.a = new StripedCounters[nstripes];
        this.locks = new ReentrantLock[nstripes];
        for (int i = 0; i < nstripes; ++i) {
            T t = this.newStripedCounters();
            ((StripedCounters)t).parent = this;
            ((StripedCounters)t).batchSize = ((StripedCounters)t).n = batchSize;
            this.a[i] = t;
            this.locks[i] = new ReentrantLock();
        }
        this.parent = null;
        this.batchSize = this.n = batchSize;
    }

    private T newStripedCounters() {
        try {
            Constructor<?> ctor = this.getClass().getConstructor(new Class[0]);
            return (T)((StripedCounters)ctor.newInstance(new Object[0]));
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public void add(T o) {
    }

    public T subtract(T o) {
        StripedCounters t = this.newStripedCounters();
        t.add((StripedCounters)this);
        return (T)t;
    }

    public void clear() {
    }

    public CounterSet getCounters() {
        return new CounterSet();
    }

    public String toString() {
        return this.getCounters().toString();
    }
}

