/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree.raba;

import com.bigdata.btree.raba.AbstractRaba;
import com.bigdata.btree.raba.IRaba;
import java.io.DataInput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class MutableValueBuffer
implements IRaba {
    public int nvalues;
    public final byte[][] values;

    @Override
    public final boolean isReadOnly() {
        return false;
    }

    @Override
    public final boolean isKeys() {
        return false;
    }

    public MutableValueBuffer(int nvalues) {
        this(0, new byte[nvalues][]);
    }

    public MutableValueBuffer(int nvalues, byte[][] values) {
        if (values == null) {
            throw new IllegalArgumentException();
        }
        if (nvalues < 0 || nvalues >= values.length) {
            throw new IllegalArgumentException();
        }
        this.nvalues = nvalues;
        this.values = values;
    }

    public MutableValueBuffer(int capacity, IRaba src) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        if (capacity < src.capacity()) {
            throw new IllegalArgumentException();
        }
        this.nvalues = src.size();
        assert (this.nvalues >= 0);
        this.values = new byte[capacity][];
        int i = 0;
        for (byte[] a : src) {
            this.values[i++] = a;
        }
    }

    @Override
    public final int size() {
        return this.nvalues;
    }

    @Override
    public final boolean isEmpty() {
        return this.nvalues == 0;
    }

    @Override
    public final boolean isFull() {
        return this.nvalues == this.values.length;
    }

    @Override
    public final int capacity() {
        return this.values.length;
    }

    protected final boolean rangeCheck(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.nvalues) {
            throw new IndexOutOfBoundsException("index=" + index + ", capacity=" + this.nvalues);
        }
        return true;
    }

    @Override
    public final byte[] get(int index) {
        assert (this.rangeCheck(index));
        return this.values[index];
    }

    @Override
    public final int length(int index) {
        assert (this.rangeCheck(index));
        byte[] tmp = this.values[index];
        if (tmp == null) {
            throw new NullPointerException();
        }
        return tmp.length;
    }

    @Override
    public final boolean isNull(int index) {
        assert (this.rangeCheck(index));
        return this.values[index] == null;
    }

    @Override
    public final int copy(int index, OutputStream out) {
        assert (this.rangeCheck(index));
        byte[] tmp = this.values[index];
        if (tmp == null) {
            throw new NullPointerException();
        }
        try {
            out.write(tmp, 0, tmp.length);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return tmp.length;
    }

    @Override
    public final Iterator<byte[]> iterator() {
        return new Iterator<byte[]>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < MutableValueBuffer.this.nvalues;
            }

            @Override
            public byte[] next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return MutableValueBuffer.this.values[this.i++];
            }

            @Override
            public void remove() {
                if (MutableValueBuffer.this.isReadOnly()) {
                    throw new UnsupportedOperationException();
                }
                throw new UnsupportedOperationException();
            }
        };
    }

    protected void assertNotFull() {
        if (this.nvalues >= this.values.length) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void set(int index, byte[] key) {
        assert (this.rangeCheck(index));
        this.values[index] = key;
    }

    @Override
    public int add(byte[] key) {
        this.assertNotFull();
        this.values[this.nvalues++] = key;
        return this.nvalues;
    }

    @Override
    public int add(byte[] key, int off, int len) {
        this.assertNotFull();
        byte[] b = new byte[len];
        System.arraycopy(key, off, b, 0, len);
        this.values[this.nvalues++] = b;
        return this.nvalues;
    }

    @Override
    public int add(DataInput in, int len) throws IOException {
        this.assertNotFull();
        byte[] b = new byte[len];
        in.readFully(b, 0, len);
        this.values[this.nvalues++] = b;
        return this.nvalues;
    }

    @Override
    public final int search(byte[] searchKey) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return AbstractRaba.toString(this);
    }
}

