/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.join;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpContext;
import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstraint;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.controller.INamedSolutionSetRef;
import com.bigdata.bop.engine.AbstractRunningQuery;
import com.bigdata.bop.engine.BOpStats;
import com.bigdata.bop.engine.IRunningQuery;
import com.bigdata.bop.engine.QueryEngine;
import com.bigdata.bop.join.IHashJoinUtility;
import com.bigdata.bop.join.IHashJoinUtilityFactory;
import com.bigdata.bop.join.JVMHashIndex;
import com.bigdata.bop.join.JVMHashJoinUtility;
import com.bigdata.bop.join.JoinTypeEnum;
import com.bigdata.bop.join.NamedSolutionSetStats;
import com.bigdata.bop.join.PipelinedHashIndexAndSolutionSetJoinOp;
import com.bigdata.bop.join.PipelinedHashJoinUtility;
import com.bigdata.bop.join.UnconstrainedJoinException;
import com.bigdata.counters.CAT;
import com.bigdata.rdf.internal.impl.literal.XSDBooleanIV;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.relation.accesspath.BufferClosedException;
import com.bigdata.relation.accesspath.IBuffer;
import com.bigdata.relation.accesspath.UnsyncLocalOutputBuffer;
import com.bigdata.util.InnerCause;
import com.bigdata.util.concurrent.IHaltable;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class JVMPipelinedHashJoinUtility
extends JVMHashJoinUtility
implements PipelinedHashJoinUtility {
    private static final Logger log = Logger.getLogger(JVMPipelinedHashJoinUtility.class);
    protected final CAT nDistinctBindingSets = new CAT();
    protected final CAT nDistinctBindingSetsReleased = new CAT();
    protected final CAT nSubqueriesIssued = new CAT();
    protected final CAT nResultsFromSubqueries = new CAT();
    final Set<IBindingSet> distinctProjectionBuffer = new HashSet<IBindingSet>();
    final List<IBindingSet> incomingBindingsBuffer = new LinkedList<IBindingSet>();
    final Set<IBindingSet> distinctProjectionsWithoutSubqueryResult = new HashSet<IBindingSet>();
    private boolean bsFromBindingsSetSourceAddedToHashIndex = false;
    public static final IHashJoinUtilityFactory factory = new IHashJoinUtilityFactory(){
        private static final long serialVersionUID = 1L;

        @Override
        public IHashJoinUtility create(BOpContext<IBindingSet> context, INamedSolutionSetRef namedSetRef, PipelineOp op, JoinTypeEnum joinType) {
            return new JVMPipelinedHashJoinUtility(op, joinType, context, op.getChunkCapacity());
        }
    };

    public JVMPipelinedHashJoinUtility(PipelineOp op, JoinTypeEnum joinType, BOpContext<IBindingSet> context, int chunkCapacity) {
        super(op, joinType);
        if (!(op instanceof PipelinedHashIndexAndSolutionSetJoinOp)) {
            throw new IllegalArgumentException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long acceptAndOutputSolutions(UnsyncLocalOutputBuffer<IBindingSet> out, ICloseableIterator<IBindingSet[]> itr, NamedSolutionSetStats stats, IConstraint[] joinConstraints, PipelineOp subquery, IBindingSet[] bsFromBindingsSetSource, IVariable<?>[] projectInVars, IVariable<?> askVar, boolean isLastInvocation, int distinctProjectionBufferThreshold, int incomingBindingsBufferThreshold, BOpContext<IBindingSet> context) {
        JVMHashIndex rightSolutions = this.getRightSolutions();
        if (bsFromBindingsSetSource != null) {
            this.addBindingsSetSourceToHashIndexOnce(rightSolutions, bsFromBindingsSetSource);
        }
        QueryEngine queryEngine = context.getRunningQuery().getQueryEngine();
        long naccepted = 0L;
        LinkedList<IBindingSet> dontRequireSubqueryEvaluation = new LinkedList<IBindingSet>();
        int nDistinctProjections = this.distinctProjectionBuffer.size();
        while (itr.hasNext()) {
            IBindingSet[] chunk = (IBindingSet[])itr.next();
            if (stats != null) {
                stats.chunksIn.increment();
                stats.unitsIn.add(chunk.length);
            }
            for (int i = 0; i < chunk.length; ++i) {
                if (subquery == null) {
                    dontRequireSubqueryEvaluation.add(chunk[i]);
                    continue;
                }
                IBindingSet bsetDistinct = chunk[i].copy(projectInVars);
                JVMHashIndex.Bucket b = rightSolutions.getBucket(bsetDistinct);
                if (b != null || this.distinctProjectionsWithoutSubqueryResult.contains(bsetDistinct)) {
                    dontRequireSubqueryEvaluation.add(chunk[i]);
                } else {
                    this.incomingBindingsBuffer.add(chunk[i]);
                    this.distinctProjectionBuffer.add(bsetDistinct);
                }
                ++naccepted;
            }
        }
        this.nDistinctBindingSets.add(this.distinctProjectionBuffer.size() - nDistinctProjections);
        if (!dontRequireSubqueryEvaluation.isEmpty()) {
            this.hashJoinAndEmit(dontRequireSubqueryEvaluation.toArray(new IBindingSet[0]), stats, out, joinConstraints, askVar);
        }
        if (this.distinctProjectionBuffer.isEmpty()) {
            return naccepted;
        }
        if (!isLastInvocation && !this.thresholdExceeded(this.distinctProjectionBuffer, distinctProjectionBufferThreshold, this.incomingBindingsBuffer, incomingBindingsBufferThreshold)) {
            return naccepted;
        }
        assert (subquery != null);
        IHaltable runningSubquery = null;
        try {
            runningSubquery = queryEngine.eval((BOp)subquery, this.distinctProjectionBuffer.toArray(new IBindingSet[0]));
            ((AbstractRunningQuery)context.getRunningQuery()).addChild((IRunningQuery)runningSubquery);
            this.nDistinctBindingSetsReleased.add(this.distinctProjectionBuffer.size());
            this.nSubqueriesIssued.increment();
            try (ICloseableIterator<IBindingSet[]> subquerySolutionItr = runningSubquery.iterator();){
                while (subquerySolutionItr.hasNext()) {
                    IBindingSet[] solutions;
                    for (IBindingSet solution : solutions = (IBindingSet[])subquerySolutionItr.next()) {
                        rightSolutions.add(solution);
                        this.distinctProjectionBuffer.remove(solution.copy(this.getJoinVars()));
                        this.nResultsFromSubqueries.increment();
                    }
                }
                this.distinctProjectionsWithoutSubqueryResult.addAll(this.distinctProjectionBuffer);
            }
            runningSubquery.get();
        }
        catch (Throwable t) {
            Throwable cause = runningSubquery != null && runningSubquery.getCause() != null ? runningSubquery.getCause() : t;
            throw new RuntimeException(context.getRunningQuery().halt(cause));
        }
        finally {
            if (runningSubquery != null) {
                runningSubquery.cancel(true);
            }
        }
        this.rightSolutionCount.add(naccepted);
        this.hashJoinAndEmit(this.incomingBindingsBuffer.toArray(new IBindingSet[0]), stats, out, joinConstraints, askVar);
        this.distinctProjectionBuffer.clear();
        this.incomingBindingsBuffer.clear();
        return naccepted;
    }

    boolean thresholdExceeded(Set<IBindingSet> distinctProjectionBuffer, int distinctProjectionBufferThreshold, List<IBindingSet> incomingBindingsBuffer, int incomingBindingsBufferThreshold) {
        return distinctProjectionBuffer.size() >= distinctProjectionBufferThreshold || incomingBindingsBuffer.size() >= incomingBindingsBufferThreshold;
    }

    void addBindingsSetSourceToHashIndexOnce(JVMHashIndex rightSolutions, IBindingSet[] bsFromBindingsSetSource) {
        if (!this.bsFromBindingsSetSourceAddedToHashIndex) {
            for (IBindingSet solution : bsFromBindingsSetSource) {
                rightSolutions.add(solution);
            }
            this.bsFromBindingsSetSourceAddedToHashIndex = true;
        }
    }

    public void hashJoinAndEmit(IBindingSet[] chunk, BOpStats stats, IBuffer<IBindingSet> outputBuffer, IConstraint[] joinConstraints, IVariable<?> askVar) {
        JVMHashIndex rightSolutions = this.getRightSolutions();
        if (log.isInfoEnabled()) {
            log.info((Object)("rightSolutions: #buckets=" + rightSolutions.bucketCount() + ",#solutions=" + this.getRightSolutionCount()));
        }
        boolean noJoinVars = this.getJoinVars().length == 0;
        block9: for (IBindingSet left : chunk) {
            JVMHashIndex.Bucket bucket = rightSolutions.getBucket(left);
            this.nleftConsidered.increment();
            boolean matchExists = false;
            if (bucket != null) {
                block10: for (JVMHashIndex.SolutionHit right : bucket) {
                    this.nrightConsidered.increment();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Join with " + right));
                    }
                    this.nJoinsConsidered.increment();
                    if (noJoinVars && this.nJoinsConsidered.get() == this.getNoJoinVarsLimit() && this.nleftConsidered.get() > 1L && this.nrightConsidered.get() > 1L) {
                        throw new UnconstrainedJoinException();
                    }
                    IBindingSet outSolution = BOpContext.bind(right.solution, left, joinConstraints, this.getSelectVars());
                    matchExists |= outSolution != null;
                    switch (this.getJoinType()) {
                        case Normal: 
                        case Optional: {
                            if (outSolution == null) continue block10;
                            if (askVar != null) {
                                outSolution.set(askVar, new Constant<XSDBooleanIV<BigdataLiteral>>(XSDBooleanIV.TRUE));
                            }
                            this.outputSolution(outputBuffer, outSolution);
                            continue block10;
                        }
                        case Exists: 
                        case NotExists: {
                            continue block10;
                        }
                    }
                    throw new AssertionError();
                }
            }
            switch (this.getJoinType()) {
                case Optional: 
                case NotExists: {
                    if (matchExists) continue block9;
                    this.outputSolution(outputBuffer, left);
                    continue block9;
                }
                case Exists: {
                    if (askVar == null) continue block9;
                    left.set(askVar, new Constant<XSDBooleanIV<BigdataLiteral>>(matchExists ? XSDBooleanIV.TRUE : XSDBooleanIV.FALSE));
                    this.outputSolution(outputBuffer, left);
                    continue block9;
                }
                case Normal: {
                    continue block9;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
    }

    protected RuntimeException launderThrowable(Throwable t) {
        String msg = "cause=" + t + ", state=" + this.toString();
        if (!InnerCause.isInnerCause((Throwable)t, InterruptedException.class) && !InnerCause.isInnerCause((Throwable)t, BufferClosedException.class)) {
            log.error((Object)msg, t);
        }
        return new RuntimeException(msg, t);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("{open=" + this.open);
        sb.append(",joinType=" + (Object)((Object)this.joinType));
        if (this.askVar != null) {
            sb.append(",askVar=" + this.askVar);
        }
        sb.append(",joinVars=" + Arrays.toString(this.joinVars));
        sb.append(",outputDistinctJVs=" + this.outputDistinctJVs);
        if (this.selectVars != null) {
            sb.append(",selectVars=" + Arrays.toString(this.selectVars));
        }
        if (this.constraints != null) {
            sb.append(",constraints=" + Arrays.toString(this.constraints));
        }
        sb.append(",size=" + this.getRightSolutionCount());
        sb.append(", distinctProjectionsWithoutSubqueryResult=" + this.distinctProjectionsWithoutSubqueryResult.size());
        sb.append(", distinctBindingSets (seen/released)=" + this.nDistinctBindingSets + "/" + this.nDistinctBindingSetsReleased);
        sb.append(", subqueriesIssued=" + this.nSubqueriesIssued);
        sb.append(", resultsFromSubqueries=" + this.nResultsFromSubqueries);
        sb.append(",considered(left=" + this.nleftConsidered + ",right=" + this.nrightConsidered + ",joins=" + this.nJoinsConsidered + ")");
        sb.append("}");
        return sb.toString();
    }
}

