/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.ap;

import com.bigdata.bop.AbstractAccessPathOp;
import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpBase;
import com.bigdata.bop.Constant;
import com.bigdata.bop.CoreBaseBOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IElement;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.bop.NV;
import com.bigdata.bop.bindingSet.ListBindingSet;
import com.bigdata.rdf.internal.constraints.RangeBOp;
import com.bigdata.rdf.spo.SPOKeyOrder;
import com.bigdata.relation.accesspath.ElementFilter;
import com.bigdata.relation.accesspath.IElementFilter;
import com.bigdata.relation.rule.IAccessPathExpander;
import com.bigdata.striterator.IKeyOrder;
import cutthecrap.utils.striterators.IFilter;
import cutthecrap.utils.striterators.NOPFilter;
import java.util.Map;

public class Predicate<E>
extends AbstractAccessPathOp<E>
implements IPredicate<E> {
    private static final long serialVersionUID = 1L;

    public Predicate(BOp[] args, Map<String, Object> annotations) {
        super(args, annotations);
    }

    public Predicate(Predicate<E> op) {
        super(op);
    }

    public Predicate(BOp[] args, NV ... annotations) {
        super(args, NV.asMap(annotations));
    }

    @Override
    protected void checkArgs(BOp[] args) {
        for (BOp a : args) {
            if (a != null) continue;
            throw new IllegalArgumentException();
        }
    }

    public Predicate(IVariableOrConstant<?>[] values, String relationName, long timestamp) {
        this(values, relationName, -1, false, null, null, -1L);
    }

    public Predicate(IVariableOrConstant<?>[] values, String relationName, int partitionId, boolean optional, IElementFilter<E> constraint, IAccessPathExpander<E> expander, long timestamp) {
        this((BOp[])values, NV.asMap(new NV(Annotations.RELATION_NAME, new String[]{relationName}), new NV(Annotations.PARTITION_ID, partitionId), new NV(Annotations.OPTIONAL, optional), new NV(Annotations.INDEX_LOCAL_FILTER, ElementFilter.newInstance(constraint)), new NV(Annotations.ACCESS_PATH_EXPANDER, expander), new NV(Annotations.TIMESTAMP, timestamp)));
        if (relationName == null) {
            throw new IllegalArgumentException();
        }
        if (partitionId < -1) {
            throw new IllegalArgumentException();
        }
        if (values == null) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public String getOnlyRelationName() {
        String[] relationName = (String[])this.getRequiredProperty(Annotations.RELATION_NAME);
        if (relationName.length != 1) {
            throw new IllegalStateException();
        }
        return relationName[0];
    }

    @Override
    public String getRelationName(int index) {
        String[] relationName = (String[])this.getRequiredProperty(Annotations.RELATION_NAME);
        return relationName[index];
    }

    @Override
    public int getRelationCount() {
        String[] relationName = (String[])this.getRequiredProperty(Annotations.RELATION_NAME);
        return relationName.length;
    }

    @Override
    public Predicate<E> setRelationName(String[] relationName) {
        CoreBaseBOp tmp = this.clone();
        ((BOpBase)tmp)._setProperty(Annotations.RELATION_NAME, relationName);
        return tmp;
    }

    @Override
    public int getPartitionId() {
        return this.getProperty(Annotations.PARTITION_ID, -1);
    }

    @Override
    public IVariableOrConstant get(int index) {
        return (IVariableOrConstant)super.get(index);
    }

    @Override
    public IConstant<?> get(E e, int index) {
        return new Constant<Object>(((IElement)e).get(index));
    }

    @Override
    public final boolean isOptional() {
        return this.getProperty(Annotations.OPTIONAL, false);
    }

    @Override
    public final IFilter getIndexLocalFilter() {
        return (IFilter)this.getProperty(Annotations.INDEX_LOCAL_FILTER);
    }

    @Override
    public final IFilter getAccessPathFilter() {
        return (IFilter)this.getProperty(Annotations.ACCESS_PATH_FILTER);
    }

    @Override
    public final IAccessPathExpander<E> getAccessPathExpander() {
        return (IAccessPathExpander)this.getProperty(Annotations.ACCESS_PATH_EXPANDER);
    }

    @Override
    public final int getVariableCount() {
        int nvars = 0;
        int arity = this.arity();
        for (int i = 0; i < arity; ++i) {
            if (!(this.get(i) instanceof IVariable)) continue;
            ++nvars;
        }
        return nvars;
    }

    @Override
    public final boolean isFullyBound(IKeyOrder<E> keyOrder) {
        return this.getVariableCount(keyOrder) == 0;
    }

    @Override
    public final int getVariableCount(IKeyOrder<E> keyOrder) {
        int nunbound = 0;
        int keyArity = keyOrder.getKeyArity();
        for (int keyPos = 0; keyPos < keyArity; ++keyPos) {
            int index = keyOrder.getKeyOrder(keyPos);
            IVariableOrConstant t = this.get(index);
            if (t != null && !t.isVar()) continue;
            ++nunbound;
        }
        return nunbound;
    }

    @Override
    public final boolean isRemoteAccessPath() {
        return this.getProperty(Annotations.REMOTE_ACCESS_PATH, true);
    }

    @Override
    public Predicate<E> asBound(IVariable<?> var, IConstant<?> val) {
        return this.asBound(new ListBindingSet(new IVariable[]{var}, new IConstant[]{val}));
    }

    @Override
    public Predicate<E> asBound(IBindingSet bindingSet) {
        RangeBOp asBound;
        Map<String, Object> anns = this.annotationsRef();
        RangeBOp rangeBOp = this.range();
        if (rangeBOp != null && (asBound = rangeBOp.asBound(bindingSet)) != rangeBOp) {
            anns = this.annotationsCopy();
            anns.put(Annotations.RANGE, asBound);
        }
        return new Predicate<E>(this.argsCopy(), anns)._asBound(bindingSet);
    }

    protected final Predicate<E> _asBound(IBindingSet bindingSet) {
        if (bindingSet == null) {
            throw new IllegalArgumentException();
        }
        int arity = this.arity();
        for (int i = 0; i < arity; ++i) {
            IVariable var;
            IConstant val;
            IVariableOrConstant t = this.get(i);
            if (t.isConstant() || (val = bindingSet.get(var = (IVariable)t)) == null) continue;
            this._set(i, new Constant<Object>(var, val.get()));
        }
        return this;
    }

    @Override
    public Object asBound(int index, IBindingSet bindingSet) {
        return this.get(index).get(bindingSet);
    }

    public final RangeBOp range() {
        return (RangeBOp)this.getProperty(Annotations.RANGE);
    }

    @Override
    public IKeyOrder<E> getKeyOrder() {
        Object o = this.getProperty(Annotations.KEY_ORDER);
        if (o == null) {
            return null;
        }
        if (o instanceof IKeyOrder) {
            return (IKeyOrder)o;
        }
        return SPOKeyOrder.fromString((String)o);
    }

    @Override
    public Predicate<E> clone() {
        return new Predicate<E>(this);
    }

    @Override
    public Predicate<E> setPartitionId(int partitionId) {
        CoreBaseBOp tmp = this.clone();
        ((BOpBase)tmp)._setProperty(Annotations.PARTITION_ID, partitionId);
        return tmp;
    }

    @Override
    public Predicate<E> setBOpId(int bopId) {
        CoreBaseBOp tmp = this.clone();
        ((BOpBase)tmp)._setProperty(Annotations.BOP_ID, bopId);
        return tmp;
    }

    public Predicate<E> setTimestamp(long timestamp) {
        CoreBaseBOp tmp = this.clone();
        ((BOpBase)tmp)._setProperty(Annotations.TIMESTAMP, timestamp);
        return tmp;
    }

    @Override
    public Predicate<E> setArg(int index, IVariableOrConstant arg) {
        CoreBaseBOp tmp = this.clone();
        ((BOpBase)tmp)._set(index, (BOp)arg);
        return tmp;
    }

    public Predicate<E> addIndexLocalFilter(IFilter filter) {
        CoreBaseBOp tmp = this.clone();
        super.addFilter(Annotations.INDEX_LOCAL_FILTER, filter);
        return tmp;
    }

    public Predicate<E> addAccessPathFilter(IFilter filter) {
        CoreBaseBOp tmp = this.clone();
        super.addFilter(Annotations.ACCESS_PATH_FILTER, filter);
        return tmp;
    }

    private void addFilter(String name, IFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException();
        }
        IFilter current = (IFilter)this.getProperty(name);
        if (current == null) {
            this._setProperty(name, filter);
        } else {
            this._setProperty(name, new NOPFilter().addFilter(current).addFilter(filter));
        }
    }

    @Override
    public Predicate<E> clearAnnotations(String[] names) {
        return (Predicate)super.clearAnnotations(names);
    }

    @Override
    public String toString() {
        return this.toString(null);
    }

    @Override
    public String toString(IBindingSet bindingSet) {
        int arity = this.arity();
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        Integer bopId = (Integer)this.getProperty(Annotations.BOP_ID);
        if (bopId != null) {
            sb.append("[" + bopId + "]");
        }
        sb.append("(");
        for (int i = 0; i < arity; ++i) {
            IVariableOrConstant v;
            if (i > 0) {
                sb.append(", ");
            }
            sb.append((v = this.get(i)) == null ? null : (v.isConstant() ? v.toString() : v + "=" + (bindingSet == null ? null : bindingSet.get((IVariable)v))));
        }
        sb.append(")");
        this.annotationsToString(sb);
        return sb.toString();
    }

    @Override
    public final long getTimestamp() {
        return (Long)this.getRequiredProperty(IPredicate.Annotations.TIMESTAMP);
    }

    public static interface Annotations
    extends IPredicate.Annotations {
    }
}

