/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bfs;

import com.bigdata.bfs.BigdataFileSystem;
import com.bigdata.btree.AbstractBTree;
import com.bigdata.btree.BTree;
import com.bigdata.btree.IIndex;
import com.bigdata.btree.ILinearList;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.btree.proc.ISimpleIndexProcedure;
import com.bigdata.io.DataOutputBuffer;
import com.bigdata.journal.AbstractJournal;
import com.bigdata.util.BytesUtil;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class AtomicBlockAppendProc
implements ISimpleIndexProcedure<Object>,
Externalizable {
    private static final long serialVersionUID = 1441331704737671258L;
    protected static transient Logger log = Logger.getLogger(AtomicBlockAppendProc.class);
    protected static final transient boolean INFO = log.getEffectiveLevel().toInt() <= Level.INFO.toInt();
    protected static final transient boolean DEBUG = log.getEffectiveLevel().toInt() <= Level.DEBUG.toInt();
    private String id;
    private int version;
    private int off;
    private int len;
    private byte[] b;

    @Override
    public final boolean isReadOnly() {
        return false;
    }

    public AtomicBlockAppendProc(BigdataFileSystem repo, String id, int version, byte[] b, int off, int len) {
        assert (id != null && id.length() > 0);
        assert (version >= 0);
        assert (b != null);
        assert (off >= 0) : "off=" + off;
        assert (len >= 0 && off + len <= b.length);
        assert (len <= repo.getBlockSize()) : "len=" + len + " exceeds blockSize=" + repo.getBlockSize();
        this.id = id;
        this.version = version;
        this.off = off;
        this.len = len;
        this.b = b;
    }

    @Override
    public Object apply(IIndex ndx) {
        AbstractJournal journal = (AbstractJournal)((AbstractBTree)ndx).getStore();
        IKeyBuilder keyBuilder = ndx.getIndexMetadata().getKeyBuilder();
        long block = this.getNextBlockIdentifierInFileVersion(ndx, keyBuilder);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will write " + this.len + " bytes on id=" + this.id + ", version=" + this.version + ", block#=" + block));
        }
        long addr = this.len == 0 ? 0L : journal.write(ByteBuffer.wrap(this.b, this.off, this.len));
        byte[] key = keyBuilder.reset().appendText(this.id, true, false).append(this.version).append(block).getKey();
        DataOutputBuffer out = new DataOutputBuffer(8);
        out.reset().putLong(addr);
        byte[] val = out.toByteArray();
        ndx.insert(key, val);
        if (log.isInfoEnabled()) {
            log.info((Object)("Wrote " + this.len + " bytes : id=" + this.id + ", version=" + this.version + ", block#=" + block + " @ addr" + journal.toString(addr)));
        }
        return block;
    }

    protected long getNextBlockIdentifierInFileVersion2(IIndex ndx, IKeyBuilder keyBuilder) {
        byte[] toKey;
        byte[] fromKey = keyBuilder.reset().appendText(this.id, true, false).append(this.version).append(0).getKey();
        ITupleIterator itr = ndx.rangeIterator(fromKey, toKey = keyBuilder.reset().appendText(this.id, true, false).append(this.version).append(Long.MAX_VALUE).getKey(), 1, 65, null);
        if (!itr.hasNext()) {
            return 0L;
        }
        byte[] key = itr.next().getKey();
        return this.getNextBlockFromPriorKey(keyBuilder, key);
    }

    protected long getNextBlockIdentifierInFileVersion(IIndex ndx, IKeyBuilder keyBuilder) {
        long block;
        byte[] toKey = keyBuilder.reset().appendText(this.id, true, false).append(this.version).append(Long.MAX_VALUE).getKey();
        ILinearList tmp = (ILinearList)((Object)ndx);
        long toIndex = tmp.indexOf(toKey);
        assert (toIndex < 0L) : "Expecting insertion point: id=" + this.id + ", version=" + this.version + ", toIndex=" + toIndex;
        if (log.isDebugEnabled()) {
            log.debug((Object)("insertionPoint=" + toIndex));
        }
        toIndex = -(toIndex + 1L);
        long entryCount = ((AbstractBTree)ndx).getEntryCount();
        if (log.isDebugEnabled()) {
            log.debug((Object)("toIndex=" + toIndex + ", entryCount=" + entryCount));
        }
        if (toIndex == 0L) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Insertion point is before all entries in the index partition: id=" + this.id + ", version=" + this.version));
            }
            byte[] leftSeparator = ((BTree)ndx).getIndexMetadata().getPartitionMetadata().getLeftSeparatorKey();
            block = this.getNextBlockFromPriorKey(keyBuilder, leftSeparator);
        } else {
            if (toIndex == entryCount) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Insertion point is after all entries in the index partition: id=" + this.id + ", version=" + this.version));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Insertion point is at the toKey: id=" + this.id + ", version=" + this.version));
            }
            --toIndex;
            if (log.isDebugEnabled()) {
                log.debug((Object)("adjusted toIndex=" + toIndex + ", entryCount=" + entryCount));
            }
            byte[] key = tmp.keyAt(toIndex);
            assert (key != null) : "Expecting entry: id=" + this.id + ", version=" + this.version + ", toIndex=" + toIndex;
            block = this.getNextBlockFromPriorKey(keyBuilder, key);
        }
        return block;
    }

    protected long getNextBlockFromPriorKey(IKeyBuilder keyBuilder, byte[] key) {
        byte[] prefix = keyBuilder.reset().appendText(this.id, true, false).append(this.version).getKey();
        if (DEBUG) {
            log.debug((Object)("Comparing\nkey   :" + Arrays.toString(key) + "\nprefix:" + Arrays.toString(prefix)));
        }
        if (key.length >= prefix.length) {
            int cmp = BytesUtil.compareBytesWithLenAndOffset((int)0, (int)prefix.length, (byte[])prefix, (int)0, (int)prefix.length, (byte[])key);
            if (DEBUG) {
                log.debug((Object)("Comparing " + prefix.length + " byte prefix with " + key.length + " byte key: cmp=" + cmp));
            }
            if (cmp == 0) {
                if (prefix.length + 8 == key.length) {
                    long block = KeyBuilder.decodeLong(key, key.length - 8) + 1L;
                    if (block > 0x7FFFFFFFFFFFFFFEL) {
                        throw new RuntimeException("File version has maximum #of blocks: id=" + this.id + ", version=" + this.version);
                    }
                    if (INFO) {
                        log.info((Object)("Appending to existing file version: id=" + this.id + ", version=" + this.version + ", block=" + block));
                    }
                    return block;
                }
                if (INFO) {
                    log.info((Object)"Key is for same file version but does not contain block identifier.");
                }
            } else if (DEBUG) {
                log.debug((Object)"Key does not compare as equal for length of prefix.");
            }
        } else {
            log.debug((Object)"Key is shorter than prefix.");
        }
        if (INFO) {
            log.info((Object)("Appending to new file version: id=" + this.id + ", version=" + this.version + ", block=" + 0L));
        }
        return 0L;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readUTF();
        this.version = in.readInt();
        this.off = 0;
        this.len = in.readInt();
        this.b = new byte[this.len];
        in.readFully(this.b);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.id);
        out.writeInt(this.version);
        out.writeInt(this.len);
        out.write(this.b, this.off, this.len);
    }
}

