/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.transforms;

import com.github.owlcs.ontapi.transforms.TransformException;
import com.github.owlcs.ontapi.transforms.TransformationModel;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Triple;

@FunctionalInterface
public interface Transform
extends Serializable {
    public Stream<Triple> apply(Graph var1);

    default public boolean test(Graph g) {
        return true;
    }

    default public String id() {
        return this.getClass().getName() + "@" + Objects.hashCode(this);
    }

    public static class Factory {
        public static Transform create(String id, Predicate<Graph> filter, final Consumer<Graph> transform) {
            Objects.requireNonNull(id, "Null id");
            Objects.requireNonNull(transform, "Null transform function");
            return Factory.create(id, g -> new TransformationModel((Graph)g, (Graph)g, filter, id){
                final /* synthetic */ Graph val$g;
                final /* synthetic */ Predicate val$filter;
                final /* synthetic */ String val$id;
                {
                    this.val$g = graph2;
                    this.val$filter = predicate;
                    this.val$id = string;
                    super(graph);
                }

                @Override
                public void perform() throws TransformException {
                    transform.accept(this.val$g);
                }

                @Override
                public boolean test() {
                    return this.val$filter == null || this.val$filter.test(this.graph);
                }

                @Override
                public String name() {
                    return this.val$id;
                }
            });
        }

        public static Transform create(final String id, final Function<Graph, TransformationModel> factory) {
            Objects.requireNonNull(id, "Null id");
            Objects.requireNonNull(factory, "Null transform factory");
            return new Transform(){

                @Override
                public Stream<Triple> apply(Graph g) {
                    TransformationModel r = (TransformationModel)factory.apply(g);
                    r.perform();
                    return r.uncertainTriples();
                }

                @Override
                public boolean test(Graph g) {
                    return ((TransformationModel)factory.apply(g)).test();
                }

                @Override
                public String id() {
                    return id;
                }
            };
        }

        public static Transform create(Class<? extends TransformationModel> impl) {
            return new DefaultMaker(impl);
        }

        public static class DefaultMaker
        implements Transform {
            protected final Class<? extends TransformationModel> impl;

            protected DefaultMaker(Class<? extends TransformationModel> impl) throws IllegalArgumentException {
                this.impl = DefaultMaker.checkHasOneParameterConstructor(impl, Graph.class);
            }

            public static <X> Class<X> checkHasOneParameterConstructor(Class<X> impl, Class<?> param) {
                try {
                    if (!Modifier.isPublic(impl.getDeclaredConstructor(param).getModifiers())) {
                        throw new IllegalArgumentException(impl.getName() + ": no public constructor.");
                    }
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalArgumentException(impl.getName() + " must have public constructor with " + param.getName() + " as the only parameter.", e);
                }
                return impl;
            }

            public TransformationModel create(Graph graph) throws IllegalStateException {
                try {
                    return this.impl.getDeclaredConstructor(Graph.class).newInstance(graph);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new IllegalStateException("Can't init " + this.impl.getName(), e);
                }
            }

            @Override
            public Stream<Triple> apply(Graph g) {
                TransformationModel r = this.create(g);
                r.perform();
                return r.uncertainTriples();
            }

            @Override
            public boolean test(Graph g) {
                return this.create(g).test();
            }

            @Override
            public String id() {
                if (DefaultMaker.class.getPackage().equals(this.impl.getPackage())) {
                    return this.impl.getSimpleName();
                }
                return this.impl.getName();
            }

            public boolean equals(Object o) {
                return this == o || o instanceof DefaultMaker && this.impl.equals(((DefaultMaker)o).impl);
            }

            public int hashCode() {
                return this.impl.hashCode();
            }

            public String toString() {
                return String.format("DefaultMaker{impl=%s}", this.impl);
            }
        }
    }
}

