/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.transforms;

import com.github.owlcs.ontapi.jena.OntVocabulary;
import com.github.owlcs.ontapi.jena.utils.Graphs;
import com.github.owlcs.ontapi.jena.utils.Iter;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import com.github.owlcs.ontapi.jena.vocabulary.RDF;
import com.github.owlcs.ontapi.transforms.TransformationModel;
import java.util.List;
import org.apache.jena.graph.Graph;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.util.iterator.ExtendedIterator;

public class OWLIDTransform
extends TransformationModel {
    public OWLIDTransform(Graph graph) {
        super(graph, OntVocabulary.Factory.DUMMY);
    }

    @Override
    public void perform() {
        Model m = this.getWorkModel();
        Resource ontology = Graphs.ontologyNode(this.getQueryModel().getGraph()).map(arg_0 -> ((Model)m).getRDFNode(arg_0)).map(RDFNode::asResource).orElseGet(() -> m.createResource(OWL.Ontology));
        ExtendedIterator other = this.listStatements(null, RDF.type, (RDFNode)OWL.Ontology).mapWith(Statement::getSubject).filterDrop(arg_0 -> ((Resource)ontology).equals(arg_0));
        List rest = Iter.flatMap(other, o -> this.listStatements((Resource)o, null, null)).toList();
        rest.forEach(s -> ontology.addProperty(s.getPredicate(), s.getObject()));
        m.remove(rest);
    }
}

