/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.transforms;

import com.github.owlcs.ontapi.jena.utils.Iter;
import com.github.owlcs.ontapi.jena.utils.Models;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import com.github.owlcs.ontapi.jena.vocabulary.RDF;
import com.github.owlcs.ontapi.transforms.TransformationModel;
import com.github.owlcs.ontapi.transforms.vocabulary.AVC;
import com.github.owlcs.ontapi.transforms.vocabulary.DEPRECATED;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Graph;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.vocabulary.RDFS;

public class OWLCommonTransform
extends TransformationModel {
    private static final RDFDatatype NON_NEGATIVE_INTEGER = XSDDatatype.XSDnonNegativeInteger;
    private static final Map<Property, Property> QUALIFIED_CARDINALITY_REPLACEMENT = Collections.unmodifiableMap(new HashMap<Property, Property>(){
        {
            this.put(OWL.cardinality, OWL.qualifiedCardinality);
            this.put(OWL.maxCardinality, OWL.maxQualifiedCardinality);
            this.put(OWL.minCardinality, OWL.minQualifiedCardinality);
        }
    });
    private static final Set<Property> DEPRECATED_OWL_FACETS = Stream.of(DEPRECATED.OWL.maxExclusive, DEPRECATED.OWL.maxInclusive, DEPRECATED.OWL.minExclusive, DEPRECATED.OWL.minInclusive).collect(Iter.toUnmodifiableSet());
    private static Set<Property> CARDINALITY_PREDICATES = Stream.of(OWL.cardinality, OWL.qualifiedCardinality, OWL.maxCardinality, OWL.maxQualifiedCardinality, OWL.minCardinality, OWL.minQualifiedCardinality).collect(Iter.toUnmodifiableSet());
    private static List<Resource> ANNOTATION_TYPES = Stream.of(OWL.Axiom, OWL.Annotation).collect(Iter.toUnmodifiableList());
    private boolean processIndividuals;

    public OWLCommonTransform(Graph graph) {
        this(graph, false);
    }

    protected OWLCommonTransform(Graph graph, boolean processIndividuals) {
        super(graph);
        this.processIndividuals = processIndividuals;
    }

    protected static boolean isQualified(Resource r) {
        return r.hasProperty(OWL.onClass) || r.hasProperty(OWL.onDataRange);
    }

    private static Literal asNonNegativeIntegerLiteral(Literal n) {
        return n.getModel().createTypedLiteral(n.asLiteral().getLexicalForm(), NON_NEGATIVE_INTEGER);
    }

    @Override
    public void perform() {
        this.fixEntities();
        this.fixProperties();
        this.fixPropertyChains();
        this.fixNegativeAssertionsAndAnnotations();
        this.fixExpressions();
        this.fixClassExpressions();
        this.fixDataRanges();
        if (this.processIndividuals) {
            this.fixNamedIndividuals();
        }
    }

    protected void fixEntities() {
        this.replacePredicates(RDF.type, DEPRECATED.OWL.declaredAs);
    }

    protected void fixProperties() {
        this.changeType(DEPRECATED.OWL.AntisymmetricProperty, OWL.AsymmetricProperty);
        this.changeType(OWL.OntologyProperty, OWL.AnnotationProperty);
        Iter.flatMap(Iter.of(new Resource[]{OWL.InverseFunctionalProperty, OWL.TransitiveProperty, OWL.SymmetricProperty, OWL.AsymmetricProperty, OWL.ReflexiveProperty, OWL.IrreflexiveProperty}), p -> this.listStatements(null, RDF.type, (RDFNode)p)).forEachRemaining(s -> this.declare(s.getSubject(), OWL.ObjectProperty));
        Iter.flatMap(Iter.of(new Resource[]{OWL.ObjectProperty, OWL.FunctionalProperty, OWL.InverseFunctionalProperty, OWL.TransitiveProperty, OWL.DatatypeProperty, OWL.AnnotationProperty, OWL.OntologyProperty}), p -> this.listStatements(null, RDF.type, (RDFNode)p)).forEachRemaining(s -> this.undeclare(s.getSubject(), RDF.Property));
        Model m = this.getWorkModel();
        this.listStatements(null, RDF.type, (RDFNode)DEPRECATED.OWL.DataProperty).toList().forEach(s -> m.remove(s).add(s.getSubject(), RDF.type, (RDFNode)OWL.DatatypeProperty));
        this.replacePredicates(OWL.propertyDisjointWith, DEPRECATED.OWL.disjointObjectProperties, DEPRECATED.OWL.disjointDataProperties);
        this.replacePredicates(OWL.equivalentProperty, DEPRECATED.OWL.equivalentObjectProperty, DEPRECATED.OWL.equivalentDataProperty);
        this.replacePredicates(RDFS.domain, DEPRECATED.OWL.objectPropertyDomain, DEPRECATED.OWL.dataPropertyDomain);
        this.replacePredicates(RDFS.range, DEPRECATED.OWL.objectPropertyRange, DEPRECATED.OWL.dataPropertyRange);
        this.replacePredicates(RDFS.subPropertyOf, DEPRECATED.OWL.subObjectPropertyOf, DEPRECATED.OWL.subDataPropertyOf);
        this.changeType(DEPRECATED.OWL.NegativeDataPropertyAssertion, OWL.NegativePropertyAssertion);
        this.changeType(DEPRECATED.OWL.NegativeObjectPropertyAssertion, OWL.NegativePropertyAssertion);
    }

    protected void fixNegativeAssertionsAndAnnotations() {
        Model m = this.getWorkModel();
        Iter.flatMap(Iter.of(new Property[]{DEPRECATED.RDF.subject, DEPRECATED.OWL.subject}), p -> this.listStatements(null, (Property)p, null)).toList().forEach(s -> {
            Resource r = s.getSubject();
            Property p = this.getSourceReplacement(r);
            if (p == null) {
                return;
            }
            m.remove(s).add(r, p, s.getObject());
        });
        Iter.flatMap(Iter.of(new Property[]{DEPRECATED.RDF.predicate, DEPRECATED.OWL.predicate}), p -> this.listStatements(null, (Property)p, null)).toList().forEach(s -> {
            Resource r = s.getSubject();
            Property p = this.getPredicateReplacement(r);
            m.remove(s).add(r, p, s.getObject());
        });
        Iter.flatMap(Iter.of(new Property[]{DEPRECATED.RDF.object, DEPRECATED.OWL.object}), p -> this.listStatements(null, (Property)p, null)).toList().forEach(s -> {
            Resource r = s.getSubject();
            Property p = this.getObjectReplacement(r, s.getObject());
            m.remove(s).add(r, p, s.getObject());
        });
    }

    private Property getSourceReplacement(Resource r) {
        if (this.hasType(r, OWL.NegativePropertyAssertion)) {
            return OWL.sourceIndividual;
        }
        if (this.hasAnyType(r, ANNOTATION_TYPES)) {
            return OWL.annotatedSource;
        }
        return null;
    }

    private Property getPredicateReplacement(Resource r) {
        if (this.hasType(r, OWL.NegativePropertyAssertion)) {
            return OWL.assertionProperty;
        }
        if (this.hasAnyType(r, ANNOTATION_TYPES)) {
            return OWL.annotatedProperty;
        }
        return null;
    }

    private Property getObjectReplacement(Resource r, RDFNode o) {
        if (this.hasType(r, OWL.NegativePropertyAssertion)) {
            return o.isLiteral() ? OWL.targetValue : OWL.targetIndividual;
        }
        if (this.hasAnyType(r, ANNOTATION_TYPES)) {
            return OWL.annotatedTarget;
        }
        return null;
    }

    protected void fixDataRanges() {
        this.changeType(OWL.DataRange, RDFS.Datatype);
        Model m = this.getWorkModel();
        this.listStatements(null, RDF.type, (RDFNode)RDFS.Datatype).mapWith(Statement::getSubject).forEachRemaining(r -> r.listProperties(DEPRECATED.OWL.dataComplementOf).toList().forEach(s -> m.remove(s).add(s.getSubject(), OWL.datatypeComplementOf, s.getObject())));
        this.listStatements(null, OWL.datatypeComplementOf, null).mapWith(Statement::getSubject).toList().forEach(s -> {
            this.declare((Resource)s, RDFS.Datatype);
            this.moveToEquivalentClass((Resource)s, OWL.datatypeComplementOf, RDFS.Datatype);
        });
        this.listStatements(null, RDF.type, (RDFNode)RDFS.Datatype).mapWith(Statement::getSubject).toList().forEach(this::fixDatatype);
    }

    protected void fixDatatype(Resource r) {
        Resource anon;
        Model m = this.getWorkModel();
        r.listProperties(OWL.onDataRange).toList().forEach(s -> {
            RDFNode o = s.getObject();
            if (o.isURIResource()) {
                m.remove(s).add(s.getSubject(), OWL.onDatatype, s.getObject());
            } else if (o.isAnon()) {
                Resource auto = AVC.randomIRI().inModel(m);
                m.remove(s).add(s.getSubject(), OWL.onDatatype, (RDFNode)auto);
                auto.addProperty(OWL.equivalentClass, o);
            }
        });
        if (r.isURIResource()) {
            List list = r.listProperties().filterKeep(s -> s.getPredicate().equals(OWL.onDatatype) || DEPRECATED_OWL_FACETS.contains(s.getPredicate())).toList();
            if (list.isEmpty()) {
                return;
            }
            anon = m.createResource(RDFS.Datatype);
            list.forEach(s -> m.remove(s).add(anon, s.getPredicate(), s.getObject()));
            r.addProperty(OWL.equivalentClass, (RDFNode)anon);
        } else if (r.isAnon()) {
            anon = r;
        } else {
            return;
        }
        Iter.flatMap(Iter.create(DEPRECATED_OWL_FACETS), arg_0 -> ((Resource)anon).listProperties(arg_0)).toList().forEach(s -> {
            Property p = m.getProperty("http://www.w3.org/2001/XMLSchema#" + s.getPredicate().getLocalName());
            Resource f = m.createResource().addProperty(p, s.getObject());
            m.add(s.getSubject(), OWL.withRestrictions, (RDFNode)m.createList(new RDFNode[]{f})).remove(s);
        });
    }

    private void replacePredicates(Property newPredicate, Property ... oldPredicates) {
        Model m = this.getWorkModel();
        Iter.flatMap(Iter.of(oldPredicates), p -> this.listStatements(null, (Property)p, null)).toList().forEach(s -> m.remove(s).add(s.getSubject(), newPredicate, s.getObject()));
    }

    public void fixPropertyChains() {
        Model m = this.getWorkModel();
        this.listStatements(null, DEPRECATED.OWL.propertyChain, null).toList().forEach(s -> m.remove(s).add(s.getSubject(), OWL.propertyChainAxiom, s.getObject()));
        this.listStatements(null, OWL.propertyChainAxiom, null).mapWith(Statement::getSubject).filterKeep(s -> s.isAnon() && s.hasProperty(RDFS.subPropertyOf) && s.getPropertyResourceValue(RDFS.subPropertyOf).isURIResource() && s.getPropertyResourceValue(OWL.propertyChainAxiom).canAs(RDFList.class)).toSet().forEach(s -> {
            Resource p = s.getRequiredProperty(RDFS.subPropertyOf).getResource();
            Resource list = s.getRequiredProperty(OWL.propertyChainAxiom).getResource();
            m.add(p, OWL.propertyChainAxiom, (RDFNode)list).removeAll(s, RDFS.subPropertyOf, null).removeAll(s, OWL.propertyChainAxiom, null);
        });
        this.listStatements(null, RDF.type, (RDFNode)RDF.List).mapWith(Statement::getSubject).filterKeep(x -> x.isAnon() && x.hasProperty(RDFS.subPropertyOf)).toList().forEach(s -> {
            Statement p = s.getRequiredProperty(RDFS.subPropertyOf);
            RDFList list = (RDFList)s.as(RDFList.class);
            p.getResource().addProperty(OWL.propertyChainAxiom, (RDFNode)m.createList((Iterator)list.iterator()));
            m.remove(p);
            Models.getAssociatedStatements((Resource)list).forEach(arg_0 -> ((Model)m).remove(arg_0));
        });
    }

    protected void fixClassExpressions() {
        this.listStatements(null, OWL.complementOf, null).mapWith(Statement::getSubject).toList().forEach(s -> {
            this.declare((Resource)s, OWL.Class);
            this.moveToEquivalentClass((Resource)s, OWL.complementOf, OWL.Class);
        });
        this.fixRestrictions();
    }

    protected void fixExpressions() {
        Iter.flatMap(Iter.of(new Resource[]{OWL.DataRange, RDFS.Datatype, OWL.Restriction, OWL.Class}), p -> this.listStatements(null, RDF.type, (RDFNode)p)).forEachRemaining(s -> this.undeclare(s.getSubject(), RDFS.Class));
        Iter.of(new Property[]{OWL.unionOf, OWL.intersectionOf, OWL.oneOf}).forEachRemaining(p -> this.listStatements(null, (Property)p, null).mapWith(Statement::getSubject).filterKeep(RDFNode::isURIResource).toSet().forEach(s -> this.moveToEquivalentClass((Resource)s, (Property)p, null)));
    }

    protected void moveToEquivalentClass(Resource subject, Property predicate, Resource type) {
        if (subject.isAnon()) {
            return;
        }
        List statements = this.listStatements(subject, predicate, null).toList();
        if (statements.isEmpty()) {
            return;
        }
        Model m = this.getWorkModel();
        Resource newRoot = type != null ? m.createResource(type) : m.createResource();
        m.add(subject, OWL.equivalentClass, (RDFNode)newRoot);
        statements.forEach(s -> newRoot.addProperty(s.getPredicate(), s.getObject()));
        m.remove(statements);
    }

    protected void fixRestrictions() {
        Model m = this.getWorkModel();
        this.listStatements(null, RDF.type, (RDFNode)OWL.Restriction).mapWith(Statement::getSubject).forEachRemaining(this::fixRestriction);
        this.listStatements(null, RDF.type, (RDFNode)DEPRECATED.OWL.SelfRestriction).toList().forEach(s -> m.remove(s).add(s.getSubject(), RDF.type, (RDFNode)OWL.Restriction).add(s.getSubject(), OWL.hasSelf, (RDFNode)Models.TRUE));
        Iter.of(new Resource[]{DEPRECATED.OWL.DataRestriction, DEPRECATED.OWL.ObjectRestriction}).forEachRemaining(type -> this.listStatements(null, RDF.type, (RDFNode)type).toList().forEach(s -> m.remove(s).add(s.getSubject(), RDF.type, (RDFNode)OWL.Restriction)));
    }

    protected void fixRestriction(Resource r) {
        this.fixCardinalityRestriction(r);
    }

    protected void fixCardinalityRestriction(Resource r) {
        Model m = this.getWorkModel();
        CARDINALITY_PREDICATES.forEach(p -> r.listProperties(p).filterKeep(s -> s.getObject().isLiteral()).filterDrop(s -> NON_NEGATIVE_INTEGER.equals(s.getLiteral().getDatatype())).toList().forEach(s -> m.remove(s).add(s.getSubject(), s.getPredicate(), (RDFNode)OWLCommonTransform.asNonNegativeIntegerLiteral(s.getLiteral()))));
        if (OWLCommonTransform.isQualified(r)) {
            QUALIFIED_CARDINALITY_REPLACEMENT.forEach((a, b) -> r.listProperties(a).toList().forEach(s -> m.remove(s).add(r, b, s.getObject())));
        }
    }

    protected void fixNamedIndividuals() {
        Set<Resource> forbidden = this.builtins.getSystemResources();
        this.listStatements(null, RDF.type, null).filterKeep(s -> s.getSubject().isURIResource() && s.getObject().isResource()).filterDrop(s -> forbidden.contains(s.getObject().asResource())).toList().forEach(s -> this.declare(s.getSubject(), OWL.NamedIndividual));
    }
}

