/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.transforms;

import com.github.owlcs.ontapi.jena.utils.Iter;
import com.github.owlcs.ontapi.jena.utils.Models;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import com.github.owlcs.ontapi.jena.vocabulary.RDF;
import com.github.owlcs.ontapi.jena.vocabulary.SWRL;
import com.github.owlcs.ontapi.transforms.BaseDeclarator;
import com.github.owlcs.ontapi.transforms.vocabulary.AVC;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.jena.graph.Graph;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDFS;

public class ManifestDeclarator
extends BaseDeclarator {
    private static final List<Resource> SWRL_ARG1_ATOM_TYPES = Stream.of(SWRL.ClassAtom, SWRL.DatavaluedPropertyAtom, SWRL.IndividualPropertyAtom, SWRL.DifferentIndividualsAtom, SWRL.SameIndividualAtom).collect(Iter.toUnmodifiableList());
    private static final List<Resource> SWRL_ARG2_ATOM_TYPES = Stream.of(SWRL.IndividualPropertyAtom, SWRL.DifferentIndividualsAtom, SWRL.SameIndividualAtom).collect(Iter.toUnmodifiableList());
    protected final Set<? extends RDFNode> forbiddenClassCandidates = this.collectForbiddenClassCandidates();

    public ManifestDeclarator(Graph graph) {
        super(graph);
    }

    @Override
    public void perform() {
        this.parseAnnotations();
        this.parseClassExpressions();
        this.parseDataRangeExpressions();
        this.parseOneOfExpression();
        this.parseObjectPropertyExpressions();
        this.parseObjectOrDataProperties();
        this.parseIndividuals();
        this.parseClassAssertions();
        this.parseSWRL();
    }

    protected void parseAnnotations() {
        this.listStatements(null, OWL.annotatedProperty, (RDFNode)RDF.type).mapWith(Statement::getSubject).filterKeep(s -> s.isAnon() && (s.hasProperty(RDF.type, (RDFNode)OWL.Annotation) || s.hasProperty(RDF.type, (RDFNode)OWL.Axiom))).forEachRemaining(r -> {
            Resource source = this.getObjectResource((Resource)r, OWL.annotatedSource);
            Resource target = this.getObjectResource((Resource)r, OWL.annotatedTarget);
            if (source == null || target == null) {
                return;
            }
            this.declare(source, target);
        });
    }

    protected void parseClassExpressions() {
        Iter.flatMap(Iter.flatMap(Iter.of(new Property[]{RDFS.subClassOf, OWL.disjointWith}), p -> this.listStatements(null, (Property)p, null)), s -> Iter.of(new RDFNode[]{s.getSubject(), s.getObject()})).filterKeep(RDFNode::isResource).mapWith(RDFNode::asResource).toSet().forEach(this::declareClass);
        Iter.flatMap(this.listStatements(null, OWL.complementOf, null), s -> Iter.of(new RDFNode[]{s.getSubject(), s.getObject()})).filterKeep(RDFNode::isResource).mapWith(RDFNode::asResource).toSet().forEach(this::declareClass);
        Iter.flatMap(this.listStatements(null, RDF.type, (RDFNode)OWL.AllDisjointClasses).filterKeep(s -> s.getSubject().isAnon()), s -> this.members(s.getSubject(), OWL.members)).toSet().forEach(this::declareClass);
        Iter.flatMap(this.listStatements(null, OWL.disjointUnionOf, null).mapWith(Statement::getSubject).filterKeep(RDFNode::isURIResource), x -> Iter.concat(Iter.of(x), this.members((Resource)x, OWL.disjointUnionOf))).toSet().forEach(this::declareClass);
        this.listStatements(null, OWL.hasKey, null).mapWith(Statement::getSubject).forEachRemaining(this::declareClass);
        this.listStatements(null, OWL.onClass, null).filterKeep(s -> s.getSubject().isAnon() && s.getObject().isResource() && s.getSubject().hasProperty(OWL.onProperty)).forEachRemaining(s -> this.declare(s.getSubject(), OWL.Restriction).declareClass(s.getResource()));
    }

    protected void parseDataRangeExpressions() {
        this.listStatements(null, OWL.datatypeComplementOf, null).filterKeep(s -> s.getObject().isResource()).forEachRemaining(s -> this.declareDatatype(s.getSubject()).declareDatatype(s.getResource()));
        this.listStatements(null, OWL.onDatatype, null).filterKeep(s -> s.getObject().isURIResource() && s.getSubject().hasProperty(OWL.withRestrictions) && s.getSubject().getProperty(OWL.withRestrictions).getObject().canAs(RDFList.class)).forEachRemaining(s -> this.declareDatatype(s.getSubject()).declareDatatype(s.getResource()));
        this.listStatements(null, OWL.onProperties, null).filterKeep(s -> s.getSubject().isAnon() && s.getObject().canAs(RDFList.class)).mapWith(Statement::getSubject).forEachRemaining(r -> {
            Iter.flatMap(Iter.of(new Property[]{OWL.allValuesFrom, OWL.someValuesFrom}), p -> this.listStatements((Resource)r, (Property)p, null)).mapWith(Statement::getObject).filterKeep(RDFNode::isAnon).forEachRemaining(n -> this.declareDatatype(n.asResource()));
            this.declare((Resource)r, OWL.Restriction);
        });
        this.listStatements(null, OWL.onDataRange, null).filterKeep(s -> s.getSubject().isAnon() && s.getSubject().hasProperty(OWL.onProperty) && s.getObject().isResource()).forEachRemaining(s -> this.declare(s.getSubject(), OWL.Restriction).declareDatatype(s.getResource()));
    }

    protected void parseOneOfExpression() {
        this.listStatements(null, OWL.oneOf, null).filterKeep(s -> s.getSubject().isAnon() && s.getObject().canAs(RDFList.class)).forEachRemaining(s -> {
            List values = ((RDFList)s.getObject().as(RDFList.class)).asJavaList();
            if (values.isEmpty()) {
                return;
            }
            if (Iter.allMatch(Iter.create(values), RDFNode::isLiteral)) {
                this.declareDatatype(s.getSubject());
            } else {
                this.declareClass(s.getSubject());
                values.forEach(v -> this.declareIndividual(v.asResource()));
            }
        });
    }

    protected void parseObjectPropertyExpressions() {
        Iter.flatMap(Iter.of(new Resource[]{OWL.InverseFunctionalProperty, OWL.ReflexiveProperty, OWL.IrreflexiveProperty, OWL.SymmetricProperty, OWL.AsymmetricProperty, OWL.TransitiveProperty}), p -> this.listStatements(null, RDF.type, (RDFNode)p)).mapWith(Statement::getSubject).toSet().forEach(this::declareObjectProperty);
        Iter.flatMap(this.listStatements(null, OWL.inverseOf, null).filterKeep(s -> s.getObject().isURIResource()), s -> Iter.of(new Resource[]{s.getSubject(), s.getResource()})).toSet().forEach(this::declareObjectProperty);
        Iter.flatMap(this.listStatements(null, OWL.propertyChainAxiom, null), this::subjectAndObjects).toSet().forEach(this::declareObjectProperty);
        this.listStatements(null, OWL.hasSelf, null).filterKeep(s -> Models.TRUE.equals((Object)s.getObject())).mapWith(Statement::getSubject).filterKeep(s -> s.isAnon() && s.hasProperty(OWL.onProperty)).forEachRemaining(s -> {
            Resource p = this.getObjectResource((Resource)s, OWL.onProperty);
            if (p == null) {
                return;
            }
            this.declareObjectProperty(p).declare((Resource)s, OWL.Restriction);
        });
    }

    protected void parseObjectOrDataProperties() {
        this.listStatements(null, OWL.hasValue, null).forEachRemaining(s -> {
            Resource p = this.getObjectResource(s.getSubject(), OWL.onProperty);
            if (p == null) {
                return;
            }
            this.declare(s.getSubject(), OWL.Restriction);
            if (s.getObject().isLiteral()) {
                this.declareDataProperty(p);
            } else {
                this.declareIndividual(s.getResource()).declareObjectProperty(p);
            }
        });
        this.listStatements(null, RDF.type, (RDFNode)OWL.NegativePropertyAssertion).mapWith(Statement::getSubject).filterKeep(RDFNode::isAnon).forEachRemaining(r -> {
            Resource source = this.getObjectResource((Resource)r, OWL.sourceIndividual);
            Resource prop = this.getObjectResource((Resource)r, OWL.assertionProperty);
            if (source == null || prop == null) {
                return;
            }
            Resource i = this.getObjectResource((Resource)r, OWL.targetIndividual);
            if (i == null && this.getObjectLiteral((Resource)r, OWL.targetValue) == null) {
                return;
            }
            this.declareIndividual(source);
            if (i != null) {
                this.declareObjectProperty(prop).declareIndividual(i);
            } else {
                this.declareDataProperty(prop);
            }
        });
    }

    protected void parseIndividuals() {
        Iter.flatMap(Iter.flatMap(Iter.of(new Property[]{OWL.sameAs, OWL.differentFrom}), p -> this.listStatements(null, (Property)p, null)), s -> Iter.of(new RDFNode[]{s.getSubject(), s.getObject()})).filterKeep(RDFNode::isResource).mapWith(RDFNode::asResource).toSet().forEach(this::declareIndividual);
        Iter.flatMap(this.listStatements(null, RDF.type, (RDFNode)OWL.AllDifferent).filterKeep(s -> s.getSubject().isAnon()).mapWith(Statement::getSubject), this::disjointIndividuals).toSet().forEach(this::declareIndividual);
    }

    private ExtendedIterator<Resource> disjointIndividuals(Resource s) {
        return Iter.flatMap(Iter.of(new Property[]{OWL.members, OWL.distinctMembers}), p -> this.members(s, (Property)p));
    }

    protected Set<Resource> collectForbiddenClassCandidates() {
        HashSet<Resource> res = new HashSet<Resource>(this.builtins.getSystemResources());
        res.add(AVC.AnonymousIndividual);
        res.removeAll(this.builtins.getBuiltinClasses());
        return res;
    }

    protected void parseClassAssertions() {
        this.listStatements(null, RDF.type, null).filterKeep(s -> s.getObject().isResource() && !this.forbiddenClassCandidates.contains(s.getObject())).toSet().forEach(s -> this.declareIndividual(s.getSubject()).declareClass(s.getResource()));
    }

    protected void parseSWRL() {
        this.processSWRL(SWRL.argument1, s -> s.getSubject().isAnon() && SWRL_ARG1_ATOM_TYPES.stream().anyMatch(t -> this.hasType(s.getSubject(), (Resource)t)), r -> !this.hasType((Resource)r, SWRL.Variable), this::declareIndividual);
        this.processSWRL(SWRL.argument2, s -> s.getSubject().isAnon() && SWRL_ARG2_ATOM_TYPES.stream().anyMatch(t -> this.hasType(s.getSubject(), (Resource)t)), r -> !this.hasType((Resource)r, SWRL.Variable), this::declareIndividual);
        this.processSWRL(SWRL.classPredicate, s -> s.getSubject().isAnon() && this.hasType(s.getSubject(), SWRL.ClassAtom), null, this::declareClass);
        this.processSWRL(SWRL.dataRange, s -> s.getSubject().isAnon() && this.hasType(s.getSubject(), SWRL.DataRangeAtom), null, this::declareDatatype);
        this.processSWRL(SWRL.propertyPredicate, s -> s.getSubject().isAnon() && this.hasType(s.getSubject(), SWRL.IndividualPropertyAtom), null, this::declareObjectProperty);
        this.processSWRL(SWRL.propertyPredicate, s -> s.getSubject().isAnon() && this.hasType(s.getSubject(), SWRL.DatavaluedPropertyAtom), null, this::declareDataProperty);
    }

    protected void processSWRL(Property predicateToFind, Predicate<Statement> functionToFilter, Predicate<Resource> functionToCheck, Consumer<Resource> functionToDeclare) {
        this.listStatements(null, predicateToFind, null).filterKeep(functionToFilter).mapWith(Statement::getObject).filterKeep(RDFNode::isResource).mapWith(RDFNode::asResource).filterKeep(r -> functionToCheck == null || functionToCheck.test((Resource)r)).forEachRemaining(functionToDeclare);
    }
}

