/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.transforms;

import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.jena.utils.Graphs;
import com.github.owlcs.ontapi.transforms.GraphFilter;
import com.github.owlcs.ontapi.transforms.GraphStats;
import com.github.owlcs.ontapi.transforms.OWLCommonTransform;
import com.github.owlcs.ontapi.transforms.OWLDeclarationTransform;
import com.github.owlcs.ontapi.transforms.OWLIDTransform;
import com.github.owlcs.ontapi.transforms.OWLRecursiveTransform;
import com.github.owlcs.ontapi.transforms.RDFSTransform;
import com.github.owlcs.ontapi.transforms.SWRLTransform;
import com.github.owlcs.ontapi.transforms.Transform;
import com.github.owlcs.ontapi.transforms.TransformException;
import com.github.owlcs.ontapi.transforms.TransformationModel;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.graph.Factory;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphEventManager;
import org.apache.jena.graph.GraphListener;
import org.apache.jena.graph.GraphUtil;
import org.apache.jena.graph.Triple;
import org.apache.jena.shared.JenaException;
import org.apache.jena.sparql.util.graph.GraphListenerBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphTransformers
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphTransformers.class);
    private static final long serialVersionUID = -1L;
    protected static GraphTransformers instance = new GraphTransformers().put(OWLIDTransform.class).put(OWLRecursiveTransform.class).put(RDFSTransform.class).put(OWLCommonTransform.class).put(OWLDeclarationTransform.class).put(SWRLTransform.class);
    protected Map<String, Transform> set = new LinkedHashMap<String, Transform>();
    protected GraphFilter filter = GraphFilter.TRUE;

    public static GraphTransformers set(GraphTransformers store) {
        Objects.requireNonNull(store, "Null converter store specified.");
        GraphTransformers prev = instance;
        instance = store;
        return prev;
    }

    public static GraphTransformers get() {
        return instance;
    }

    public static Graph convert(Graph from) throws TransformException {
        Graph res = Factory.createGraphMem();
        GraphUtil.addInto((Graph)res, (Graph)from);
        GraphTransformers.get().transform(res);
        return res;
    }

    public GraphTransformers copy() {
        GraphTransformers res = this.empty();
        res.set.putAll(this.set);
        return res;
    }

    protected GraphTransformers empty() {
        GraphTransformers res = new GraphTransformers();
        res.filter = this.filter;
        return res;
    }

    public Optional<Transform> get(String id) {
        return this.set.containsKey(id) ? Optional.of(this.set.get(id)) : Optional.empty();
    }

    protected GraphTransformers put(Class<? extends TransformationModel> impl) {
        return this.addLast(Transform.Factory.create(impl));
    }

    public GraphTransformers addFirst(Transform tf) {
        Objects.requireNonNull(tf);
        GraphTransformers res = this.empty();
        res.set.put(tf.id(), tf);
        res.set.putAll(this.set);
        return res;
    }

    public GraphTransformers addLast(Transform tf) {
        Objects.requireNonNull(tf);
        GraphTransformers res = this.copy();
        res.set.put(tf.id(), tf);
        return res;
    }

    public GraphTransformers insertAfter(String id, Transform tf) {
        Objects.requireNonNull(tf);
        if (!this.set.containsKey(id)) {
            throw new IllegalArgumentException("Can't find " + id);
        }
        GraphTransformers res = this.empty();
        this.set.keySet().forEach(i -> {
            res.set.put((String)i, this.set.get(i));
            if (Objects.equals(i, id)) {
                res.set.put(tf.id(), tf);
            }
        });
        return res;
    }

    public GraphTransformers removeFirst() {
        if (this.set.isEmpty()) {
            throw new IllegalStateException("Nothing to remove");
        }
        return this.delete((String)this.set.keySet().toArray()[0]);
    }

    public GraphTransformers removeLast() {
        if (this.set.isEmpty()) {
            throw new IllegalStateException("Nothing to remove");
        }
        return this.delete((String)this.set.keySet().toArray()[this.set.size() - 1]);
    }

    public GraphTransformers remove(String id) {
        if (this.set.isEmpty()) {
            throw new IllegalStateException("Nothing to remove");
        }
        if (!this.set.containsKey(id)) {
            throw new IllegalArgumentException("Can't find " + id);
        }
        return this.delete(id);
    }

    protected GraphTransformers delete(String id) {
        GraphTransformers res = this.copy();
        res.set.remove(id);
        return res;
    }

    public Stream<Transform> transforms() {
        return this.set.values().stream();
    }

    public GraphTransformers setFilter(GraphFilter f) {
        GraphTransformers res = this.copy();
        res.filter = Objects.requireNonNull(f, "Null filter");
        return res;
    }

    public GraphFilter getFilter() {
        return this.filter;
    }

    public GraphStats transform(Graph graph) throws TransformException {
        return this.transform(graph, new HashSet<Graph>());
    }

    public GraphStats transform(Graph graph, Set<Graph> skip) throws TransformException {
        List children = Graphs.toUnion(graph).getUnderlying().listGraphs().toList();
        Graph base = Graphs.getBase(graph);
        GraphStats res = new GraphStats(base);
        for (Graph g : children) {
            try {
                res.putStats(this.transform(g, skip));
            }
            catch (StoreException t) {
                throw t.putParent(graph);
            }
        }
        if (skip.contains(base)) {
            return res;
        }
        if (!this.getFilter().test(graph)) {
            skip.add(base);
            return res;
        }
        this.transforms().filter(x -> x.test(graph)).forEach(x -> {
            Set<Triple> uncertainTriples;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Process <%s> on <%s>", x.id(), Graphs.getName(base)));
            }
            GraphEventManager events = base.getEventManager();
            TransformListener listener = this.createTrackListener();
            try {
                events.register((GraphListener)listener);
                uncertainTriples = x.apply(graph).collect(Collectors.toSet());
            }
            catch (JenaException e) {
                throw new StoreException((Transform)x, (Throwable)e);
            }
            finally {
                events.unregister((GraphListener)listener);
            }
            res.putTriples((Transform)x, listener.getAdded(), listener.getDeleted(), uncertainTriples);
        });
        skip.add(base);
        return res;
    }

    protected TransformListener createTrackListener() {
        return new TransformListener();
    }

    public boolean equals(Object o) {
        return this == o || o instanceof GraphTransformers && this.set.equals(((GraphTransformers)o).set) && this.filter.equals(((GraphTransformers)o).filter);
    }

    public int hashCode() {
        return Objects.hash(this.set, this.filter);
    }

    public static class StoreException
    extends TransformException {
        protected final Transform transform;
        protected Graph parent;

        protected StoreException(Transform transform, Throwable cause) {
            super(cause);
            this.transform = OntApiException.notNull(transform, "Null transform");
        }

        protected StoreException putParent(Graph graph) {
            this.parent = OntApiException.notNull(graph, "Null parent graph");
            return this;
        }

        public String getMessage() {
            StringBuilder res = new StringBuilder();
            if (this.parent != null) {
                res.append(Graphs.getName(this.parent)).append(" => ");
            }
            res.append(this.transform);
            Throwable cause = this.getCause();
            if (cause != null) {
                res.append(": ").append(cause.getMessage());
            }
            return res.toString();
        }
    }

    public static class TransformListener
    extends GraphListenerBase {
        private final Set<Triple> added = new HashSet<Triple>();
        private final Set<Triple> deleted = new HashSet<Triple>();

        protected void addEvent(Triple t) {
            this.added.add(t);
            this.deleted.remove(t);
        }

        protected void deleteEvent(Triple t) {
            this.added.remove(t);
            this.deleted.add(t);
        }

        public void notifyAddGraph(Graph g, Graph other) {
            other.find(Triple.ANY).forEachRemaining(this::addEvent);
        }

        public void notifyDeleteGraph(Graph g, Graph other) {
            other.find(Triple.ANY).forEachRemaining(this::deleteEvent);
        }

        public Set<Triple> getAdded() {
            return Collections.unmodifiableSet(this.added);
        }

        public Set<Triple> getDeleted() {
            return Collections.unmodifiableSet(this.deleted);
        }
    }
}

