/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.transforms;

import com.github.owlcs.ontapi.jena.utils.Iter;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import com.github.owlcs.ontapi.transforms.TransformationModel;
import com.github.owlcs.ontapi.transforms.vocabulary.AVC;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.graph.Graph;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDFS;

public abstract class BaseDeclarator
extends TransformationModel {
    private static final List<Property> RESTRICTION_PROPERTY_MARKERS = Stream.of(OWL.onProperty, OWL.allValuesFrom, OWL.someValuesFrom, OWL.hasValue, OWL.onClass, OWL.onDataRange, OWL.cardinality, OWL.qualifiedCardinality, OWL.maxCardinality, OWL.maxQualifiedCardinality, OWL.minCardinality, OWL.maxQualifiedCardinality, OWL.onProperties).collect(Iter.toUnmodifiableList());
    private static final List<Property> ANONYMOUS_CLASS_MARKERS = Stream.of(OWL.intersectionOf, OWL.oneOf, OWL.unionOf, OWL.complementOf).collect(Iter.toUnmodifiableList());
    private Set<String> datatypes;

    protected BaseDeclarator(Graph graph) {
        super(graph);
    }

    protected ExtendedIterator<Resource> subjectAndObjects(Statement s) {
        return Iter.concat(Iter.of(s.getSubject()), ((RDFList)s.getObject().as(RDFList.class)).iterator().filterKeep(RDFNode::isResource).mapWith(RDFNode::asResource));
    }

    protected ExtendedIterator<Resource> members(Resource subject, Property predicate) {
        return this.members(subject, predicate, Resource.class);
    }

    protected <X extends RDFNode> ExtendedIterator<X> members(Resource subject, Property predicate, Class<X> type) {
        return Iter.flatMap(subject.listProperties(predicate).mapWith(Statement::getObject).filterKeep(s -> s.canAs(RDFList.class)), m -> ((RDFList)m.as(RDFList.class)).iterator()).filterKeep(x -> x.canAs(type)).mapWith(x -> x.as(type));
    }

    protected Resource getObjectResource(Resource subject, Property predicate) {
        Statement res = subject.getProperty(predicate);
        return res != null && res.getObject().isResource() ? res.getObject().asResource() : null;
    }

    protected Literal getObjectLiteral(Resource subject, Property predicate) {
        Statement res = subject.getProperty(predicate);
        return res != null && res.getObject().isLiteral() ? res.getObject().asLiteral() : null;
    }

    protected boolean isClassExpression(Resource candidate) {
        return this.builtins.getBuiltinClasses().contains(candidate) || this.hasType(candidate, OWL.Class) || this.hasType(candidate, OWL.Restriction);
    }

    protected boolean isClass(Resource candidate) {
        return candidate.isURIResource() && this.hasType(candidate, OWL.Class) || this.builtins.getBuiltinClasses().contains(candidate);
    }

    protected boolean isDataRange(Resource candidate) {
        return this.builtins.getBuiltinDatatypes().contains(candidate) || this.hasType(candidate, RDFS.Datatype);
    }

    protected boolean isObjectPropertyExpression(Resource candidate) {
        return this.builtins.getBuiltinObjectProperties().contains(candidate) || this.hasType(candidate, OWL.ObjectProperty) || candidate.hasProperty(OWL.inverseOf);
    }

    protected boolean isDataProperty(Resource candidate) {
        return this.builtins.getBuiltinDatatypeProperties().contains(candidate) || this.hasType(candidate, OWL.DatatypeProperty);
    }

    protected boolean isAnnotationProperty(Resource candidate) {
        return this.builtins.getBuiltinAnnotationProperties().contains(candidate) || this.hasType(candidate, OWL.AnnotationProperty);
    }

    protected boolean isIndividual(Resource candidate) {
        return this.hasType(candidate, OWL.NamedIndividual) || this.hasType(candidate, AVC.AnonymousIndividual);
    }

    protected BaseDeclarator declareObjectProperty(Resource resource) {
        this.declareObjectProperty(resource, this.builtins.getBuiltinObjectProperties());
        return this;
    }

    protected BaseDeclarator declareDataProperty(Resource resource) {
        this.declareDataProperty(resource, this.builtins.getBuiltinDatatypeProperties());
        return this;
    }

    protected BaseDeclarator declareAnnotationProperty(Resource resource) {
        this.declareAnnotationProperty(resource, this.builtins.getBuiltinAnnotationProperties());
        return this;
    }

    protected void declareObjectProperty(Resource resource, Set<? extends Resource> builtIn) {
        if (resource.isAnon()) {
            this.undeclare(resource, OWL.ObjectProperty);
            return;
        }
        this.declare(resource, OWL.ObjectProperty, builtIn);
    }

    protected void declareDataProperty(Resource resource, Set<? extends Resource> builtIn) {
        this.declare(resource, OWL.DatatypeProperty, builtIn);
    }

    protected void declareAnnotationProperty(Resource resource, Set<? extends Resource> builtIn) {
        this.declare(resource, OWL.AnnotationProperty, builtIn);
    }

    protected BaseDeclarator declareIndividual(Resource resource) {
        if (resource.isAnon()) {
            this.undeclare(resource, OWL.NamedIndividual);
            this.declare(resource, AVC.AnonymousIndividual);
        } else {
            this.declare(resource, OWL.NamedIndividual);
        }
        return this;
    }

    protected BaseDeclarator declareDatatype(Resource resource) {
        this.declare(resource, RDFS.Datatype, this.builtins.getBuiltinDatatypes());
        return this;
    }

    protected BaseDeclarator declareDatatype(String uri) {
        if (uri == null || this.getBuiltinDatatypeURIs().contains(uri)) {
            return this;
        }
        this.declare(this.getWorkModel().createResource(uri), RDFS.Datatype);
        return this;
    }

    protected Set<String> getBuiltinDatatypeURIs() {
        return this.datatypes == null ? (this.datatypes = this.builtins.getBuiltinDatatypes().stream().map(Resource::getURI).collect(Collectors.toSet())) : this.datatypes;
    }

    protected boolean declareClass(Resource resource) {
        Resource type;
        if (this.builtins.getBuiltinClasses().contains(resource)) {
            return true;
        }
        if (this.builtins.getBuiltinDatatypes().contains(resource)) {
            return false;
        }
        Object object = resource.isURIResource() ? OWL.Class : (this.containsClassExpressionProperty(resource) ? OWL.Class : (type = this.containsRestrictionProperty(resource) ? OWL.Restriction : null));
        if (type != null) {
            this.declare(resource, type);
            return true;
        }
        return false;
    }

    protected boolean containsClassExpressionProperty(Resource candidate) {
        return this.hasAnyPredicate(candidate, ANONYMOUS_CLASS_MARKERS);
    }

    protected boolean containsRestrictionProperty(Resource candidate) {
        return this.hasAnyPredicate(candidate, RESTRICTION_PROPERTY_MARKERS);
    }

    protected void declare(Resource subject, Resource type, Set<? extends Resource> forbidden) {
        if (type == null || forbidden.contains(subject)) {
            return;
        }
        this.declare(subject, type);
    }

    @Override
    protected BaseDeclarator declare(Resource s, Resource t) {
        super.declare(s, t);
        return this;
    }
}

