/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.owlapi.objects.entity;

import com.github.owlcs.ontapi.owlapi.OWLObjectImpl;
import java.util.Objects;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class OWLDatatypeImpl
extends OWLObjectImpl
implements OWLDatatype {
    private final IRI iri;
    private final boolean top;
    private final boolean builtin;

    public OWLDatatypeImpl(IRI iri) {
        this.iri = Objects.requireNonNull(iri, "iri cannot be null");
        this.top = iri.equals((Object)OWLRDFVocabulary.RDFS_LITERAL.getIRI());
        this.builtin = this.top || OWL2Datatype.isBuiltIn((IRI)iri) || iri.equals((Object)OWLRDFVocabulary.RDF_PLAIN_LITERAL.getIRI());
    }

    public boolean isTopEntity() {
        return this.top;
    }

    public boolean isRDFPlainLiteral() {
        return this.iri.isPlainLiteral();
    }

    public String toStringID() {
        return this.iri.toString();
    }

    public IRI getIRI() {
        return this.iri;
    }

    public boolean isBuiltIn() {
        return this.builtin;
    }

    @Override
    protected Set<OWLEntity> getSignatureSet() {
        return OWLDatatypeImpl.createSet(this);
    }

    @Override
    public Set<OWLDatatype> getDatatypeSet() {
        return OWLDatatypeImpl.createSet(this);
    }

    public OWL2Datatype getBuiltInDatatype() {
        if (!this.builtin) {
            throw new OWLRuntimeException(this.iri + " is not a built-in datatype. The #getBuiltInDatatype() method should only be called on built-in datatypes.");
        }
        return OWL2Datatype.getDatatype((IRI)this.iri);
    }

    public boolean isDouble() {
        return this.iri.equals((Object)OWL2Datatype.XSD_DOUBLE.getIRI());
    }

    public boolean isFloat() {
        return this.iri.equals((Object)OWL2Datatype.XSD_FLOAT.getIRI());
    }

    public boolean isInteger() {
        return this.iri.equals((Object)OWL2Datatype.XSD_INTEGER.getIRI());
    }

    public boolean isString() {
        return this.iri.equals((Object)OWL2Datatype.XSD_STRING.getIRI());
    }

    public boolean isBoolean() {
        return this.iri.equals((Object)OWL2Datatype.XSD_BOOLEAN.getIRI());
    }

    public boolean isTopDatatype() {
        return this.top;
    }

    public boolean isOWLDatatype() {
        return true;
    }
}

