/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.owlapi.objects.entity;

import com.github.owlcs.ontapi.owlapi.OWLObjectImpl;
import com.github.owlcs.ontapi.owlapi.objects.ce.OWLObjectComplementOfImpl;
import java.io.Serializable;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.jena.rdf.model.Resource;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;

public class OWLClassImpl
extends OWLObjectImpl
implements OWLClass,
Serializable {
    private final IRI iri;
    private final boolean isThing;
    private final boolean isNothing;

    public OWLClassImpl(IRI iri) {
        this.iri = Objects.requireNonNull(iri, "iri cannot be null");
        this.isThing = this.getIRI().isThing();
        this.isNothing = this.getIRI().isNothing();
    }

    public static OWLClass fromResource(Resource r) {
        return new OWLClassImpl(IRI.create((String)Objects.requireNonNull(r.getURI(), "Not URI: " + r)));
    }

    public OWLClassExpression getObjectComplementOf() {
        return new OWLObjectComplementOfImpl((OWLClassExpression)this);
    }

    public String toStringID() {
        return this.iri.toString();
    }

    public IRI getIRI() {
        return this.iri;
    }

    public boolean isBuiltIn() {
        return this.isOWLThing() || this.isOWLNothing();
    }

    public boolean isOWLThing() {
        return this.isThing;
    }

    public boolean isOWLNothing() {
        return this.isNothing;
    }

    public OWLClassExpression getNNF() {
        return this;
    }

    public Set<OWLClassExpression> asConjunctSet() {
        return OWLClassImpl.createSet(this);
    }

    public Stream<OWLClassExpression> conjunctSet() {
        return Stream.of(this);
    }

    public boolean containsConjunct(@Nonnull OWLClassExpression ce) {
        return ce.equals(this);
    }

    public Set<OWLClassExpression> asDisjunctSet() {
        return OWLClassImpl.createSet(this);
    }

    public OWLClassExpression getComplementNNF() {
        return new OWLObjectComplementOfImpl((OWLClassExpression)this);
    }

    public Stream<OWLClassExpression> disjunctSet() {
        return Stream.of(this);
    }
}

