/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.owlapi.objects.entity;

import com.github.owlcs.ontapi.owlapi.objects.entity.OWLDatatypeImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.jena.rdf.model.Resource;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.vocab.OWL2Datatype;

public class OWLBuiltinDatatypeImpl
extends OWLDatatypeImpl {
    public static final Map<String, OWLDatatype> BUILTIN_OWL_DATATYPES = OWLBuiltinDatatypeImpl.createBuiltinsMap(OWLBuiltinDatatypeImpl::new);
    private final OWL2Datatype from;

    public OWLBuiltinDatatypeImpl(OWL2Datatype dt) {
        super(dt.getIRI());
        this.from = dt;
    }

    public static Map<String, OWLDatatype> createBuiltinsMap(Function<OWL2Datatype, OWLDatatype> map) {
        return Collections.unmodifiableMap(Arrays.stream(OWL2Datatype.values()).collect(Collectors.toMap(x -> x.getIRI().getIRIString(), map)));
    }

    public static OWLDatatype fromResource(Resource r) {
        return Objects.requireNonNull(BUILTIN_OWL_DATATYPES.get(Objects.requireNonNull(r.getURI(), "Not URI: " + r)), "Can't find builtin datatype for " + r);
    }

    @Override
    public OWL2Datatype getBuiltInDatatype() {
        return this.from;
    }

    @Override
    public boolean isString() {
        return this.from == OWL2Datatype.XSD_STRING;
    }

    @Override
    public boolean isInteger() {
        return this.from == OWL2Datatype.XSD_INTEGER;
    }

    @Override
    public boolean isFloat() {
        return this.from == OWL2Datatype.XSD_FLOAT;
    }

    @Override
    public boolean isDouble() {
        return this.from == OWL2Datatype.XSD_DOUBLE;
    }

    @Override
    public boolean isBoolean() {
        return this.from == OWL2Datatype.XSD_BOOLEAN;
    }

    @Override
    public boolean isRDFPlainLiteral() {
        return this.from == OWL2Datatype.RDF_PLAIN_LITERAL;
    }

    @Override
    public boolean isTopDatatype() {
        return this.from == OWL2Datatype.RDFS_LITERAL;
    }

    @Override
    public boolean isTopEntity() {
        return this.from == OWL2Datatype.RDFS_LITERAL;
    }

    @Override
    public boolean isBuiltIn() {
        return true;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OWLDatatype)) {
            return false;
        }
        OWLDatatype other = (OWLDatatype)obj;
        return this.from.getIRI().equals((Object)other.getIRI());
    }

    @Override
    public int compareTo(@Nullable OWLObject o) {
        if (o == null) {
            throw new NullPointerException("Object cannot be null in a #compareTo() call.");
        }
        int res = Integer.compare(this.typeIndex(), o.typeIndex());
        if (res != 0) {
            return res;
        }
        if (o instanceof OWLDatatype) {
            res = this.getIRI().compareTo((OWLObject)((OWLDatatype)o).getIRI());
        }
        return res;
    }

    @Override
    public String toString() {
        return this.toStringID();
    }
}

