/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.owlapi.axioms;

import com.github.owlcs.ontapi.jena.utils.Iter;
import com.github.owlcs.ontapi.owlapi.axioms.OWLLogicalAxiomImpl;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.HasAnnotations;
import org.semanticweb.owlapi.model.IsAnonymous;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLObject;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLObjectVisitorEx;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.util.SWRLVariableExtractor;

public class SWRLRuleImpl
extends OWLLogicalAxiomImpl
implements SWRLRule {
    private static final AtomSimplifier ATOM_SIMPLIFIER = new AtomSimplifier();
    private final List<SWRLAtom> head;
    private final List<SWRLAtom> body;
    private final boolean containsAnonymousClassExpressions;

    public SWRLRuleImpl(Collection<? extends SWRLAtom> body, Collection<? extends SWRLAtom> head, Collection<OWLAnnotation> annotations) {
        super(annotations);
        this.head = SWRLRuleImpl.toDistinctList(Objects.requireNonNull(head, "head cannot be null"));
        this.body = SWRLRuleImpl.toDistinctList(Objects.requireNonNull(body, "body cannot be null"));
        this.containsAnonymousClassExpressions = this.classAtomPredicates().anyMatch(IsAnonymous::isAnonymous);
    }

    private static <X> List<X> toDistinctList(Collection<? extends X> collection) {
        return SWRLRuleImpl.toDistinctList(collection.stream());
    }

    private static <X> List<X> toDistinctList(Stream<? extends X> stream) {
        return stream.map(Objects::requireNonNull).distinct().collect(Iter.toUnmodifiableList());
    }

    public static Stream<OWLClassExpression> classAtomPredicates(SWRLRule rule) {
        return SWRLRuleImpl.forOutput(Stream.concat(rule.head(), rule.body()).filter(x -> x instanceof SWRLClassAtom).map(c -> ((SWRLClassAtom)c).getPredicate()));
    }

    public static List<SWRLAtom> getBodyList(SWRLRule rule) {
        if (rule instanceof SWRLRuleImpl) {
            return rule.bodyList();
        }
        return SWRLRuleImpl.toDistinctList(rule.body());
    }

    public static List<SWRLAtom> getHeadList(SWRLRule rule) {
        if (rule instanceof SWRLRuleImpl) {
            return rule.headList();
        }
        return SWRLRuleImpl.toDistinctList(rule.head().distinct());
    }

    public static Stream<SWRLVariable> variables(SWRLRule rule) {
        return ((Collection)rule.accept((SWRLObjectVisitorEx)new SWRLVariableExtractor())).stream();
    }

    public SWRLRuleImpl getAxiomWithoutAnnotations() {
        if (!this.isAnnotated()) {
            return this;
        }
        return new SWRLRuleImpl(this.body, this.head, NO_ANNOTATIONS);
    }

    public <T extends OWLAxiom> T getAnnotatedAxiom(@Nonnull Stream<OWLAnnotation> annotations) {
        return (T)new SWRLRuleImpl(this.body, this.head, SWRLRuleImpl.mergeAnnotations((HasAnnotations)this, annotations));
    }

    public Stream<SWRLVariable> variables() {
        return SWRLRuleImpl.variables(this);
    }

    public boolean containsAnonymousClassExpressions() {
        return this.containsAnonymousClassExpressions;
    }

    public Stream<OWLClassExpression> classAtomPredicates() {
        return SWRLRuleImpl.classAtomPredicates(this);
    }

    public Stream<SWRLAtom> body() {
        return this.body.stream();
    }

    public Stream<SWRLAtom> head() {
        return this.head.stream();
    }

    public List<SWRLAtom> bodyList() {
        return this.body;
    }

    public List<SWRLAtom> headList() {
        return this.head;
    }

    public SWRLRule getSimplified() {
        return (SWRLRule)this.accept(ATOM_SIMPLIFIER);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SWRLRule)) {
            return false;
        }
        SWRLRule other = (SWRLRule)obj;
        return this.annotations.equals(other.annotationsAsList()) && this.body.equals(SWRLRuleImpl.getBodyList(other)) && this.head.equals(SWRLRuleImpl.getHeadList(other));
    }

    protected static class AtomSimplifier
    implements SWRLObjectVisitorEx<SWRLObject> {
        protected AtomSimplifier() {
        }

        public SWRLObject doDefault(Object o) {
            return (SWRLObject)o;
        }

        public SWRLRule visit(@Nonnull SWRLRule node) {
            List body = node.body().map(a -> (SWRLAtom)a.accept((SWRLObjectVisitorEx)this)).collect(Collectors.toList());
            List head = node.head().map(a -> (SWRLAtom)a.accept((SWRLObjectVisitorEx)this)).collect(Collectors.toList());
            return new SWRLRuleImpl(body, head, NO_ANNOTATIONS);
        }

        public SWRLObjectPropertyAtom visit(@Nonnull SWRLObjectPropertyAtom node) {
            return node.getSimplified();
        }
    }
}

