/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.jena.model;

import com.github.owlcs.ontapi.jena.model.OntAnnotationProperty;
import com.github.owlcs.ontapi.jena.model.OntResource;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.vocabulary.RDF;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;

public interface OntObject
extends OntResource {
    @Override
    public OntStatement getMainStatement();

    public Stream<OntStatement> spec();

    public Stream<OntStatement> content();

    public OntStatement addStatement(Property var1, RDFNode var2);

    public OntObject remove(Property var1, RDFNode var2);

    public Stream<OntStatement> statements(Property var1);

    public Stream<OntStatement> statements();

    public Optional<OntStatement> statement(Property var1, RDFNode var2);

    public Optional<OntStatement> statement(Property var1);

    public <O extends RDFNode> Stream<O> objects(Property var1, Class<O> var2);

    public Stream<RDFNode> objects(Property var1);

    public OntStatement addAnnotation(OntAnnotationProperty var1, RDFNode var2);

    public Stream<OntStatement> annotations();

    public Stream<String> annotationValues(OntAnnotationProperty var1, String var2);

    public OntObject clearAnnotations();

    public OntStatement getRequiredProperty(Property var1);

    default public boolean hasType(Resource type) {
        try (Stream<Resource> types = this.types();){
            boolean bl = types.anyMatch(arg_0 -> ((Resource)type).equals(arg_0));
            return bl;
        }
    }

    default public Stream<Resource> types() {
        return this.objects(RDF.type, Resource.class);
    }

    default public Stream<RDFNode> annotationValues(OntAnnotationProperty predicate) {
        return this.annotations().filter(s -> Objects.equals(predicate, s.getPredicate())).map(Statement::getObject);
    }

    default public OntStatement addAnnotation(OntAnnotationProperty predicate, String lexicalForm) {
        return this.addAnnotation(predicate, lexicalForm, null);
    }

    default public OntStatement addAnnotation(OntAnnotationProperty predicate, String txt, String lang) {
        return this.addAnnotation(predicate, (RDFNode)this.getModel().createLiteral(txt, lang));
    }

    default public OntObject annotate(OntAnnotationProperty predicate, RDFNode value) {
        this.addAnnotation(predicate, value);
        return this;
    }

    default public OntObject annotate(OntAnnotationProperty predicate, String txt, String lang) {
        return this.annotate(predicate, (RDFNode)this.getModel().createLiteral(txt, lang));
    }

    default public OntObject addComment(String txt) {
        return this.addComment(txt, null);
    }

    default public OntObject addComment(String txt, String lang) {
        this.addAnnotation(this.getModel().getRDFSComment(), txt, lang);
        return this;
    }

    default public OntObject addLabel(String txt) {
        return this.addLabel(txt, null);
    }

    default public OntObject addLabel(String txt, String lang) {
        this.addAnnotation(this.getModel().getRDFSLabel(), txt, lang);
        return this;
    }

    default public String getComment() {
        return this.getComment(null);
    }

    default public String getComment(String lang) {
        try (Stream<String> res = this.annotationValues(this.getModel().getRDFSComment(), lang);){
            String string = res.findFirst().orElse(null);
            return string;
        }
    }

    default public String getLabel() {
        return this.getLabel(null);
    }

    default public String getLabel(String lang) {
        try (Stream<String> res = this.annotationValues(this.getModel().getRDFSLabel(), lang);){
            String string = res.findFirst().orElse(null);
            return string;
        }
    }
}

