/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.jena.model;

import com.github.owlcs.ontapi.jena.model.HasRDFNodeList;
import com.github.owlcs.ontapi.jena.model.HasValue;
import com.github.owlcs.ontapi.jena.model.OntAnnotationProperty;
import com.github.owlcs.ontapi.jena.model.OntEntity;
import com.github.owlcs.ontapi.jena.model.OntFacetRestriction;
import com.github.owlcs.ontapi.jena.model.OntObject;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.model.SetComponents;
import com.github.owlcs.ontapi.jena.model.SetValue;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;

public interface OntDataRange
extends OntObject {
    default public int arity() {
        return 1;
    }

    public static interface Named
    extends OntEntity,
    OntDataRange {
        default public Stream<OntDataRange> equivalentClasses() {
            return this.objects(OWL.equivalentClass, OntDataRange.class);
        }

        default public OntStatement addEquivalentClassStatement(OntDataRange other) {
            return this.addStatement(OWL.equivalentClass, (RDFNode)other);
        }

        default public Named addEquivalentClass(OntDataRange other) {
            this.addEquivalentClassStatement(other);
            return this;
        }

        default public Named removeEquivalentClass(Resource other) {
            this.remove(OWL.equivalentClass, (RDFNode)other);
            return this;
        }

        default public RDFDatatype toRDFDatatype() {
            return TypeMapper.getInstance().getSafeTypeByName(this.getURI());
        }

        default public Literal createLiteral(Object obj) {
            return this.createLiteral(String.valueOf(Objects.requireNonNull(obj)));
        }

        default public Literal createLiteral(String lex) {
            return this.getModel().createTypedLiteral(Objects.requireNonNull(lex), this.toRDFDatatype());
        }

        @Override
        default public Named addComment(String txt) {
            return this.addComment(txt, null);
        }

        @Override
        default public Named addComment(String txt, String lang) {
            return this.annotate(this.getModel().getRDFSComment(), txt, lang);
        }

        @Override
        default public Named addLabel(String txt) {
            return this.addLabel(txt, null);
        }

        @Override
        default public Named addLabel(String txt, String lang) {
            return this.annotate(this.getModel().getRDFSLabel(), txt, lang);
        }

        @Override
        default public Named annotate(OntAnnotationProperty predicate, String txt, String lang) {
            return this.annotate(predicate, (RDFNode)this.getModel().createLiteral(txt, lang));
        }

        @Override
        default public Named annotate(OntAnnotationProperty predicate, RDFNode value) {
            this.addAnnotation(predicate, value);
            return this;
        }
    }

    public static interface ComponentsDR<N extends RDFNode>
    extends OntDataRange,
    HasRDFNodeList<N> {
    }

    public static interface Restriction
    extends ComponentsDR<OntFacetRestriction>,
    SetComponents<OntFacetRestriction, Restriction>,
    SetValue<Named, Restriction>,
    HasValue<Named> {
        @Override
        public Stream<OntStatement> spec();

        default public Restriction addFacet(Class<? extends OntFacetRestriction> type, Literal literal) {
            this.getList().add(this.getModel().createFacetRestriction(type, literal));
            return this;
        }
    }

    public static interface OneOf
    extends ComponentsDR<Literal>,
    SetComponents<Literal, OneOf> {
    }

    public static interface UnionOf
    extends ComponentsDR<OntDataRange>,
    SetComponents<OntDataRange, UnionOf> {
    }

    public static interface IntersectionOf
    extends ComponentsDR<OntDataRange>,
    SetComponents<OntDataRange, IntersectionOf> {
    }

    public static interface ComplementOf
    extends OntDataRange,
    SetValue<OntDataRange, ComplementOf>,
    HasValue<OntDataRange> {
    }
}

