/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.jena.model;

import com.github.owlcs.ontapi.jena.model.OntClass;
import com.github.owlcs.ontapi.jena.model.OntDataRange;
import com.github.owlcs.ontapi.jena.model.OntIndividual;
import com.github.owlcs.ontapi.jena.model.OntNamedProperty;
import com.github.owlcs.ontapi.jena.model.OntNegativeAssertion;
import com.github.owlcs.ontapi.jena.model.OntRealProperty;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import com.github.owlcs.ontapi.jena.vocabulary.RDF;
import java.util.stream.Stream;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.RDFS;

public interface OntDataProperty
extends OntRealProperty,
OntNamedProperty<OntDataProperty> {
    public OntNegativeAssertion.WithDataProperty addNegativeAssertion(OntIndividual var1, Literal var2);

    public Stream<OntDataProperty> superProperties(boolean var1);

    public Stream<OntDataProperty> subProperties(boolean var1);

    default public Stream<OntNegativeAssertion.WithDataProperty> negativeAssertions() {
        return this.getModel().ontObjects(OntNegativeAssertion.WithDataProperty.class).filter(a -> this.equals(a.getProperty()));
    }

    default public Stream<OntNegativeAssertion.WithDataProperty> negativeAssertions(OntIndividual source) {
        return this.negativeAssertions().filter(a -> a.getSource().equals(source));
    }

    default public Stream<OntDataRange> ranges() {
        return this.objects(RDFS.range, OntDataRange.class);
    }

    default public Stream<OntDataProperty> superProperties() {
        return this.objects(RDFS.subPropertyOf, OntDataProperty.class);
    }

    default public Stream<OntDataProperty> disjointProperties() {
        return this.objects(OWL.propertyDisjointWith, OntDataProperty.class);
    }

    default public Stream<OntDataProperty> equivalentProperties() {
        return this.objects(OWL.equivalentProperty, OntDataProperty.class);
    }

    default public OntStatement addRangeStatement(OntDataRange range) {
        return this.addStatement(RDFS.range, (RDFNode)range);
    }

    default public OntStatement addSubPropertyOfStatement(OntDataProperty property) {
        return this.addStatement(RDFS.subPropertyOf, (RDFNode)property);
    }

    default public OntStatement addEquivalentPropertyStatement(OntDataProperty other) {
        return this.addStatement(OWL.equivalentProperty, (RDFNode)other);
    }

    default public OntStatement addPropertyDisjointWithStatement(OntDataProperty other) {
        return this.addStatement(OWL.propertyDisjointWith, (RDFNode)other);
    }

    default public OntDataProperty addSuperProperty(OntDataProperty property) {
        this.addSubPropertyOfStatement(property);
        return this;
    }

    default public OntDataProperty addRange(Resource range) {
        return this.addRange((OntDataRange)range.inModel((Model)this.getModel()).as(OntDataRange.class));
    }

    default public OntDataProperty addRange(OntDataRange range) {
        this.addRangeStatement(range);
        return this;
    }

    @Override
    default public OntDataProperty addDomain(OntClass ce) {
        this.addDomainStatement(ce);
        return this;
    }

    default public OntDataProperty addEquivalentProperty(OntDataProperty other) {
        this.addEquivalentPropertyStatement(other);
        return this;
    }

    default public OntDataProperty addDisjointProperty(OntDataProperty other) {
        this.addPropertyDisjointWithStatement(other);
        return this;
    }

    @Override
    default public OntDataProperty removeSuperProperty(Resource property) {
        this.remove(RDFS.subPropertyOf, (RDFNode)property);
        return this;
    }

    @Override
    default public OntDataProperty removeDomain(Resource domain) {
        this.remove(RDFS.domain, (RDFNode)domain);
        return this;
    }

    @Override
    default public OntDataProperty removeRange(Resource range) {
        this.remove(RDFS.range, (RDFNode)range);
        return this;
    }

    @Override
    default public OntDataProperty removeEquivalentProperty(Resource property) {
        this.remove(OWL.equivalentProperty, (RDFNode)property);
        return this;
    }

    @Override
    default public OntDataProperty removeDisjointProperty(Resource property) {
        this.remove(OWL.propertyDisjointWith, (RDFNode)property);
        return this;
    }

    @Override
    default public OntDataProperty setFunctional(boolean functional) {
        if (functional) {
            this.addFunctionalDeclaration();
        } else {
            this.remove(RDF.type, (RDFNode)OWL.FunctionalProperty);
        }
        return this;
    }
}

