/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.jena.model;

import com.github.owlcs.ontapi.jena.model.HasCardinality;
import com.github.owlcs.ontapi.jena.model.HasProperties;
import com.github.owlcs.ontapi.jena.model.HasProperty;
import com.github.owlcs.ontapi.jena.model.HasRDFNodeList;
import com.github.owlcs.ontapi.jena.model.HasValue;
import com.github.owlcs.ontapi.jena.model.OntAnnotationProperty;
import com.github.owlcs.ontapi.jena.model.OntDataProperty;
import com.github.owlcs.ontapi.jena.model.OntDataRange;
import com.github.owlcs.ontapi.jena.model.OntEntity;
import com.github.owlcs.ontapi.jena.model.OntIndividual;
import com.github.owlcs.ontapi.jena.model.OntList;
import com.github.owlcs.ontapi.jena.model.OntObject;
import com.github.owlcs.ontapi.jena.model.OntObjectProperty;
import com.github.owlcs.ontapi.jena.model.OntProperty;
import com.github.owlcs.ontapi.jena.model.OntRealProperty;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.model.RDFNodeList;
import com.github.owlcs.ontapi.jena.model.SetCardinality;
import com.github.owlcs.ontapi.jena.model.SetComponents;
import com.github.owlcs.ontapi.jena.model.SetProperties;
import com.github.owlcs.ontapi.jena.model.SetProperty;
import com.github.owlcs.ontapi.jena.model.SetValue;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import com.github.owlcs.ontapi.jena.vocabulary.RDF;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.RDFS;

public interface OntClass
extends OntObject {
    public Stream<OntClass> superClasses(boolean var1);

    public Stream<OntClass> subClasses(boolean var1);

    public Stream<OntList<OntRealProperty>> hasKeys();

    public OntIndividual.Anonymous createIndividual();

    public OntIndividual.Named createIndividual(String var1);

    public OntList<OntRealProperty> createHasKey(Collection<OntObjectProperty> var1, Collection<OntDataProperty> var2);

    public OntStatement addHasKeyStatement(OntRealProperty ... var1);

    public OntClass removeHasKey(Resource var1);

    default public Stream<OntIndividual> individuals() {
        return this.getModel().statements(null, RDF.type, (RDFNode)this).map(s -> s.getSubject(OntIndividual.class));
    }

    default public Stream<OntProperty> properties() {
        return this.getModel().statements(null, RDFS.domain, (RDFNode)this).map(s -> s.getSubject().getAs(OntProperty.class)).filter(Objects::nonNull);
    }

    default public Stream<OntClass> superClasses() {
        return this.objects(RDFS.subClassOf, OntClass.class);
    }

    default public Stream<OntClass> disjointClasses() {
        return this.objects(OWL.disjointWith, OntClass.class);
    }

    default public Stream<OntClass> equivalentClasses() {
        return this.objects(OWL.equivalentClass, OntClass.class);
    }

    default public OntStatement addSubClassOfStatement(OntClass other) {
        return this.addStatement(RDFS.subClassOf, (RDFNode)other);
    }

    default public OntStatement addDisjointWithStatement(OntClass other) {
        return this.addStatement(OWL.disjointWith, (RDFNode)other);
    }

    default public OntStatement addEquivalentClassStatement(OntClass other) {
        return this.addStatement(OWL.equivalentClass, (RDFNode)other);
    }

    default public OntStatement addHasKeyStatement(Collection<OntObjectProperty> objectProperties, Collection<OntDataProperty> dataProperties) {
        return this.createHasKey(objectProperties, dataProperties).getMainStatement();
    }

    default public OntClass addSuperClass(OntClass other) {
        this.addSubClassOfStatement(other);
        return this;
    }

    default public OntClass addDisjointClass(OntClass other) {
        this.addDisjointWithStatement(other);
        return this;
    }

    default public OntClass addEquivalentClass(OntClass other) {
        this.addEquivalentClassStatement(other);
        return this;
    }

    default public OntClass addHasKey(Collection<OntObjectProperty> objectProperties, Collection<OntDataProperty> dataProperties) {
        this.addHasKeyStatement(objectProperties, dataProperties);
        return this;
    }

    default public OntClass addHasKey(OntRealProperty ... properties) {
        this.addHasKeyStatement(properties);
        return this;
    }

    default public OntClass removeSuperClass(Resource other) {
        this.remove(RDFS.subClassOf, (RDFNode)other);
        return this;
    }

    default public OntClass removeDisjointClass(Resource other) {
        this.remove(OWL.disjointWith, (RDFNode)other);
        return this;
    }

    default public OntClass removeEquivalentClass(Resource other) {
        this.remove(OWL.equivalentClass, (RDFNode)other);
        return this;
    }

    default public OntClass clearHasKeys() {
        this.hasKeys().collect(Collectors.toList()).forEach(this::removeHasKey);
        return this;
    }

    default public Optional<OntList<OntRealProperty>> findHasKey(RDFNode list) {
        try (Stream<OntList> res = this.hasKeys().filter(r -> Objects.equals(r, list));){
            Optional<OntList<OntRealProperty>> optional = res.findFirst();
            return optional;
        }
    }

    default public Stream<OntRealProperty> fromHasKey() {
        return this.hasKeys().flatMap(RDFNodeList::members).distinct();
    }

    public static interface RestrictionCE<P extends OntRealProperty>
    extends OntClass,
    HasProperty<P> {
    }

    public static interface UnaryRestrictionCE<P extends OntRealProperty>
    extends RestrictionCE<P> {
    }

    public static interface NaryRestrictionCE<O extends OntObject, P extends OntRealProperty>
    extends RestrictionCE<P>,
    HasProperties<P>,
    HasValue<O> {
    }

    public static interface ComponentRestrictionCE<O extends RDFNode, P extends OntRealProperty>
    extends UnaryRestrictionCE<P>,
    HasValue<O> {
    }

    public static interface CardinalityRestrictionCE<O extends OntObject, P extends OntRealProperty>
    extends HasCardinality,
    ComponentRestrictionCE<O, P> {
    }

    public static interface ComponentsCE<O extends OntObject>
    extends OntClass,
    HasRDFNodeList<O> {
    }

    public static interface Named
    extends OntEntity,
    OntClass {
        public Stream<OntList<OntClass>> disjointUnions();

        public OntList<OntClass> createDisjointUnion(Collection<OntClass> var1);

        default public Optional<OntList<OntClass>> findDisjointUnion(RDFNode list) {
            try (Stream<OntList> res = this.disjointUnions().filter(r -> Objects.equals(r, list));){
                Optional<OntList<OntClass>> optional = res.findFirst();
                return optional;
            }
        }

        default public OntStatement addDisjointUnionOfStatement(OntClass ... classes) {
            return this.addDisjointUnionOfStatement(Arrays.stream(classes).collect(Collectors.toCollection(LinkedHashSet::new)));
        }

        default public OntStatement addDisjointUnionOfStatement(Collection<OntClass> classes) {
            return this.createDisjointUnion(classes).getMainStatement();
        }

        @Override
        default public Named addSuperClass(OntClass other) {
            this.addSubClassOfStatement(other);
            return this;
        }

        @Override
        default public Named addDisjointClass(OntClass other) {
            this.addDisjointWithStatement(other);
            return this;
        }

        @Override
        default public Named addEquivalentClass(OntClass other) {
            this.addEquivalentClassStatement(other);
            return this;
        }

        @Override
        default public Named addHasKey(Collection<OntObjectProperty> objectProperties, Collection<OntDataProperty> dataProperties) {
            this.addHasKeyStatement(objectProperties, dataProperties);
            return this;
        }

        @Override
        default public Named addHasKey(OntRealProperty ... properties) {
            this.addHasKeyStatement(properties);
            return this;
        }

        default public Named addDisjointUnion(Collection<OntClass> classes) {
            this.addDisjointUnionOfStatement(classes);
            return this;
        }

        default public Named addDisjointUnion(OntClass ... classes) {
            this.addDisjointUnionOfStatement(classes);
            return this;
        }

        public Named removeDisjointUnion(Resource var1);

        @Override
        default public Named removeSuperClass(Resource other) {
            OntClass.super.removeSuperClass(other);
            return this;
        }

        @Override
        default public Named removeDisjointClass(Resource other) {
            OntClass.super.removeDisjointClass(other);
            return this;
        }

        @Override
        default public Named removeEquivalentClass(Resource other) {
            OntClass.super.removeEquivalentClass(other);
            return this;
        }

        @Override
        default public Named clearHasKeys() {
            OntClass.super.clearHasKeys();
            return this;
        }

        default public Named clearDisjointUnions() {
            this.disjointUnions().collect(Collectors.toSet()).forEach(this::removeDisjointUnion);
            return this;
        }

        default public Stream<OntClass> fromDisjointUnionOf() {
            return this.disjointUnions().flatMap(RDFNodeList::members).distinct();
        }

        @Override
        default public Named addComment(String txt) {
            return this.addComment(txt, null);
        }

        @Override
        default public Named addComment(String txt, String lang) {
            return this.annotate(this.getModel().getRDFSComment(), txt, lang);
        }

        @Override
        default public Named addLabel(String txt) {
            return this.addLabel(txt, null);
        }

        @Override
        default public Named addLabel(String txt, String lang) {
            return this.annotate(this.getModel().getRDFSLabel(), txt, lang);
        }

        @Override
        default public Named annotate(OntAnnotationProperty predicate, String txt, String lang) {
            return this.annotate(predicate, (RDFNode)this.getModel().createLiteral(txt, lang));
        }

        @Override
        default public Named annotate(OntAnnotationProperty predicate, RDFNode value) {
            this.addAnnotation(predicate, value);
            return this;
        }
    }

    public static interface NaryDataSomeValuesFrom
    extends NaryRestrictionCE<OntDataRange, OntDataProperty>,
    SetValue<OntDataRange, NaryDataSomeValuesFrom>,
    SetProperties<OntDataProperty, NaryDataSomeValuesFrom> {
    }

    public static interface NaryDataAllValuesFrom
    extends NaryRestrictionCE<OntDataRange, OntDataProperty>,
    SetValue<OntDataRange, NaryDataAllValuesFrom>,
    SetProperties<OntDataProperty, NaryDataAllValuesFrom> {
    }

    public static interface ComplementOf
    extends OntClass,
    HasValue<OntClass>,
    SetValue<OntClass, ComplementOf> {
    }

    public static interface IntersectionOf
    extends ComponentsCE<OntClass>,
    SetComponents<OntClass, IntersectionOf> {
    }

    public static interface OneOf
    extends ComponentsCE<OntIndividual>,
    SetComponents<OntIndividual, OneOf> {
    }

    public static interface UnionOf
    extends ComponentsCE<OntClass>,
    SetComponents<OntClass, UnionOf> {
    }

    public static interface HasSelf
    extends UnaryRestrictionCE<OntObjectProperty>,
    SetProperty<OntObjectProperty, HasSelf> {
    }

    public static interface DataCardinality
    extends CardinalityRestrictionCE<OntDataRange, OntDataProperty>,
    SetValue<OntDataRange, DataCardinality>,
    SetProperty<OntDataProperty, DataCardinality>,
    SetCardinality<DataCardinality> {
    }

    public static interface ObjectCardinality
    extends CardinalityRestrictionCE<OntClass, OntObjectProperty>,
    SetValue<OntClass, ObjectCardinality>,
    SetProperty<OntObjectProperty, ObjectCardinality>,
    SetCardinality<ObjectCardinality> {
    }

    public static interface DataMaxCardinality
    extends CardinalityRestrictionCE<OntDataRange, OntDataProperty>,
    SetValue<OntDataRange, DataMaxCardinality>,
    SetProperty<OntDataProperty, DataMaxCardinality>,
    SetCardinality<DataMaxCardinality> {
    }

    public static interface ObjectMaxCardinality
    extends CardinalityRestrictionCE<OntClass, OntObjectProperty>,
    SetValue<OntClass, ObjectMaxCardinality>,
    SetProperty<OntObjectProperty, ObjectMaxCardinality>,
    SetCardinality<ObjectMaxCardinality> {
    }

    public static interface DataMinCardinality
    extends CardinalityRestrictionCE<OntDataRange, OntDataProperty>,
    SetValue<OntDataRange, DataMinCardinality>,
    SetProperty<OntDataProperty, DataMinCardinality>,
    SetCardinality<DataMinCardinality> {
    }

    public static interface ObjectMinCardinality
    extends CardinalityRestrictionCE<OntClass, OntObjectProperty>,
    SetValue<OntClass, ObjectMinCardinality>,
    SetProperty<OntObjectProperty, ObjectMinCardinality>,
    SetCardinality<ObjectMinCardinality> {
    }

    public static interface DataHasValue
    extends ComponentRestrictionCE<Literal, OntDataProperty>,
    SetValue<Literal, DataHasValue>,
    SetProperty<OntDataProperty, DataHasValue> {
    }

    public static interface ObjectHasValue
    extends ComponentRestrictionCE<OntIndividual, OntObjectProperty>,
    SetValue<OntIndividual, ObjectHasValue>,
    SetProperty<OntObjectProperty, ObjectHasValue> {
    }

    public static interface DataAllValuesFrom
    extends ComponentRestrictionCE<OntDataRange, OntDataProperty>,
    SetValue<OntDataRange, DataAllValuesFrom>,
    SetProperty<OntDataProperty, DataAllValuesFrom> {
    }

    public static interface ObjectAllValuesFrom
    extends ComponentRestrictionCE<OntClass, OntObjectProperty>,
    SetValue<OntClass, ObjectAllValuesFrom>,
    SetProperty<OntObjectProperty, ObjectAllValuesFrom> {
    }

    public static interface DataSomeValuesFrom
    extends ComponentRestrictionCE<OntDataRange, OntDataProperty>,
    SetValue<OntDataRange, DataSomeValuesFrom>,
    SetProperty<OntDataProperty, DataSomeValuesFrom> {
    }

    public static interface ObjectSomeValuesFrom
    extends ComponentRestrictionCE<OntClass, OntObjectProperty>,
    SetValue<OntClass, ObjectSomeValuesFrom>,
    SetProperty<OntObjectProperty, ObjectSomeValuesFrom> {
    }
}

