/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.jena.impl.conf;

import com.github.owlcs.ontapi.jena.OntJenaException;
import com.github.owlcs.ontapi.jena.impl.conf.ObjectFactory;
import com.github.owlcs.ontapi.jena.impl.conf.OntPersonality;
import com.github.owlcs.ontapi.jena.model.OntObject;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.jena.enhanced.Personality;
import org.apache.jena.rdf.model.RDFNode;

public class OntPersonalityImpl
extends Personality<RDFNode>
implements OntPersonality {
    private final OntPersonality.Punnings punnings;
    private final OntPersonality.Builtins builtins;
    private final OntPersonality.Reserved reserved;

    public OntPersonalityImpl(Personality<RDFNode> other, OntPersonality.Punnings punnings, OntPersonality.Builtins builtins, OntPersonality.Reserved reserved) {
        super(Objects.requireNonNull(other, "Null personalities"));
        this.builtins = Objects.requireNonNull(builtins, "Null builtins vocabulary");
        this.punnings = Objects.requireNonNull(punnings, "Null punnings vocabulary");
        this.reserved = Objects.requireNonNull(reserved, "Null reserved vocabulary");
    }

    protected OntPersonalityImpl(OntPersonalityImpl other) {
        this(other, other.getPunnings(), other.getBuiltins(), other.getReserved());
    }

    @Override
    public OntPersonality.Builtins getBuiltins() {
        return this.builtins;
    }

    @Override
    public OntPersonality.Punnings getPunnings() {
        return this.punnings;
    }

    @Override
    public OntPersonality.Reserved getReserved() {
        return this.reserved;
    }

    public void register(Class<? extends OntObject> type, ObjectFactory factory) {
        super.add(Objects.requireNonNull(type, "Null type."), ObjectFactory.asJenaImplementation(factory));
    }

    public void unregister(Class<? extends OntObject> view) {
        this.getMap().remove(view);
    }

    @Override
    public Stream<Class<? extends RDFNode>> types() {
        return this.getMap().keySet().stream();
    }

    @Override
    public ObjectFactory getObjectFactory(Class<? extends OntObject> type) {
        return (ObjectFactory)OntJenaException.notNull(this.getImplementation(type), "Can't find factory for the object type " + type);
    }

    public OntPersonalityImpl add(Personality<RDFNode> other) {
        super.add(other);
        return this;
    }

    @Override
    public OntPersonalityImpl copy() {
        return new OntPersonalityImpl(this);
    }
}

