/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.jena.impl.conf;

import com.github.owlcs.ontapi.jena.OntJenaException;
import com.github.owlcs.ontapi.jena.impl.conf.ObjectFactory;
import com.github.owlcs.ontapi.jena.impl.conf.Vocabulary;
import com.github.owlcs.ontapi.jena.model.OntObject;
import com.github.owlcs.ontapi.jena.utils.Iter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.jena.enhanced.Personality;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;

public interface OntPersonality {
    public Stream<Class<? extends RDFNode>> types();

    public ObjectFactory getObjectFactory(Class<? extends OntObject> var1);

    public OntPersonality copy();

    public Punnings getPunnings();

    public Builtins getBuiltins();

    public Reserved getReserved();

    default public <T extends OntObject> Stream<Class<? extends T>> types(Class<T> type) {
        Objects.requireNonNull(type);
        return this.types().filter(c -> {
            if (c == type) return true;
            if (!Arrays.stream(c.getInterfaces()).anyMatch(type::isAssignableFrom)) return false;
            return true;
        }).map(x -> x);
    }

    public static Personality<RDFNode> asJenaPersonality(OntPersonality p) throws OntJenaException {
        if (p instanceof Personality) {
            return (Personality)p;
        }
        throw new OntJenaException.IllegalArgument("The given OntPersonality is not an instance of Jena Personality.");
    }

    public static interface Reserved
    extends Vocabulary<Resource> {
        public Set<Node> get(String var1, Supplier<Set<Node>> var2);

        default public Set<Node> getResources() {
            return this.get(Resource.class);
        }

        default public Set<Node> getProperties() {
            return this.get(Property.class);
        }
    }

    public static interface Punnings
    extends Vocabulary.Entities {
    }

    public static interface Builtins
    extends Vocabulary.Entities {
        default public Set<Node> getProperties() {
            return Stream.of(this.getObjectProperties(), this.getAnnotationProperties(), this.getDatatypeProperties()).flatMap(Collection::stream).collect(Iter.toUnmodifiableSet());
        }
    }
}

