/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.jena.impl.conf;

import com.github.owlcs.ontapi.jena.OntJenaException;
import com.github.owlcs.ontapi.jena.OntVocabulary;
import com.github.owlcs.ontapi.jena.impl.Entities;
import com.github.owlcs.ontapi.jena.impl.OntAnnotationImpl;
import com.github.owlcs.ontapi.jena.impl.OntCEImpl;
import com.github.owlcs.ontapi.jena.impl.OntDRImpl;
import com.github.owlcs.ontapi.jena.impl.OntDisjointImpl;
import com.github.owlcs.ontapi.jena.impl.OntFRImpl;
import com.github.owlcs.ontapi.jena.impl.OntIDImpl;
import com.github.owlcs.ontapi.jena.impl.OntIndividualImpl;
import com.github.owlcs.ontapi.jena.impl.OntNPAImpl;
import com.github.owlcs.ontapi.jena.impl.OntObjectImpl;
import com.github.owlcs.ontapi.jena.impl.OntPEImpl;
import com.github.owlcs.ontapi.jena.impl.OntSWRLImpl;
import com.github.owlcs.ontapi.jena.impl.conf.OntPersonality;
import com.github.owlcs.ontapi.jena.impl.conf.PersonalityBuilder;
import com.github.owlcs.ontapi.jena.impl.conf.VocabularyImpl;
import com.github.owlcs.ontapi.jena.model.OntAnnotation;
import com.github.owlcs.ontapi.jena.model.OntAnnotationProperty;
import com.github.owlcs.ontapi.jena.model.OntClass;
import com.github.owlcs.ontapi.jena.model.OntDataProperty;
import com.github.owlcs.ontapi.jena.model.OntDataRange;
import com.github.owlcs.ontapi.jena.model.OntDisjoint;
import com.github.owlcs.ontapi.jena.model.OntEntity;
import com.github.owlcs.ontapi.jena.model.OntFacetRestriction;
import com.github.owlcs.ontapi.jena.model.OntID;
import com.github.owlcs.ontapi.jena.model.OntIndividual;
import com.github.owlcs.ontapi.jena.model.OntNamedProperty;
import com.github.owlcs.ontapi.jena.model.OntNegativeAssertion;
import com.github.owlcs.ontapi.jena.model.OntObject;
import com.github.owlcs.ontapi.jena.model.OntObjectProperty;
import com.github.owlcs.ontapi.jena.model.OntProperty;
import com.github.owlcs.ontapi.jena.model.OntRealProperty;
import com.github.owlcs.ontapi.jena.model.OntSWRL;
import com.github.owlcs.ontapi.jena.utils.Iter;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.jena.enhanced.Personality;
import org.apache.jena.graph.FrontsNode;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Alt;
import org.apache.jena.rdf.model.Bag;
import org.apache.jena.rdf.model.Container;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ReifiedStatement;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Seq;
import org.apache.jena.rdf.model.impl.AltImpl;
import org.apache.jena.rdf.model.impl.BagImpl;
import org.apache.jena.rdf.model.impl.LiteralImpl;
import org.apache.jena.rdf.model.impl.PropertyImpl;
import org.apache.jena.rdf.model.impl.RDFListImpl;
import org.apache.jena.rdf.model.impl.ReifiedStatementImpl;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.apache.jena.rdf.model.impl.SeqImpl;
import org.apache.jena.vocabulary.RDFS;

public class OntModelConfig {
    private static final OntVocabulary VOCABULARY = OntVocabulary.Factory.get();
    private static final OntPersonality.Builtins BUILTINS = OntModelConfig.createBuiltinsVocabulary(VOCABULARY);
    private static final OntPersonality.Reserved RESERVED = OntModelConfig.createReservedVocabulary(VOCABULARY);
    private static final Personality<RDFNode> STANDARD_PERSONALITY = new Personality().add(Resource.class, ResourceImpl.factory).add(Property.class, PropertyImpl.factory).add(Literal.class, LiteralImpl.factory).add(Container.class, ResourceImpl.factory).add(Alt.class, AltImpl.factory).add(Bag.class, BagImpl.factory).add(Seq.class, SeqImpl.factory).add(ReifiedStatement.class, ReifiedStatementImpl.reifiedStatementFactory).add(RDFList.class, RDFListImpl.factory).add(RDFNode.class, ResourceImpl.rdfNodeFactory);
    private static final PersonalityBuilder ONT_PERSONALITY_BUILDER = new PersonalityBuilder().addPersonality(STANDARD_PERSONALITY).add(OntObject.class, OntObjectImpl.objectFactory).add(OntID.class, OntIDImpl.idFactory).add(OntAnnotation.class, OntAnnotationImpl.annotationFactory).add(OntClass.Named.class, Entities.CLASS.createFactory()).add(OntDataRange.Named.class, Entities.DATATYPE.createFactory()).add(OntIndividual.Named.class, Entities.INDIVIDUAL.createFactory()).add(OntObjectProperty.Named.class, Entities.OBJECT_PROPERTY.createFactory()).add(OntDataProperty.class, Entities.DATA_PROPERTY.createFactory()).add(OntAnnotationProperty.class, Entities.ANNOTATION_PROPERTY.createFactory()).add(OntEntity.class, Entities.ALL).add(OntIndividual.Anonymous.class, OntIndividualImpl.anonymousIndividualFactory).add(OntIndividual.class, OntIndividualImpl.abstractIndividualFactory).add(OntObjectProperty.Inverse.class, OntPEImpl.inversePropertyFactory).add(OntObjectProperty.class, OntPEImpl.abstractOPEFactory).add(OntRealProperty.class, OntPEImpl.abstractDOPFactory).add(OntNamedProperty.class, OntPEImpl.abstractNamedPropertyFactory).add(OntProperty.class, OntPEImpl.abstractPEFactory).add(OntClass.ObjectSomeValuesFrom.class, OntCEImpl.objectSomeValuesOfCEFactory).add(OntClass.DataSomeValuesFrom.class, OntCEImpl.dataSomeValuesOfCEFactory).add(OntClass.ObjectAllValuesFrom.class, OntCEImpl.objectAllValuesOfCEFactory).add(OntClass.DataAllValuesFrom.class, OntCEImpl.dataAllValuesOfCEFactory).add(OntClass.ObjectHasValue.class, OntCEImpl.objectHasValueCEFactory).add(OntClass.DataHasValue.class, OntCEImpl.dataHasValueCEFactory).add(OntClass.ObjectMinCardinality.class, OntCEImpl.objectMinCardinalityCEFactory).add(OntClass.DataMinCardinality.class, OntCEImpl.dataMinCardinalityCEFactory).add(OntClass.ObjectMaxCardinality.class, OntCEImpl.objectMaxCardinalityCEFactory).add(OntClass.DataMaxCardinality.class, OntCEImpl.dataMaxCardinalityCEFactory).add(OntClass.ObjectCardinality.class, OntCEImpl.objectCardinalityCEFactory).add(OntClass.DataCardinality.class, OntCEImpl.dataCardinalityCEFactory).add(OntClass.HasSelf.class, OntCEImpl.hasSelfCEFactory).add(OntClass.UnionOf.class, OntCEImpl.unionOfCEFactory).add(OntClass.OneOf.class, OntCEImpl.oneOfCEFactory).add(OntClass.IntersectionOf.class, OntCEImpl.intersectionOfCEFactory).add(OntClass.ComplementOf.class, OntCEImpl.complementOfCEFactory).add(OntClass.NaryDataAllValuesFrom.class, OntCEImpl.naryDataAllValuesFromCEFactory).add(OntClass.NaryDataSomeValuesFrom.class, OntCEImpl.naryDataSomeValuesFromCEFactory).add(OntClass.ComponentsCE.class, OntCEImpl.abstractComponentsCEFactory).add(OntClass.CardinalityRestrictionCE.class, OntCEImpl.abstractCardinalityRestrictionCEFactory).add(OntClass.ComponentRestrictionCE.class, OntCEImpl.abstractComponentRestrictionCEFactory).add(OntClass.UnaryRestrictionCE.class, OntCEImpl.abstractPropertyRestrictionCEFactory).add(OntClass.RestrictionCE.class, OntCEImpl.abstractRestrictionCEFactory).add(OntClass.class, OntCEImpl.abstractCEFactory).add(OntDataRange.OneOf.class, OntDRImpl.oneOfDRFactory).add(OntDataRange.Restriction.class, OntDRImpl.restrictionDRFactory).add(OntDataRange.ComplementOf.class, OntDRImpl.complementOfDRFactory).add(OntDataRange.UnionOf.class, OntDRImpl.unionOfDRFactory).add(OntDataRange.IntersectionOf.class, OntDRImpl.intersectionOfDRFactory).add(OntDataRange.ComponentsDR.class, OntDRImpl.abstractComponentsDRFactory).add(OntDataRange.class, OntDRImpl.abstractDRFactory).add(OntFacetRestriction.Length.class, OntFRImpl.lengthFRFactory).add(OntFacetRestriction.MinLength.class, OntFRImpl.minLengthFRFactory).add(OntFacetRestriction.MaxLength.class, OntFRImpl.maxLengthFRFactory).add(OntFacetRestriction.MinInclusive.class, OntFRImpl.minInclusiveFRFactory).add(OntFacetRestriction.MaxInclusive.class, OntFRImpl.maxInclusiveFRFactory).add(OntFacetRestriction.MinExclusive.class, OntFRImpl.minExclusiveFRFactory).add(OntFacetRestriction.MaxExclusive.class, OntFRImpl.maxExclusiveFRFactory).add(OntFacetRestriction.Pattern.class, OntFRImpl.patternFRFactory).add(OntFacetRestriction.TotalDigits.class, OntFRImpl.totalDigitsFRFactory).add(OntFacetRestriction.FractionDigits.class, OntFRImpl.fractionDigitsFRFactory).add(OntFacetRestriction.LangRange.class, OntFRImpl.langRangeFRFactory).add(OntFacetRestriction.class, OntFRImpl.abstractFRFactory).add(OntNegativeAssertion.WithObjectProperty.class, OntNPAImpl.objectNPAFactory).add(OntNegativeAssertion.WithDataProperty.class, OntNPAImpl.dataNPAFactory).add(OntNegativeAssertion.class, OntNPAImpl.abstractNPAFactory).add(OntDisjoint.Classes.class, OntDisjointImpl.disjointClassesFactory).add(OntDisjoint.Individuals.class, OntDisjointImpl.differentIndividualsFactory).add(OntDisjoint.ObjectProperties.class, OntDisjointImpl.objectPropertiesFactory).add(OntDisjoint.DataProperties.class, OntDisjointImpl.dataPropertiesFactory).add(OntDisjoint.Properties.class, OntDisjointImpl.abstractPropertiesFactory).add(OntDisjoint.class, OntDisjointImpl.abstractDisjointFactory).add(OntSWRL.Variable.class, OntSWRLImpl.variableSWRLFactory).add(OntSWRL.Builtin.class, OntSWRLImpl.builtinWRLFactory).add(OntSWRL.IArg.class, OntSWRLImpl.iArgSWRLFactory).add(OntSWRL.DArg.class, OntSWRLImpl.dArgSWRLFactory).add(OntSWRL.Arg.class, OntSWRLImpl.abstractArgSWRLFactory).add(OntSWRL.Atom.WithBuiltin.class, OntSWRLImpl.builtInAtomSWRLFactory).add(OntSWRL.Atom.WithClass.class, OntSWRLImpl.classAtomSWRLFactory).add(OntSWRL.Atom.WithDataRange.class, OntSWRLImpl.dataRangeAtomSWRLFactory).add(OntSWRL.Atom.WithObjectProperty.class, OntSWRLImpl.individualAtomSWRLFactory).add(OntSWRL.Atom.WithDataProperty.class, OntSWRLImpl.dataValuedAtomSWRLFactory).add(OntSWRL.Atom.WithDifferentIndividuals.class, OntSWRLImpl.differentIndividualsAtomSWRLFactory).add(OntSWRL.Atom.WithSameIndividuals.class, OntSWRLImpl.sameIndividualsAtomSWRLFactory).add(OntSWRL.Atom.Unary.class, OntSWRLImpl.abstractUnarySWRLFactory).add(OntSWRL.Atom.Binary.class, OntSWRLImpl.abstractBinarySWRLFactory).add(OntSWRL.Atom.class, OntSWRLImpl.abstractAtomSWRLFactory).add(OntSWRL.class, OntSWRLImpl.abstractSWRLFactory).add(OntSWRL.Imp.class, OntSWRLImpl.impSWRLFactory);
    public static final OntPersonality ONT_PERSONALITY_LAX = OntModelConfig.getPersonalityBuilder().setBuiltins(BUILTINS).setReserved(RESERVED).setPunnings(StdMode.LAX.getVocabulary()).build();
    public static final OntPersonality ONT_PERSONALITY_STRICT = OntModelConfig.getPersonalityBuilder().setBuiltins(BUILTINS).setReserved(RESERVED).setPunnings(StdMode.STRICT.getVocabulary()).build();
    public static final OntPersonality ONT_PERSONALITY_MEDIUM;
    private static OntPersonality personality;

    public static Personality<RDFNode> getStandardPersonality() {
        return STANDARD_PERSONALITY.copy();
    }

    public static PersonalityBuilder getPersonalityBuilder() {
        return ONT_PERSONALITY_BUILDER.copy();
    }

    public static OntPersonality getPersonality() {
        return personality;
    }

    public static OntPersonality setPersonality(OntPersonality other) {
        OntPersonality res = personality;
        personality = OntJenaException.notNull(other, "Null personality specified.");
        return res;
    }

    public static OntPersonality.Builtins createBuiltinsVocabulary(OntVocabulary voc) {
        Objects.requireNonNull(voc);
        HashMap<Class<? extends OntObject>, Set<Node>> res = new HashMap<Class<? extends OntObject>, Set<Node>>();
        res.put(OntAnnotationProperty.class, Iter.asUnmodifiableNodeSet(voc.getBuiltinAnnotationProperties()));
        res.put(OntDataProperty.class, Iter.asUnmodifiableNodeSet(voc.getBuiltinDatatypeProperties()));
        res.put(OntObjectProperty.Named.class, Iter.asUnmodifiableNodeSet(voc.getBuiltinObjectProperties()));
        res.put(OntDataRange.Named.class, Iter.asUnmodifiableNodeSet(voc.getBuiltinDatatypes()));
        res.put(OntClass.Named.class, Iter.asUnmodifiableNodeSet(voc.getBuiltinClasses()));
        res.put(OntSWRL.Builtin.class, Iter.asUnmodifiableNodeSet(voc.getBuiltinSWRLs()));
        res.put(OntIndividual.Named.class, Collections.emptySet());
        return new VocabularyImpl.EntitiesImpl((Map<Class<? extends OntObject>, Set<Node>>)res);
    }

    public static OntPersonality.Reserved createReservedVocabulary(OntVocabulary voc) {
        Objects.requireNonNull(voc);
        HashMap<Class<? extends Resource>, Set<Node>> res = new HashMap<Class<? extends Resource>, Set<Node>>();
        res.put(Resource.class, Iter.asUnmodifiableNodeSet(voc.getSystemResources()));
        res.put(Property.class, Iter.asUnmodifiableNodeSet(voc.getSystemProperties()));
        return new VocabularyImpl.ReservedIml((Map<Class<? extends Resource>, Set<Node>>)res);
    }

    private static OntPersonality.Punnings createPunningsVocabulary(StdMode mode) {
        HashMap<Class<? extends OntObject>, Set<Node>> res = new HashMap<Class<? extends OntObject>, Set<Node>>();
        if (!StdMode.LAX.equals((Object)mode)) {
            OntModelConfig.toMap(res, OntClass.Named.class, (RDFNode[])new Resource[]{RDFS.Datatype});
            OntModelConfig.toMap(res, OntDataRange.Named.class, (RDFNode[])new Resource[]{OWL.Class});
        }
        if (StdMode.STRICT.equals((Object)mode)) {
            OntModelConfig.toMap(res, OntAnnotationProperty.class, (RDFNode[])new Resource[]{OWL.ObjectProperty, OWL.DatatypeProperty});
            OntModelConfig.toMap(res, OntDataProperty.class, (RDFNode[])new Resource[]{OWL.ObjectProperty, OWL.AnnotationProperty});
            OntModelConfig.toMap(res, OntObjectProperty.Named.class, (RDFNode[])new Resource[]{OWL.DatatypeProperty, OWL.AnnotationProperty});
        }
        if (StdMode.MEDIUM.equals((Object)mode)) {
            OntModelConfig.toMap(res, OntDataProperty.class, (RDFNode[])new Resource[]{OWL.ObjectProperty});
            OntModelConfig.toMap(res, OntObjectProperty.Named.class, (RDFNode[])new Resource[]{OWL.DatatypeProperty});
        }
        OntEntity.listEntityTypes().forEachRemaining(t -> res.computeIfAbsent((Class<? extends OntObject>)t, k -> Collections.emptySet()));
        return new VocabularyImpl.EntitiesImpl((Map<Class<? extends OntObject>, Set<Node>>)res);
    }

    @SafeVarargs
    private static <K, V extends RDFNode> void toMap(Map<K, Set<Node>> map, K key, V ... values) {
        map.put(key, Arrays.stream(values).map(FrontsNode::asNode).collect(Iter.toUnmodifiableSet()));
    }

    static {
        personality = ONT_PERSONALITY_MEDIUM = OntModelConfig.getPersonalityBuilder().setBuiltins(BUILTINS).setReserved(RESERVED).setPunnings(StdMode.MEDIUM.getVocabulary()).build();
    }

    public static enum StdMode {
        STRICT,
        MEDIUM,
        LAX;

        private OntPersonality.Punnings punnings;

        public OntPersonality.Punnings getVocabulary() {
            return this.punnings == null ? (this.punnings = OntModelConfig.createPunningsVocabulary(this)) : this.punnings;
        }
    }
}

