/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.jena.impl.conf;

import com.github.owlcs.ontapi.jena.OntJenaException;
import com.github.owlcs.ontapi.jena.impl.conf.BaseFactoryImpl;
import com.github.owlcs.ontapi.jena.impl.conf.OntFilter;
import com.github.owlcs.ontapi.jena.impl.conf.OntFinder;
import com.github.owlcs.ontapi.jena.impl.conf.OntMaker;
import java.util.Objects;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.EnhNode;
import org.apache.jena.graph.Node;
import org.apache.jena.util.iterator.ExtendedIterator;

public class CommonFactoryImpl
extends BaseFactoryImpl {
    private final OntMaker maker;
    private final OntFinder finder;
    private final OntFilter filter;

    public CommonFactoryImpl(OntMaker maker, OntFinder finder, OntFilter filter) {
        this.maker = Objects.requireNonNull(maker, "Null maker.");
        this.finder = Objects.requireNonNull(finder, "Null finder.");
        this.filter = Objects.requireNonNull(filter, "Null filter.");
    }

    public OntMaker getMaker() {
        return this.maker;
    }

    public OntFinder getFinder() {
        return this.finder;
    }

    public OntFilter getFilter() {
        return this.filter;
    }

    @Override
    public EnhNode wrap(Node node, EnhGraph eg) {
        if (!this.canWrap(node, eg)) {
            throw new OntJenaException.Conversion(String.format("Can't wrap node %s to %s", node, this.maker.getImpl()));
        }
        return this.createInstance(node, eg);
    }

    @Override
    public boolean canWrap(Node node, EnhGraph eg) {
        return this.filter.test(node, eg);
    }

    @Override
    public EnhNode createInGraph(Node node, EnhGraph eg) {
        if (!this.canCreateInGraph(node, eg)) {
            throw new OntJenaException.Creation(String.format("Can't modify graph for %s (%s)", node, this.maker.getImpl()));
        }
        this.maker.make(node, eg);
        return this.createInstance(node, eg);
    }

    @Override
    public boolean canCreateInGraph(Node node, EnhGraph eg) {
        return this.maker.getTester().test(node, eg);
    }

    @Override
    public ExtendedIterator<EnhNode> iterator(EnhGraph eg) {
        return this.finder.restrict(this.filter).iterator(eg).mapWith(n -> this.maker.instance((Node)n, eg));
    }

    @Override
    public EnhNode createInstance(Node node, EnhGraph eg) {
        return this.maker.instance(node, eg);
    }
}

